/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.capability;

import com.idark.valoria.core.capability.IMagmaLevel;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.MagmaPacket;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.INBTSerializable;

public class MagmaLevelProvider
implements IMagmaLevel,
INBTSerializable<CompoundTag> {
    public float magmaAmount = 0.0f;
    private float maxMagmaAmount = 0.0f;

    @Override
    public void modifyAmount(@Nullable LivingEntity entity, float amount) {
        this.setAmountFromServer(entity, this.magmaAmount + amount);
    }

    public void modifyMaxAmount(@Nullable LivingEntity entity, float amount) {
        this.setMaxAmountFromServer(entity, this.maxMagmaAmount + amount);
    }

    @Override
    public void decrease(LivingEntity player, float amount) {
        this.modifyAmount(player, -amount);
    }

    @Override
    public void setAmount(float amount) {
        this.magmaAmount = Math.max(Math.min(amount, this.maxMagmaAmount), 0.0f);
    }

    @Override
    public void setAmountFromServer(@Nullable LivingEntity entity, float amount) {
        float max = this.getMaxAmount(entity);
        this.magmaAmount = amount > max ? max : Math.max(amount, 0.0f);
        this.sendDataToClient(entity);
    }

    public void setMaxAmountFromServer(@Nullable LivingEntity entity, float amount) {
        this.maxMagmaAmount = Math.max(amount, 0.0f);
        this.sendDataToClient(entity);
    }

    @Override
    public float getAmount() {
        return this.magmaAmount;
    }

    @Override
    public void addMaxAmount(LivingEntity player, float amount) {
        this.modifyMaxAmount(player, amount);
    }

    @Override
    public void decreaseMaxAmount(LivingEntity player, float amount) {
        this.modifyMaxAmount(player, -amount);
    }

    @Override
    public void setMaxAmount(float max) {
        this.maxMagmaAmount = max;
    }

    @Override
    public float getMaxAmount(@Nullable LivingEntity entity) {
        return this.maxMagmaAmount;
    }

    private void sendDataToClient(@Nullable LivingEntity entity) {
        if (entity == null || !(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        PacketHandler.sendTo(player, (Object)new MagmaPacket(this, (LivingEntity)player));
    }

    public CompoundTag serializeNBT() {
        CompoundTag wrapper = new CompoundTag();
        wrapper.m_128350_("magma_level", this.magmaAmount);
        return wrapper;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.magmaAmount = nbt.m_128457_("magma_level");
    }
}

