/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.compat.jei.categories;

import com.idark.valoria.Valoria;
import com.idark.valoria.core.compat.jei.ModRecipeTypes;
import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.item.component.MaterialListComponent;
import com.idark.valoria.registries.item.recipe.AlchemyUpgradeRecipe;
import com.idark.valoria.registries.item.recipe.RecipeData;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class AlchemyUpgradeRecipeCategory
extends AbstractRecipeCategory<AlchemyUpgradeRecipe> {
    public static final int width = 112;
    public static final int height = 48;

    public AlchemyUpgradeRecipeCategory(IGuiHelper helper) {
        super(ModRecipeTypes.ALCHEMY_UPGRADE, (Component)Component.m_237115_((String)"jei.valoria.alchemy_upgrade"), helper.createDrawableItemLike((ItemLike)BlockRegistry.alchemyStationTier2.get()), 112, 48);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlchemyUpgradeRecipe recipe, IFocusGroup focuses) {
        ItemStack result = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 48, 14).addItemStack(result);
        for (Pair<Ingredient, RecipeData> input : recipe.getInputs()) {
            builder.addSlot(RecipeIngredientRole.INPUT, Integer.MAX_VALUE, Integer.MAX_VALUE).addItemStacks(Arrays.stream(((Ingredient)input.getFirst()).m_43908_()).toList());
        }
    }

    @NotNull
    private ResourceLocation getUpgradeLoc(int tier) {
        return Valoria.loc("alchemy/upgrade/alchemy_upgrade_" + tier);
    }

    public void getTooltip(ITooltipBuilder tooltip, AlchemyUpgradeRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        super.getTooltip(tooltip, (Object)recipe, recipeSlotsView, mouseX, mouseY);
        ItemStack result = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
        if (!recipe.getInputs().isEmpty()) {
            tooltip.add((FormattedText)result.m_41786_().m_6881_().m_130948_(result.m_41611_().m_7383_()));
            tooltip.add((TooltipComponent)new MaterialListComponent(recipe.getInputs()));
        }
    }

    public void draw(AlchemyUpgradeRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        ResourceLocation tex = new ResourceLocation("valoria", "textures/gui/jei/workbench.png");
        guiGraphics.m_280163_(tex, 0, 0, 0.0f, 0.0f, 112, 48, 256, 256);
    }

    public ResourceLocation getRegistryName(AlchemyUpgradeRecipe recipe) {
        return recipe.m_6423_();
    }
}

