/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets;

import com.idark.valoria.client.ui.menus.AlchemyStationMenu;
import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.block.types.AlchemyStationBlock;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class AlchemyUpgradePacket {
    public int level;

    public AlchemyUpgradePacket(int level) {
        this.level = level;
    }

    public static void encode(AlchemyUpgradePacket object, FriendlyByteBuf buffer) {
        buffer.writeInt(object.level);
    }

    public static AlchemyUpgradePacket decode(FriendlyByteBuf buffer) {
        return new AlchemyUpgradePacket(buffer.m_130242_());
    }

    public static void handle(AlchemyUpgradePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level level = player.m_9236_();
            AbstractContainerMenu patt1120$temp = player.f_36096_;
            if (patt1120$temp instanceof AlchemyStationMenu) {
                AlchemyStationMenu heavyMenu = (AlchemyStationMenu)patt1120$temp;
                player.m_6915_();
                BlockState state = level.m_8055_(heavyMenu.getPos());
                Block patt1316$temp = state.m_60734_();
                if (patt1316$temp instanceof AlchemyStationBlock) {
                    AlchemyStationBlock stationBlock = (AlchemyStationBlock)patt1316$temp;
                    BlockState toState = switch (stationBlock.level) {
                        case 1 -> ((Block)BlockRegistry.alchemyStationTier2.get()).m_49966_();
                        case 2 -> ((Block)BlockRegistry.alchemyStationTier3.get()).m_49966_();
                        case 3 -> ((Block)BlockRegistry.alchemyStationTier4.get()).m_49966_();
                        default -> ((Block)BlockRegistry.alchemyStationTier1.get()).m_49966_();
                    };
                    stationBlock.upgrade(heavyMenu.getPos(), state, level, toState);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

