/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets;

import com.idark.valoria.core.capability.INihilityLevel;
import com.idark.valoria.core.capability.NihilityLevelProvider;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class NihilityPacket {
    private final float max;
    private final float nihilityLevel;

    public NihilityPacket(float max, float amount) {
        this.max = max;
        this.nihilityLevel = amount;
    }

    public NihilityPacket(INihilityLevel nihility, @Nullable LivingEntity entity) {
        this.max = nihility.getMaxAmount(entity);
        this.nihilityLevel = nihility.getAmount();
    }

    public static void encode(NihilityPacket object, FriendlyByteBuf buffer) {
        buffer.writeFloat(object.max);
        buffer.writeFloat(object.nihilityLevel);
    }

    public static NihilityPacket decode(FriendlyByteBuf buffer) {
        return new NihilityPacket(buffer.readFloat(), buffer.readFloat());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            player.getCapability(NihilityLevelProvider.INSTANCE).ifPresent(nihility -> {
                nihility.setMaxAmount(this.max);
                nihility.setAmount(this.nihilityLevel);
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

