/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import com.idark.valoria.util.Pal;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.behavior.SparkParticleBehavior;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.math.Interp;

public class AlchemyUpgradeParticlePacket {
    private final double posX;
    private final double posY;
    private final double posZ;
    private final int tier;

    public AlchemyUpgradeParticlePacket(int tier, double posX, double posY, double posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.tier = tier;
    }

    public static AlchemyUpgradeParticlePacket decode(FriendlyByteBuf buf) {
        return new AlchemyUpgradeParticlePacket(buf.readInt(), buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static void handle(AlchemyUpgradeParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                ColorParticleData data = msg.tier == 2 ? ColorParticleData.create((Col)Pal.vividPink, (Col)Pal.darkRed).setEasing((Interp)Interp.bounceOut).build() : (msg.tier == 3 ? ColorParticleData.create().setRandomColor().setEasing((Interp)Interp.bounceOut).build() : (msg.tier == 4 ? ColorParticleData.create((Col)Pal.amethyst, (Col)Pal.americanViolet).setEasing((Interp)Interp.bounceOut).build() : ColorParticleData.create().setRandomColor().setEasing((Interp)Interp.bounceOut).build()));
                Level level = Valoria.proxy.getLevel();
                ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.SQUARE).setBehavior(SparkParticleBehavior.create().build()).setScaleData(GenericParticleData.create((float)0.0725f, (float)0.025f, (float)0.0f).setEasing((Interp)Interp.bounce).build()).setLifetime(15).setColorData(data).randomVelocity(1.0, 1.0, 1.0)).setGravity(0.25f).setHasPhysics(false).repeat(level, msg.posX, msg.posY, msg.posZ, 64);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.tier);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }
}

