/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.gfx.particle.data.SpinParticleData;
import pro.komaru.tridot.client.gfx.particle.data.SpriteParticleData;
import pro.komaru.tridot.client.gfx.particle.options.BlockParticleOptions;
import pro.komaru.tridot.client.gfx.particle.options.GenericParticleOptions;
import pro.komaru.tridot.client.render.TridotRenderTypes;

public class CrushParticlePacket {
    private final BlockPos feetPos;
    private final double spawnX;
    private final double spawnY;
    private final double spawnZ;

    public CrushParticlePacket(BlockPos feetBlockPos, double spawnX, double spawnY, double spawnZ) {
        this.feetPos = feetBlockPos;
        this.spawnX = spawnX;
        this.spawnY = spawnY;
        this.spawnZ = spawnZ;
    }

    public static CrushParticlePacket decode(FriendlyByteBuf buf) {
        return new CrushParticlePacket(buf.m_130135_(), buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static void handle(CrushParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Level level = Valoria.proxy.getLevel();
                if (level != null) {
                    BlockParticleOptions opt = new BlockParticleOptions((ParticleType)TridotParticles.BLOCK.get(), level.m_8055_(msg.feetPos));
                    ((ParticleBuilder)((ParticleBuilder)ParticleBuilder.create((GenericParticleOptions)opt).setRenderType(TridotRenderTypes.TRANSLUCENT_BLOCK_PARTICLE).setSpinData(SpinParticleData.create().randomOffset().randomSpin(0.5f).build()).setScaleData(GenericParticleData.create((float)0.15f, (float)0.02f, (float)0.0f).build()).setSpriteData(SpriteParticleData.CRUMBS_RANDOM).setLifetime(30).randomVelocity(0.45, 0.75, 0.45)).randomOffset(0.125, 0.125)).setGravity(0.75f).repeat(level, msg.spawnX, msg.spawnY, msg.spawnZ, 64);
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.feetPos);
        buf.writeDouble(this.spawnX);
        buf.writeDouble(this.spawnY);
        buf.writeDouble(this.spawnZ);
    }
}

