/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries;

import com.idark.valoria.Valoria;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.TagsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeTier;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemTierRegistry {
    public static Tier BLAZE_REAP = ItemTierRegistry.registerTier((Tier)new ForgeTier(6, 1561, 10.0f, 4.0f, 15, TagsRegistry.NEEDS_BLAZEREAP_TOOL, Ingredient::m_151265_), Valoria.loc("blazereap"));
    public static Tier NONE = ItemTierRegistry.registerTier((Tier)new ForgeTier(4, 1561, 10.0f, 4.0f, 15, TagsRegistry.NEEDS_NONE_TOOL, Ingredient::m_151265_), Valoria.loc("none"));
    public static Tier BRONZE = TierSortingRegistry.registerTier((Tier)new ForgeTier(2, 1048, 4.0f, 0.0f, 8, TagsRegistry.NEEDS_BRONZE_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.bronzeIngot.get()})), (ResourceLocation)Valoria.loc("bronze"), List.of(Tiers.STONE), List.of(Tiers.IRON));
    public static Tier PEARLIUM = ItemTierRegistry.registerTier((Tier)new ForgeTier(3, 425, 5.0f, 2.0f, 6, TagsRegistry.NEEDS_PEARLIUM_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.pearliumIngot.get()})), Valoria.loc("pearlium"));
    public static Tier HOLIDAY = ItemTierRegistry.registerTier((Tier)new ForgeTier(2, 740, 5.0f, 2.0f, 8, TagsRegistry.NEEDS_HOLIDAY_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.holidayCandy.get()})), Valoria.loc("holiday"));
    public static Tier HALLOWEEN = ItemTierRegistry.registerTier((Tier)new ForgeTier(3, 1150, 6.0f, 3.0f, 8, TagsRegistry.NEEDS_HALLOWEEN_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.candyCorn.get()})), Valoria.loc("halloween"));
    public static Tier SAMURAI = ItemTierRegistry.registerTier((Tier)new ForgeTier(3, 1250, 10.0f, 5.0f, 7, TagsRegistry.NEEDS_SAMURAI_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.ancientIngot.get()})), Valoria.loc("samurai"));
    public static Tier COBALT = TierSortingRegistry.registerTier((Tier)new ForgeTier(4, 1750, 12.0f, 4.0f, 12, TagsRegistry.NEEDS_COBALT_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.cobaltIngot.get()})), (ResourceLocation)Valoria.loc("cobalt"), List.of(Tiers.DIAMOND), List.of(Tiers.NETHERITE));
    public static Tier ETHEREAL = TierSortingRegistry.registerTier((Tier)new ForgeTier(4, 2025, 15.0f, 5.0f, 15, TagsRegistry.NEEDS_ETHEREAL_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.etherealShard.get()})), (ResourceLocation)Valoria.loc("ethereal"), List.of(Tiers.DIAMOND), List.of(Tiers.NETHERITE));
    public static Tier NATURE = TierSortingRegistry.registerTier((Tier)new ForgeTier(5, 2651, 17.0f, 8.0f, 17, TagsRegistry.NEEDS_NATURE_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.natureIngot.get()})), (ResourceLocation)Valoria.loc("nature"), List.of(Tiers.NETHERITE), List.of(Valoria.loc("depth")));
    public static Tier AQUARIUS = TierSortingRegistry.registerTier((Tier)new ForgeTier(5, 3256, 18.0f, 9.0f, 18, TagsRegistry.NEEDS_DEPTH_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.aquariusIngot.get()})), (ResourceLocation)Valoria.loc("depth"), List.of(Valoria.loc("nature")), List.of(Valoria.loc("infernal")));
    public static Tier INFERNAL = TierSortingRegistry.registerTier((Tier)new ForgeTier(5, 4256, 20.0f, 10.0f, 19, TagsRegistry.NEEDS_INFERNAL_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.infernalIngot.get()})), (ResourceLocation)Valoria.loc("infernal"), List.of(Valoria.loc("depth")), List.of(Valoria.loc("void")));
    public static Tier JADE = TierSortingRegistry.registerTier((Tier)new ForgeTier(5, 4112, 22.0f, 11.0f, 20, TagsRegistry.NEEDS_JADE_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.jade.get()})), (ResourceLocation)Valoria.loc("jade"), List.of(Tiers.NETHERITE), List.of(Valoria.loc("depth")));
    public static Tier SPIDER = TierSortingRegistry.registerTier((Tier)new ForgeTier(5, 2831, 22.0f, 11.0f, 15, TagsRegistry.NEEDS_SPIDER_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.spiderFang.get()})), (ResourceLocation)Valoria.loc("spider"), List.of(Tiers.NETHERITE), List.of(Valoria.loc("depth")));
    public static Tier PYRATITE = TierSortingRegistry.registerTier((Tier)new ForgeTier(6, 3112, 24.0f, 13.0f, 15, TagsRegistry.NEEDS_PYRATITE_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.pyratite.get()})), (ResourceLocation)Valoria.loc("pyratite"), List.of(Tiers.NETHERITE), List.of(Valoria.loc("depth")));
    public static Tier BLOOD = TierSortingRegistry.registerTier((Tier)new ForgeTier(5, 2431, 24.0f, 15.0f, 15, TagsRegistry.NEEDS_MEAT_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.painCrystal.get()})), (ResourceLocation)Valoria.loc("meat"), List.of(Tiers.NETHERITE), List.of(Valoria.loc("depth")));
    public static Tier NIHILITY = TierSortingRegistry.registerTier((Tier)new ForgeTier(5, 5248, 30.0f, 17.0f, 20, TagsRegistry.NEEDS_VOID_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.nihilityShard.get()})), (ResourceLocation)Valoria.loc("void"), List.of(Valoria.loc("infernal")), List.of(Valoria.loc("phantom")));
    public static Tier PHANTOM = TierSortingRegistry.registerTier((Tier)new ForgeTier(5, 6428, 35.0f, 20.0f, 20, TagsRegistry.NEEDS_PHANTOM_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.illusionStone.get()})), (ResourceLocation)Valoria.loc("phantom"), List.of(Valoria.loc("void")), List.of());

    public static List<ItemStack> getTieredItems(Tier tier) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Map.Entry entry : ForgeRegistries.ITEMS.getEntries()) {
            TieredItem tieredItem;
            Item item = (Item)entry.getValue();
            if (!(item instanceof TieredItem) || (tieredItem = (TieredItem)item).m_43314_() != tier) continue;
            list.add(item.m_7968_());
        }
        return list;
    }

    public static Tier registerTier(Tier tier, ResourceLocation loc) {
        return TierSortingRegistry.registerTier((Tier)tier, (ResourceLocation)loc, List.of(Tiers.STONE), List.of(Tiers.DIAMOND));
    }
}

