/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class BlockSimpleInventory
extends BlockEntity {
    private final SimpleContainer itemHandler = this.createItemHandler();

    public BlockSimpleInventory(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemHandler.m_19164_(i -> this.m_6596_());
    }

    private static void copyToInv(NonNullList<ItemStack> src, Container dest) {
        Preconditions.checkArgument((src.size() == dest.m_6643_() ? 1 : 0) != 0);
        for (int i = 0; i < src.size(); ++i) {
            dest.m_6836_(i, (ItemStack)src.get(i));
        }
    }

    public static void addHandPlayerItem(Level level, Player player, InteractionHand hand, ItemStack stack, ItemStack addStack) {
        if (player.m_150109_().m_36050_(addStack) >= 0) {
            BlockSimpleInventory.addPlayerItem(level, player, addStack);
        } else if (stack.m_41619_()) {
            player.m_21008_(hand, addStack.m_41777_());
        } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)addStack) && stack.m_41613_() + addStack.m_41613_() <= addStack.m_41741_()) {
            stack.m_41764_(stack.m_41613_() + addStack.m_41613_());
            player.m_21008_(hand, stack);
        } else {
            BlockSimpleInventory.addPlayerItem(level, player, addStack);
        }
    }

    public static void addPlayerItem(Level level, Player player, ItemStack addStack) {
        if (player.m_150109_().m_36050_(addStack) != -1 || player.m_150109_().m_36062_() > -1) {
            player.m_150109_().m_36054_(addStack.m_41777_());
        } else {
            level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), addStack.m_41777_()));
        }
    }

    private static NonNullList<ItemStack> copyFromInv(Container inv) {
        NonNullList ret = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ret.set(i, (Object)inv.m_8020_(i));
        }
        return ret;
    }

    public void m_142466_(CompoundTag tag) {
        NonNullList tmp = NonNullList.m_122780_((int)this.inventorySize(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)tmp);
        BlockSimpleInventory.copyToInv((NonNullList<ItemStack>)tmp, (Container)this.itemHandler);
        super.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tag) {
        ContainerHelper.m_18973_((CompoundTag)tag, BlockSimpleInventory.copyFromInv((Container)this.itemHandler));
    }

    public final int inventorySize() {
        return this.getItemHandler().m_6643_();
    }

    protected abstract SimpleContainer createItemHandler();

    public final Container getItemHandler() {
        return this.itemHandler;
    }
}

