/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.types;

import com.idark.valoria.core.mixin.MobAmbientSoundInvoker;
import com.idark.valoria.registries.block.entity.BossTrophyBlockEntity;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;

public class BossTrophyBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private Supplier<EntityType<?>> entity;

    public BossTrophyBlock(Supplier<EntityType<?>> entity, BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.entity = entity;
    }

    public BossTrophyBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.entity = null;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(pContext).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED});
    }

    public Supplier<EntityType<?>> getEntity() {
        return this.entity;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return BossTrophyBlock.createShape();
    }

    private static VoxelShape createShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.1875, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.1875, (double)0.25, (double)0.75, (double)0.3125, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.25, (double)0.0625, (double)0.9375, (double)0.5625, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.1875, (double)0.0625, (double)0.625, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.1875, (double)0.375, (double)0.9375, (double)0.25, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState p_222503_, Level p_222504_, BlockPos p_222505_, RandomSource p_222506_) {
        int i = p_222505_.m_123341_();
        int j = p_222505_.m_123342_();
        int k = p_222505_.m_123343_();
        double d0 = (double)i + p_222506_.m_188500_();
        double d1 = (double)j + 0.7;
        double d2 = (double)k + p_222506_.m_188500_();
        ((ParticleBuilder)((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.SPARKLE).setVelocity(0.025, 0.05, 0.025)).disablePhysics().setGravity(0.0f).randomOffset(0.5)).setScaleData(GenericParticleData.create((float)0.05f, (float)0.02f, (float)0.0f).build()).repeat(p_222504_, d0, d1, d2, 2);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof BossTrophyBlockEntity) {
            BossTrophyBlockEntity trophyBlockEntity = (BossTrophyBlockEntity)blockEntity;
            if (this.entity != null) {
                trophyBlockEntity.setEntity(this.entity.get().m_20615_(pLevel));
            }
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack heldStack = pPlayer.m_21120_(pHand);
        BlockEntity tile = pLevel.m_7702_(pPos);
        if (tile instanceof BossTrophyBlockEntity) {
            Item item;
            BossTrophyBlockEntity trophyBlockEntity = (BossTrophyBlockEntity)tile;
            if (pPlayer.m_7500_() && (item = heldStack.m_41720_()) instanceof SpawnEggItem) {
                SpawnEggItem egg = (SpawnEggItem)item;
                trophyBlockEntity.setEntity(egg.m_43228_(heldStack.m_41783_()).m_20615_(pLevel));
                return InteractionResult.SUCCESS;
            }
            if (!(heldStack.m_41720_() instanceof SpawnEggItem)) {
                if (trophyBlockEntity.entity == null) {
                    return InteractionResult.FAIL;
                }
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("id", ForgeRegistries.ENTITY_TYPES.getKey(trophyBlockEntity.entity).toString());
                Entity entity = EntityType.m_20645_((CompoundTag)tag, (Level)pLevel, Function.identity());
                if (entity != null && entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    if (((MobAmbientSoundInvoker)mob).invokeGetAmbientSound() == null) {
                        return InteractionResult.FAIL;
                    }
                    pLevel.m_247517_(null, pPos, ((MobAmbientSoundInvoker)mob).invokeGetAmbientSound(), SoundSource.AMBIENT);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new BossTrophyBlockEntity(pPos, pState);
    }
}

