/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.types;

import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.particle.CrusherParticlePacket;
import com.idark.valoria.registries.TagsRegistry;
import com.idark.valoria.registries.block.entity.BlockSimpleInventory;
import com.idark.valoria.registries.block.entity.CrusherBlockEntity;
import com.idark.valoria.registries.item.recipe.CrusherRecipe;
import com.idark.valoria.util.ValoriaUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class CrusherBlock
extends Block
implements EntityBlock {
    public CrusherBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static boolean isValid(ItemStack stack, CrusherBlockEntity tile) {
        Optional<CrusherRecipe> recipeOptional = tile.getCurrentRecipe();
        if (recipeOptional.isPresent()) {
            CrusherRecipe recipe = recipeOptional.get();
            NonNullList<Ingredient> recipeIngredients = recipe.m_7527_();
            for (Ingredient ingredient : recipeIngredients) {
                if (!ingredient.test(stack)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CrusherBlockEntity(pPos, pState);
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof BlockSimpleInventory) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((BlockSimpleInventory)tile).getItemHandler());
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        CrusherBlockEntity tile = (CrusherBlockEntity)world.m_7702_(pos);
        ItemStack stack = player.m_21120_(handIn).m_41777_();
        ItemStack tileStack = tile.getItemHandler().m_8020_(0);
        if (tileStack.m_41619_()) {
            this.placeItem(player, handIn, tile, stack);
            return InteractionResult.SUCCESS;
        }
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            if (stack.m_204117_(TagsRegistry.STONE_CRUSHER_TOOL) && CrusherBlock.isValid(tileStack, tile)) {
                this.crushItem(world, player, handIn, tile);
                PacketHandler.sendToTracking((Level)server, pos, new CrusherParticlePacket((float)pos.m_123341_() + 0.5f, pos.m_123342_() + 1, (float)pos.m_123343_() + 0.5f, tileStack));
            } else {
                this.extractItem(world, player, tileStack, tile);
            }
        }
        ValoriaUtils.SUpdateTileEntityPacket(tile);
        return InteractionResult.SUCCESS;
    }

    private void crushItem(Level world, Player player, InteractionHand handIn, CrusherBlockEntity tile) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            tile.craftItem(serverPlayer);
            player.m_21120_(handIn).m_41622_(world.m_213780_().m_216339_(0, 2), (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21166_(EquipmentSlot.MAINHAND));
        }
    }

    private void extractItem(Level world, Player player, ItemStack tileStack, CrusherBlockEntity tile) {
        if (!player.m_7500_()) {
            world.m_7967_((Entity)new ItemEntity(world, player.m_20185_() + 0.5, player.m_20186_() + 0.5, player.m_20189_() + 0.5, tileStack.m_41777_()));
        }
        tile.getItemHandler().m_7407_(0, tileStack.m_41613_());
    }

    private void placeItem(Player player, InteractionHand handIn, CrusherBlockEntity tile, ItemStack stack) {
        tile.getItemHandler().m_6836_(0, stack);
        if (!player.m_7500_()) {
            player.m_150109_().m_36057_(player.m_21120_(handIn));
        }
        ValoriaUtils.SUpdateTileEntityPacket(tile);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int id, int param) {
        super.m_8133_(state, world, pos, id, param);
        BlockEntity tile = world.m_7702_(pos);
        return tile != null && tile.m_7531_(id, param);
    }
}

