/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.idark.valoria.Valoria;
import com.idark.valoria.core.interfaces.ReputationTypes;
import com.idark.valoria.core.trades.MerchantTrades;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.entity.ai.brains.HauntedMerchantAI;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.gossip.GossipContainer;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHauntedMerchant
extends Monster
implements NeutralMob,
InventoryCarrier,
ReputationEventHandler,
Merchant {
    @Nullable
    public UUID persistentAngerTarget;
    @Nullable
    private Player tradingPlayer;
    private Player lastTradedPlayer;
    public static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(AbstractHauntedMerchant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @Nullable
    protected MerchantOffers offers;
    private final SimpleContainer inventory = new SimpleContainer(8);
    private final GossipContainer gossips = new GossipContainer();
    private long lastGossipTime;
    private long lastGossipDecayTime;
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26367_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26374_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26323_, (Object)MemoryModuleType.f_26326_);
    private static final ImmutableList<SensorType<? extends Sensor<? super AbstractHauntedMerchant>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_);

    protected AbstractHauntedMerchant(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public Brain<AbstractHauntedMerchant> m_6274_() {
        return super.m_6274_();
    }

    protected Brain.Provider<AbstractHauntedMerchant> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> pDynamic) {
        Brain brain = this.m_5490_().m_22073_(pDynamic);
        this.registerBrainGoals((Brain<AbstractHauntedMerchant>)brain);
        return brain;
    }

    private void registerBrainGoals(Brain<AbstractHauntedMerchant> pBrain) {
        pBrain.m_21944_(Activity.f_37979_);
        pBrain.m_21889_(Activity.f_37979_);
        pBrain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        pBrain.m_21900_(Activity.f_37978_, HauntedMerchantAI.getCorePackage(1.0f));
        if (this.m_5448_() == null) {
            pBrain.m_21900_(Activity.f_37979_, HauntedMerchantAI.getIdlePackage(1.0f));
        }
        pBrain.m_21862_(this.m_9236_().m_46468_(), this.m_9236_().m_46467_());
        pBrain.m_21962_();
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    protected void m_8024_() {
        ServerLevel serverlevel = (ServerLevel)this.m_9236_();
        serverlevel.m_46473_().m_6180_("hauntedMerchantBrain");
        this.m_6274_().m_21865_(serverlevel, (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        HauntedMerchantAI.updateActivity(this);
        if (this.lastTradedPlayer != null) {
            serverlevel.m_8670_(ReputationEventType.f_26989_, (Entity)this.lastTradedPlayer, (ReputationEventHandler)this);
            this.m_9236_().m_7605_((Entity)this, (byte)14);
            this.lastTradedPlayer = null;
        }
        super.m_8024_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        this.maybeDecayGossip();
    }

    public void setupAnimationStates() {
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_8028_() {
        return false;
    }

    public SoundEvent m_7596_() {
        return (SoundEvent)SoundsRegistry.HAUNTED_MERCHANT_YES.get();
    }

    protected SoundEvent getTradeUpdatedSound(boolean pIsYesSound) {
        return pIsYesSound ? (SoundEvent)SoundsRegistry.HAUNTED_MERCHANT_YES.get() : (SoundEvent)SoundsRegistry.HAUNTED_MERCHANT_NO.get();
    }

    @Nullable
    public SoundEvent m_7515_() {
        return this.isTrading() ? (SoundEvent)SoundsRegistry.HAUNTED_MERCHANT_YES.get() : (SoundEvent)SoundsRegistry.HAUNTED_MERCHANT_IDLE.get();
    }

    public SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundsRegistry.HAUNTED_MERCHANT_HURT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)SoundsRegistry.HAUNTED_MERCHANT_DEATH.get();
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    public SlotAccess m_141942_(int pSlot) {
        int i = pSlot - 300;
        return i >= 0 && i < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)i) : super.m_141942_(pSlot);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.m_21678_(pCompound);
        MerchantOffers merchantoffers = this.m_6616_();
        if (!merchantoffers.isEmpty()) {
            pCompound.m_128365_("Offers", (Tag)merchantoffers.m_45388_());
        }
        pCompound.m_128365_("Gossips", (Tag)this.gossips.m_262795_((DynamicOps)NbtOps.f_128958_));
        this.m_252802_(pCompound);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_147285_(this.m_9236_(), pCompound);
        if (pCompound.m_128425_("Offers", 10)) {
            this.offers = new MerchantOffers(pCompound.m_128469_("Offers"));
        }
        ListTag listtag = pCompound.m_128437_("Gossips", 10);
        this.gossips.m_26177_(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)listtag));
        this.m_253224_(pCompound);
    }

    public void m_7189_(@Nullable Player pPlayer) {
        boolean flag = this.m_7962_() != null && pPlayer == null;
        this.tradingPlayer = pPlayer;
        if (flag) {
            this.stopTrading();
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        boolean isClientside = this.m_9236_().f_46443_;
        if (!(itemstack.m_150930_((Item)ItemsRegistry.pumpkinContract.get()) || !this.m_6084_() || this.isTrading() || this.m_6616_().isEmpty() || isClientside || this.m_5448_() == pPlayer)) {
            this.startTrading(pPlayer);
            return InteractionResult.m_19078_((boolean)false);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void m_6667_(DamageSource pCause) {
        Valoria.LOGGER.info("Merchant: {} died, message: '{}'", (Object)this, (Object)pCause.m_6157_((LivingEntity)this).getString());
        Entity entity = pCause.m_7639_();
        if (entity != null) {
            this.tellWitnessesThatIWasMurdered(entity);
        }
        super.m_6667_(pCause);
    }

    public void tellWitnessesThatIWasMurdered(Entity pMurderer) {
        Level $$3 = this.m_9236_();
        if ($$3 instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)$$3;
            Optional optional = this.f_20939_.m_21952_(MemoryModuleType.f_148205_);
            optional.ifPresent(nearestVisibleLivingEntities -> nearestVisibleLivingEntities.m_186123_(ReputationEventHandler.class::isInstance).forEach(p_186297_ -> serverlevel.m_8670_(ReputationTypes.MERCHANT_KILLED, pMurderer, (ReputationEventHandler)p_186297_)));
        }
    }

    public void gossip(ServerLevel pServerLevel, AbstractHauntedMerchant pTarget, long pGameTime) {
        if (!(pGameTime >= this.lastGossipTime && pGameTime < this.lastGossipTime + 1200L || pGameTime >= pTarget.lastGossipTime && pGameTime < pTarget.lastGossipTime + 1200L)) {
            this.gossips.m_217762_(pTarget.gossips, this.f_19796_, 10);
            this.lastGossipTime = pGameTime;
            pTarget.lastGossipTime = pGameTime;
        }
    }

    public void maybeDecayGossip() {
        long i = this.m_9236_().m_46467_();
        if (this.lastGossipDecayTime == 0L) {
            this.lastGossipDecayTime = i;
        } else if (i >= this.lastGossipDecayTime + 24000L) {
            this.gossips.m_26198_();
            this.lastGossipDecayTime = i;
        }
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    public void startTrading(Player pPlayer) {
        this.updateSpecialPrices(pPlayer);
        this.m_7189_(pPlayer);
        this.m_45301_(pPlayer, this.m_5446_(), 1);
    }

    public int getPlayerReputation(Player pPlayer) {
        return this.gossips.m_26195_(pPlayer.m_20148_(), p_186302_ -> true);
    }

    private void updateSpecialPrices(Player pPlayer) {
        int i = this.getPlayerReputation(pPlayer);
        if (i != 0) {
            for (MerchantOffer merchantoffer : this.m_6616_()) {
                merchantoffer.m_45353_(-Mth.m_14143_((float)((float)i * merchantoffer.m_45378_())));
            }
        }
    }

    public boolean isTrading() {
        return this.tradingPlayer != null;
    }

    public MerchantOffers m_6616_() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.updateTrades();
        }
        return this.offers;
    }

    public void updateTrades() {
        VillagerTrades.ItemListing[] itemListings = (VillagerTrades.ItemListing[])MerchantTrades.HAUNTED_MERCHANT_TRADES.get(1);
        if (itemListings != null) {
            MerchantOffers merchantoffers = this.m_6616_();
            this.addOffersFromItemListings(merchantoffers, itemListings, 5);
        }
    }

    public void m_6255_(@Nullable MerchantOffers pOffers) {
    }

    public void m_6621_(int pXp) {
    }

    public void stopTrading() {
        this.m_7189_(null);
        this.resetSpecialPrices();
    }

    public void resetSpecialPrices() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            merchantoffer.m_45376_();
        }
    }

    public void m_6996_(MerchantOffer pOffer) {
        pOffer.m_45374_();
        this.f_21363_ = -this.m_8100_();
        this.rewardTradeXp(pOffer);
    }

    public void rewardTradeXp(MerchantOffer pOffer) {
        if (pOffer.m_45383_()) {
            int i = 3 + this.f_19796_.m_188503_(4);
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
        }
    }

    public void m_7713_(ItemStack pStack) {
        if (!this.m_9236_().f_46443_ && this.f_21363_ > -this.m_8100_() + 20) {
            this.f_21363_ = -this.m_8100_();
            this.m_5496_(this.getTradeUpdatedSound(!pStack.m_41619_()), this.m_6121_(), this.m_6100_());
        }
    }

    public int m_7809_() {
        return 0;
    }

    public boolean m_7826_() {
        return false;
    }

    public boolean m_183595_() {
        return this.m_9236_().f_46443_;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public void m_6703_(@Nullable LivingEntity pLivingBase) {
        if (pLivingBase != null && this.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.m_9236_()).m_8670_(ReputationTypes.MERCHANT_HURT, (Entity)pLivingBase, (ReputationEventHandler)this);
            if (this.m_6084_() && pLivingBase instanceof Player) {
                this.m_9236_().m_7605_((Entity)this, (byte)13);
            }
        }
        super.m_6703_(pLivingBase);
    }

    public void m_6814_(ReputationEventType pType, Entity pTarget) {
        if (pType == ReputationTypes.MONSTER_KILLED) {
            this.gossips.m_26191_(pTarget.m_20148_(), GossipType.MINOR_POSITIVE, 25);
        } else if (pType == ReputationEventType.f_26989_) {
            this.gossips.m_26191_(pTarget.m_20148_(), GossipType.TRADING, 2);
        } else if (pType == ReputationTypes.MERCHANT_HURT) {
            this.gossips.m_26191_(pTarget.m_20148_(), GossipType.MINOR_NEGATIVE, 25);
        } else if (pType == ReputationTypes.MERCHANT_KILLED) {
            this.gossips.m_26191_(pTarget.m_20148_(), GossipType.MAJOR_NEGATIVE, 25);
        }
    }

    public void addOffersFromItemListings(MerchantOffers pGivenMerchantOffers, VillagerTrades.ItemListing[] pNewTrades, int pMaxNumbers) {
        HashSet set = Sets.newHashSet();
        if (pNewTrades.length > pMaxNumbers) {
            while (set.size() < pMaxNumbers) {
                set.add(this.f_19796_.m_188503_(pNewTrades.length));
            }
        } else {
            for (int i = 0; i < pNewTrades.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.ItemListing villagertrades$itemlisting = pNewTrades[integer];
            MerchantOffer merchantoffer = villagertrades$itemlisting.m_213663_((Entity)this, this.f_19796_);
            if (merchantoffer == null) continue;
            pGivenMerchantOffers.add((Object)merchantoffer);
        }
    }
}

