/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.boss.dryador;

import com.idark.valoria.Valoria;
import com.idark.valoria.registries.EffectsRegistry;
import com.idark.valoria.registries.EntityStatsRegistry;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.entity.StaticAnimationState;
import com.idark.valoria.registries.entity.living.boss.IBossPhase;
import com.idark.valoria.registries.entity.living.boss.dryador.phases.BossPhase;
import com.idark.valoria.registries.entity.living.minions.PixieEntity;
import com.idark.valoria.registries.entity.projectile.AcornProjectile;
import com.idark.valoria.util.ValoriaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import pro.komaru.tridot.api.entity.AttackRegistry;
import pro.komaru.tridot.api.render.bossbars.ServerBossBar;
import pro.komaru.tridot.client.render.screenshake.PositionedScreenshakeInstance;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeHandler;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeInstance;
import pro.komaru.tridot.common.registry.entity.AbstractBoss;
import pro.komaru.tridot.common.registry.entity.MultiAttackMob;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.comps.phys.Pos3;
import pro.komaru.tridot.util.math.Interp;

public class DryadorEntity
extends AbstractBoss
implements RangedAttackMob {
    public final ServerBossBar bossEvent = new ServerBossBar(this.m_5446_(), Valoria.loc("basic")).setTexture(Valoria.loc("textures/gui/bossbars/dryador.png")).setDarkenScreen(true);
    private int spawnTime = 0;
    public final AnimationState idleAnimationState = new AnimationState();
    public int idleAnimationTimeout = 0;
    public AnimationState spawnAnimationState = new AnimationState();
    public StaticAnimationState phaseTransitionAnimationState = new StaticAnimationState();
    public StaticAnimationState rangedAttackAnimationState = new StaticAnimationState();
    public StaticAnimationState meleeAttackAnimationState = new StaticAnimationState();
    public StaticAnimationState summonAnimationState = new StaticAnimationState();
    public StaticAnimationState stompAnimationState = new StaticAnimationState();
    public IBossPhase currentPhase = new BossPhase((LivingEntity)this, () -> this.m_21223_() <= this.m_21233_() / 2.0f).setSound(SoundEvents.f_11669_);
    public static final AttackRegistry DRYADOR_RADIAL = new AttackRegistry("valoria", "dryador_radial");
    public boolean flag = !this.phaseTransitionAnimationState.m_216984_() && !this.meleeAttackAnimationState.m_216984_() && !this.rangedAttackAnimationState.m_216984_() && !this.summonAnimationState.m_216984_();
    public int animationTicks = 0;
    private final Map<Integer, List<BlockPos>> scheduledLifts = new HashMap<Integer, List<BlockPos>>();

    public DryadorEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 100;
    }

    public void m_6667_(DamageSource pDamageSource) {
        this.bossEvent.setAboutToDie(true);
        super.m_6667_(pDamageSource);
    }

    public boolean isBusy() {
        return this.phaseTransitionAnimationState.isPlaying || this.summonAnimationState.isPlaying || this.rangedAttackAnimationState.isPlaying || this.stompAnimationState.isPlaying || this.meleeAttackAnimationState.isPlaying;
    }

    public void m_7822_(byte pId) {
        if (pId == 62) {
            this.idleAnimationState.m_216973_();
            this.rangedAttackAnimationState.start(this.f_19797_, 60L);
        }
        if (pId == 61) {
            this.idleAnimationState.m_216973_();
            this.phaseTransitionAnimationState.start(this.f_19797_, 60L);
        }
        if (pId == 60) {
            this.idleAnimationState.m_216973_();
            this.summonAnimationState.start(this.f_19797_, 60L);
        }
        if (pId == 59) {
            this.idleAnimationState.m_216973_();
            this.meleeAttackAnimationState.start(this.f_19797_, 30L);
        }
        if (pId == 58) {
            this.idleAnimationState.m_216973_();
            this.stompAnimationState.start(this.f_19797_, 60L);
        }
        if (pId == 4) {
            this.idleAnimationState.m_216973_();
            this.meleeAttackAnimationState.start(this.f_19797_, 30L);
            this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        }
        super.m_7822_(pId);
    }

    private float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public boolean m_7327_(Entity pEntity) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float f = this.getAttackDamage();
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.f_19796_.m_188503_((int)f) : f;
        boolean flag = pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f1);
        if (flag) {
            double d2;
            if (pEntity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)pEntity;
                d2 = livingentity.m_21133_(Attributes.f_22278_);
            } else {
                d2 = 0.0;
            }
            double d0 = d2;
            double d1 = Math.max(0.0, 1.0 - d0);
            pEntity.m_20256_(pEntity.m_20184_().m_82520_(0.0, (double)0.4f * d1, 0.0));
            this.m_19970_((LivingEntity)this, pEntity);
        }
        this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        return flag;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12010_, 1.0f, 1.0f);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0 && this.flag) {
            this.idleAnimationTimeout = 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    private void amplifyStats() {
        this.m_21051_(Attributes.f_22284_).m_22118_(new AttributeModifier("modifier", (double)((float)this.m_9236_().m_46791_().m_19028_() * 0.5f), AttributeModifier.Operation.MULTIPLY_TOTAL));
        this.m_21051_(Attributes.f_22281_).m_22118_(new AttributeModifier("modifier", (double)((float)this.m_9236_().m_46791_().m_19028_() * 0.5f), AttributeModifier.Operation.ADDITION));
        this.m_21051_(Attributes.f_22279_).m_22118_(new AttributeModifier("modifier", (double)0.025f, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    public void checkPhaseTransition() {
        if (this.currentPhase.shouldTransition() && !this.currentPhase.playedSound()) {
            this.animationTicks = 90;
            this.f_21344_.m_26573_();
            this.phaseTransitionAnimationState.m_216977_(this.f_19797_);
            this.currentPhase.onEnter();
            this.amplifyStats();
        }
        if (this.phaseTransitionAnimationState.m_216984_()) {
            --this.animationTicks;
        }
    }

    public boolean m_6673_(DamageSource pSource) {
        return this.animationTicks > 0 && !pSource.m_269533_(DamageTypeTags.f_268738_) || super.m_6673_(pSource);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (this.m_8077_()) {
            this.bossEvent.setName(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.setName(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.addPlayer(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.removePlayer(pPlayer);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.setHealth(this.m_21223_(), this.m_21233_());
    }

    protected void m_7324_(@NotNull Entity pEntity) {
    }

    public void m_147240_(double strength, double x, double z) {
    }

    protected void m_6138_() {
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_(), p_31582_ -> p_31582_ instanceof LivingEntity);
        for (Entity entity : list) {
            if (!(this.m_20280_(entity) <= 1.0)) continue;
            entity.m_7334_((Entity)this);
        }
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundsRegistry.WICKED_CRYSTAL_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundsRegistry.WICKED_CRYSTAL_DEATH.get();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 32.0f));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(0, (Goal)new ThrowAcornsGoal());
        this.f_21345_.m_25352_(1, (Goal)new StompAttack());
        this.f_21345_.m_25352_(2, (Goal)new RadialAcornAttack());
        this.f_21345_.m_25352_(1, (Goal)new PixieSummonGoal());
        this.f_21345_.m_25352_(5, (Goal)new JumpToTargetGoal());
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
        this.m_5496_(SoundEvents.f_11821_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        for (int i = 0; i < 10; ++i) {
            AcornProjectile acorn = new AcornProjectile((LivingEntity)this, this.m_9236_());
            double d0 = pTarget.m_20185_() - this.m_20185_();
            double d1 = pTarget.m_20227_(0.3333333333333333) - this.m_20186_();
            double d2 = pTarget.m_20189_() - this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Tmp.rnd.chance(0.25f)) {
                acorn.addEffect(new MobEffectInstance((MobEffect)EffectsRegistry.STUN.get(), 60, 0));
            }
            acorn.m_6686_(d0, d1 + d3 * (double)0.2f, d2, pVelocity, 25 - this.m_9236_().m_46791_().m_19028_() * 4);
            this.m_9236_().m_7967_((Entity)acorn);
        }
    }

    public void m_8119_() {
        int currentTick;
        List<BlockPos> blocks;
        super.m_8119_();
        this.setupAnimationStates();
        this.checkPhaseTransition();
        if (this.spawnTime < 10) {
            ++this.spawnTime;
            this.spawnAnimationState.m_216977_(this.f_19797_);
        }
        if (!this.m_9236_().f_46443_ && (blocks = this.scheduledLifts.remove(currentTick = ((ServerLevel)this.m_9236_()).m_7654_().m_129921_())) != null) {
            for (BlockPos pos : blocks) {
                this.liftBlock(this.m_9236_(), pos);
            }
        }
    }

    private void liftBlock(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        FallingBlockEntity fallingBlock = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)state);
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        fallingBlock.m_149656_(4.0f, 15);
        fallingBlock.f_19864_ = true;
        fallingBlock.m_20334_(0.0, 0.5, 0.0);
    }

    public class ThrowAcornsGoal
    extends MultiAttackMob.AttackGoal {
        public ThrowAcornsGoal() {
            super((MultiAttackMob)DryadorEntity.this);
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            LivingEntity livingentity = DryadorEntity.this.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.m_6084_() && super.m_8036_()) {
                return DryadorEntity.this.cantReachTarget(livingentity) || DryadorEntity.this.m_20270_((Entity)livingentity) > 15.0f;
            }
            return false;
        }

        protected void performAttack() {
            DryadorEntity.this.m_6504_(DryadorEntity.this.m_5448_(), 1.0f);
        }

        public void onPrepare() {
            DryadorEntity.this.m_9236_().m_7605_((Entity)DryadorEntity.this, (byte)58);
        }

        public int getPreparingTime() {
            return 20;
        }

        public int getAttackInterval() {
            return 80;
        }

        @Nullable
        public SoundEvent getPrepareSound() {
            return null;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.THROW;
        }
    }

    public class StompAttack
    extends MultiAttackMob.AttackGoal {
        private final TargetingConditions targeting;

        public StompAttack() {
            super((MultiAttackMob)DryadorEntity.this);
            this.targeting = TargetingConditions.m_148352_().m_26883_(8.0).m_148355_().m_26893_();
        }

        public boolean m_8036_() {
            List entities = DryadorEntity.this.m_9236_().m_45971_(LivingEntity.class, this.targeting, (LivingEntity)DryadorEntity.this, DryadorEntity.this.m_20191_().m_82400_(8.0));
            return super.m_8036_() && DryadorEntity.this.m_5448_() != null && !entities.isEmpty() && DryadorEntity.this.flag;
        }

        public void onPrepare() {
            DryadorEntity.this.m_21573_().m_26573_();
            DryadorEntity.this.m_9236_().m_7605_((Entity)DryadorEntity.this, (byte)62);
            DryadorEntity.this.m_216990_((SoundEvent)SoundsRegistry.STOMP.get());
        }

        public void liftBlocksAround(Level level, BlockPos center, int radius) {
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            int currentTick = serverLevel.m_7654_().m_129921_();
            int radiusSqr = radius * radius;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + z * z >= radiusSqr) continue;
                    for (int y = -2; y <= 0; ++y) {
                        BlockPos pos = center.m_7918_(x, y, z);
                        BlockState state = level.m_8055_(pos);
                        if (state.m_60734_().m_155943_() == -1.0f || pos == center || state.m_60795_() || level.m_8055_(pos.m_7494_()).m_280296_() || !state.m_280296_()) continue;
                        serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), 4, DryadorEntity.this.f_19796_.m_188500_(), DryadorEntity.this.f_19796_.m_188500_(), DryadorEntity.this.f_19796_.m_188500_(), 0.0);
                        int delay = (int)Math.sqrt(pos.m_123331_((Vec3i)center)) * 5;
                        int scheduledTick = currentTick + delay;
                        DryadorEntity.this.scheduledLifts.computeIfAbsent(scheduledTick, k -> new ArrayList()).add(pos);
                    }
                }
            }
        }

        protected void performAttack() {
            this.liftBlocksAround(DryadorEntity.this.m_9236_(), DryadorEntity.this.m_20097_(), 8);
            ScreenshakeHandler.add((ScreenshakeInstance)new PositionedScreenshakeInstance(60, (Pos3)pro.komaru.tridot.util.phys.Vec3.from((Vec3)DryadorEntity.this.m_20182_()), 0.0f, 30.0f).interp((Interp)Interp.bounce).intensity(0.8f));
            Vector3d pos = new Vector3d(DryadorEntity.this.m_20185_(), DryadorEntity.this.m_20186_(), DryadorEntity.this.m_20189_());
            ValoriaUtils.stunNearby(DryadorEntity.this.m_9236_(), (LivingEntity)DryadorEntity.this, pos, 0.0f, DryadorEntity.this.m_20155_().f_82471_, 3.0f);
        }

        public int getPreparingTime() {
            return 40;
        }

        public int getAttackInterval() {
            return 600;
        }

        @Nullable
        public SoundEvent getPrepareSound() {
            return null;
        }

        public AttackRegistry getAttack() {
            return DRYADOR_RADIAL;
        }
    }

    public class RadialAcornAttack
    extends MultiAttackMob.AttackGoal {
        private final TargetingConditions targeting;

        public RadialAcornAttack() {
            super((MultiAttackMob)DryadorEntity.this);
            this.targeting = TargetingConditions.m_148352_().m_26883_(6.0).m_148355_().m_26893_();
        }

        public void onPrepare() {
            DryadorEntity.this.m_21573_().m_26573_();
            DryadorEntity.this.m_9236_().m_7605_((Entity)DryadorEntity.this, (byte)61);
        }

        public boolean m_8036_() {
            List entities = DryadorEntity.this.m_9236_().m_45971_(LivingEntity.class, this.targeting, (LivingEntity)DryadorEntity.this, DryadorEntity.this.m_20191_().m_82400_(6.0));
            return super.m_8036_() && DryadorEntity.this.m_5448_() != null && !entities.isEmpty() && DryadorEntity.this.flag;
        }

        private void summonAcorns(ServerLevel serverLevel, BlockPos spawnPos, float angle, double speed) {
            AcornProjectile acorn = (AcornProjectile)((EntityType)EntityTypeRegistry.ACORN.get()).m_20615_(DryadorEntity.this.m_9236_());
            if (acorn != null) {
                acorn.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_() + 2, (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
                acorn.m_5602_((Entity)DryadorEntity.this);
                if (DryadorEntity.this.currentPhase.shouldTransition() || Tmp.rnd.chance(0.15)) {
                    acorn.addEffect(new MobEffectInstance(MobEffects.f_19614_, 80, DryadorEntity.this.currentPhase.shouldTransition() ? 2 : 0));
                }
                double vx = Math.cos(angle) * speed;
                double vz = Math.sin(angle) * speed;
                acorn.m_20334_(vx, 0.4, vz);
                serverLevel.m_7967_((Entity)acorn);
            }
        }

        protected void performAttack() {
            float angle;
            int i;
            if (DryadorEntity.this.m_9236_().m_5776_()) {
                return;
            }
            ServerLevel serv = (ServerLevel)DryadorEntity.this.m_9236_();
            BlockPos center = DryadorEntity.this.m_20183_();
            for (i = 0; i < 12; ++i) {
                angle = (float)(0.5235987755982988 * (double)i);
                this.summonAcorns(serv, center, angle, 0.25);
            }
            if (Tmp.rnd.chance(0.25)) {
                for (i = 0; i < 6; ++i) {
                    angle = (float)(1.0471975511965976 * (double)i);
                    this.summonAcorns(serv, center.m_6630_(1), angle, 0.35 + DryadorEntity.this.f_19796_.m_188500_() * 0.3);
                }
            }
        }

        public int getPreparingTime() {
            return 60;
        }

        public int getAttackInterval() {
            return 350;
        }

        @Nullable
        public SoundEvent getPrepareSound() {
            return null;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.RADIAL;
        }
    }

    public class PixieSummonGoal
    extends MultiAttackMob.AttackGoal {
        private final TargetingConditions pixiesCount;

        public PixieSummonGoal() {
            super((MultiAttackMob)DryadorEntity.this);
            this.pixiesCount = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_().m_26893_();
        }

        public void onPrepare() {
            DryadorEntity.this.m_21573_().m_26573_();
            DryadorEntity.this.m_9236_().m_7605_((Entity)DryadorEntity.this, (byte)60);
        }

        public boolean m_8036_() {
            int i = DryadorEntity.this.m_9236_().m_45971_(PixieEntity.class, this.pixiesCount, (LivingEntity)DryadorEntity.this, DryadorEntity.this.m_20191_().m_82400_(16.0)).size();
            return super.m_8036_() && i < 8 && DryadorEntity.this.flag && DryadorEntity.this.currentPhase.shouldTransition();
        }

        private void summonPixies(ServerLevel serverLevel, BlockPos spawnPos, float angle, double speed) {
            PixieEntity pixie = (PixieEntity)((EntityType)EntityTypeRegistry.PIXIE.get()).m_20615_(DryadorEntity.this.m_9236_());
            if (pixie != null) {
                pixie.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_() + 1, (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
                pixie.setOwner((LivingEntity)DryadorEntity.this);
                pixie.setLimitedLife(360);
                double vx = Math.cos(angle) * speed;
                double vz = Math.sin(angle) * speed;
                pixie.m_20334_(vx, 0.4, vz);
                serverLevel.m_7967_((Entity)pixie);
            }
        }

        protected void performAttack() {
            if (DryadorEntity.this.m_9236_().m_5776_()) {
                return;
            }
            ServerLevel serv = (ServerLevel)DryadorEntity.this.m_9236_();
            BlockPos center = DryadorEntity.this.m_20183_();
            for (int i = 0; i < 4; ++i) {
                float angle = (float)(1.5707963267948966 * (double)i);
                this.summonPixies(serv, center, angle, 0.25);
            }
        }

        public int getPreparingTime() {
            return 40;
        }

        public int getAttackInterval() {
            return 650;
        }

        @Nullable
        public SoundEvent getPrepareSound() {
            return null;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.SUMMON;
        }
    }

    public class JumpToTargetGoal
    extends MultiAttackMob.AttackGoal {
        public JumpToTargetGoal() {
            super((MultiAttackMob)DryadorEntity.this);
        }

        public void onPrepare() {
            DryadorEntity.this.m_21573_().m_26573_();
            DryadorEntity.this.m_9236_().m_7605_((Entity)DryadorEntity.this, (byte)61);
        }

        public boolean m_8036_() {
            LivingEntity livingentity = DryadorEntity.this.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.m_6084_() && super.m_8036_()) {
                return DryadorEntity.this.cantReachTarget(livingentity) || DryadorEntity.this.m_20270_((Entity)livingentity) > 25.0f;
            }
            return false;
        }

        public void jumpToward(LivingEntity target) {
            Vec3 mobPos = DryadorEntity.this.m_20182_();
            Vec3 targetPos = target.m_20182_();
            double dx = targetPos.f_82479_ - mobPos.f_82479_;
            double dz = targetPos.f_82481_ - mobPos.f_82481_;
            double distance = Math.sqrt(dx * dx + dz * dz);
            if (distance < 0.001) {
                return;
            }
            double strength = 2.0;
            double upward = 0.6;
            double normX = dx / distance;
            double normZ = dz / distance;
            Vec3 motion = new Vec3(normX * strength, upward, normZ * strength);
            DryadorEntity.this.m_20256_(motion);
            DryadorEntity.this.f_19812_ = true;
            DryadorEntity.this.m_6862_(true);
        }

        protected void performAttack() {
            if (DryadorEntity.this.m_9236_().m_5776_()) {
                return;
            }
            this.jumpToward(DryadorEntity.this.m_5448_());
        }

        public int getPreparingTime() {
            return 60;
        }

        public int getAttackInterval() {
            return 350;
        }

        @Nullable
        public SoundEvent getPrepareSound() {
            return null;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.JUMP;
        }
    }
}

