/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.elemental;

import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.entity.ai.attacks.GolemGroundPunchAttack;
import com.idark.valoria.registries.entity.ai.attacks.GolemMeleeAttack;
import com.idark.valoria.registries.entity.ai.attacks.GolemMeleeSlapAttack;
import com.idark.valoria.registries.entity.ai.attacks.GolemStompAttack;
import com.idark.valoria.registries.entity.living.elemental.AbstractElementalGolem;
import java.util.function.IntFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.common.registry.entity.system.AttackInstance;

public class NatureGolem
extends AbstractElementalGolem {
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(NatureGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public NatureGolem(EntityType<? extends AbstractElementalGolem> type, Level pLevel) {
        super(type, pLevel);
        this.f_21364_ = 5;
        this.m_21573_().m_7008_(false);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 8.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 8.0f);
        this.selector.addAttack((AttackInstance)new GolemMeleeAttack(this, 1.0f, 2.0f, 0, 10, 20));
        this.selector.addAttack((AttackInstance)new GolemMeleeSlapAttack(this, 1.0f, 2.0f, 0, 10, 40));
        this.selector.addAttack((AttackInstance)new GolemStompAttack(this, 4.0f, 2.0f, 0, 20, 60));
        this.selector.addAttack((AttackInstance)new GolemGroundPunchAttack(this, 1.0f, 4.0f, 0, 15, 120));
    }

    public NatureGolem(Level pLevel) {
        this((EntityType<? extends AbstractElementalGolem>)((EntityType)EntityTypeRegistry.NATURE_GOLEM.get()), pLevel);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pDataTag == null || !pDataTag.m_128441_("Variant")) {
            this.setVariant(Variant.byId(this.f_19796_.m_188503_(Variant.values().length)));
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(TYPE, (Object)variant.getId());
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(TYPE));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Variant", this.getVariant().getId());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setVariant(Variant.byId(pCompound.m_128451_("Variant")));
    }

    public static enum Variant implements StringRepresentable
    {
        DEFAULT(0, "default", new ResourceLocation("valoria", "textures/entity/nature_golem.png")),
        MOSSY_0(1, "mossy_0", new ResourceLocation("valoria", "textures/entity/nature_golem_moss_0.png")),
        MOSSY_1(2, "mossy_1", new ResourceLocation("valoria", "textures/entity/nature_golem_moss_1.png"));

        private static final IntFunction<Variant> BY_ID;
        public final ResourceLocation texture;
        public final String name;
        public final int id;

        private Variant(int id, String name, ResourceLocation texture) {
            this.id = id;
            this.name = name;
            this.texture = texture;
        }

        public ResourceLocation texture() {
            return this.texture;
        }

        public String m_7912_() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int pId) {
            return BY_ID.apply(pId);
        }

        static {
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

