/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.minions;

import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.particle.SmokeParticlePacket;
import com.idark.valoria.registries.EntityStatsRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.entity.ai.movements.FlyingAroundMovement;
import com.idark.valoria.registries.entity.projectile.SpellProjectile;
import com.idark.valoria.util.Pal;
import java.util.EnumSet;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.api.entity.AttackRegistry;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.common.registry.entity.AbstractMultiAttackMinion;
import pro.komaru.tridot.common.registry.entity.MultiAttackMob;
import pro.komaru.tridot.common.registry.entity.goal.CopyOwnerTargetGoal;
import pro.komaru.tridot.common.registry.entity.goal.FollowOwnerGoal;
import pro.komaru.tridot.util.Col;

public class CrystalEntity
extends AbstractMultiAttackMinion
implements RangedAttackMob {
    public Variant variant;
    public FlyingAroundMovement movement = new FlyingAroundMovement((Mob)this, null);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(CrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public CrystalEntity(EntityType<? extends MultiAttackMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        if (!pLevel.f_46443_) {
            this.setType(Variant.byId(this.f_19796_.m_188503_(Variant.values().length)));
            this.m_20242_(true);
        }
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.5f;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundsRegistry.WICKED_CRYSTAL_HURT.get();
    }

    public void m_8119_() {
        super.m_8119_();
        this.movement.setupMovement();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)0);
    }

    public void setType(Variant variant) {
        this.variant = variant;
        this.f_19804_.m_135381_(TYPE, (Object)variant.getId());
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(TYPE));
    }

    public void spawnDisappearParticles(ServerLevel serverLevel) {
        double posX = this.m_20097_().m_252807_().f_82479_;
        double posY = this.m_20097_().m_7494_().m_252807_().f_82480_;
        double posZ = this.m_20097_().m_252807_().f_82481_;
        PacketHandler.sendToTracking((Level)serverLevel, this.m_20097_(), new SmokeParticlePacket(3, posX, posY - 0.5, posZ, 0.005f, 0.025f, 0.005f, 255, 255, 255));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Variant", this.variant.getId());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.variant = Variant.byId(pCompound.m_128451_("Variant"));
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(0, (Goal)new FollowOwnerGoal((Mob)this, 1.0, 12.0f, 4.0f, true));
        this.f_21346_.m_25352_(0, (Goal)new CopyOwnerTargetGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 12.0f));
        this.f_21345_.m_25352_(1, (Goal)new CastSpellGoal(this, 12.0f));
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public void m_7822_(byte pId) {
        block9: {
            block8: {
                if (pId != 62) break block8;
                switch (this.getVariant()) {
                    case ICE: {
                        for (int a = 0; a < 6; ++a) {
                            ParticleBuilder.create((RegistryObject)TridotParticles.SMOKE).setColorData(ColorParticleData.create((Col)Pal.cyan, (Col)Col.white).build()).setTransparencyData(GenericParticleData.create((float)0.425f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)((float)a * 0.125f), (float)0.1f, (float)0.0f).build()).setLifetime(15).spawn(this.m_9236_(), this.m_20183_().m_252807_().f_82479_, this.m_20182_().f_82480_ + 0.5, this.m_20183_().m_252807_().f_82481_);
                        }
                        break block9;
                    }
                    case FIRE: {
                        for (int a = 0; a < 6; ++a) {
                            ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(ColorParticleData.create((Col)Pal.mandarin, (Col)Col.white).build()).setTransparencyData(GenericParticleData.create((float)0.425f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)((float)a * 0.125f), (float)0.1f, (float)0.0f).build()).setLifetime(15).spawn(this.m_9236_(), this.m_20183_().m_252807_().f_82479_, this.m_20182_().f_82480_ + 0.5, this.m_20183_().m_252807_().f_82481_);
                        }
                        break block9;
                    }
                    case POISON: {
                        for (int a = 0; a < 6; ++a) {
                            ParticleBuilder.create((RegistryObject)TridotParticles.SMOKE).setColorData(ColorParticleData.create((Col)Pal.nature, (Col)Col.white).build()).setTransparencyData(GenericParticleData.create((float)0.425f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)((float)a * 0.125f), (float)0.1f, (float)0.0f).build()).setLifetime(15).spawn(this.m_9236_(), this.m_20183_().m_252807_().f_82479_, this.m_20182_().f_82480_ + 0.5, this.m_20183_().m_252807_().f_82481_);
                        }
                        break;
                    }
                }
                break block9;
            }
            super.m_7822_(pId);
        }
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
        SpellProjectile spell = new SpellProjectile(this.m_9236_(), (LivingEntity)this, 6);
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - spell.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        switch (this.getVariant()) {
            case POISON: {
                spell.addEffect(new MobEffectInstance(MobEffects.f_19614_, 120));
                break;
            }
            case ICE: {
                spell.addEffect(new MobEffectInstance(MobEffects.f_19597_, 120));
                break;
            }
            case FIRE: {
                spell.igniteOnHit(5);
            }
        }
        spell.setColor(this.getVariant().getColor());
        spell.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.25f, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
        this.m_9236_().m_7967_((Entity)spell);
    }

    public static enum Variant {
        ICE(0, "Ice", Pal.diamond),
        FIRE(1, "Fire", Pal.magmatic),
        POISON(2, "Poison", Pal.nature);

        private static final IntFunction<Variant> BY_ID;
        public String type;
        public final int id;
        public final Col color;

        private Variant(int id, String type, Col color) {
            this.id = id;
            this.type = type;
            this.color = color;
        }

        public Col getColor() {
            return this.color;
        }

        public String getString() {
            return this.type;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int pId) {
            return BY_ID.apply(pId);
        }

        static {
            BY_ID = ByIdMap.m_262839_(p_263091_ -> p_263091_.id, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    public class CastSpellGoal
    extends MultiAttackMob.AttackGoal {
        private final Mob mob;
        private final RangedAttackMob rangedAttackMob;
        private final float attackRadius;

        public CastSpellGoal(RangedAttackMob pRangedAttackMob, float pAttackRadius) {
            super((MultiAttackMob)CrystalEntity.this);
            this.rangedAttackMob = pRangedAttackMob;
            this.mob = (Mob)pRangedAttackMob;
            this.attackRadius = pAttackRadius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            return super.m_8036_() && livingentity != null;
        }

        protected void performAttack() {
            double d0 = this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_());
            float f = (float)Math.sqrt(d0) / this.attackRadius;
            float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
            this.rangedAttackMob.m_6504_(this.mob.m_5448_(), f1);
        }

        public void onPrepare() {
            CrystalEntity.this.m_9236_().m_7605_((Entity)CrystalEntity.this, (byte)62);
        }

        public int getPreparingTime() {
            return 30;
        }

        public int getAttackInterval() {
            return 80;
        }

        @Nullable
        public SoundEvent getPrepareSound() {
            return switch (CrystalEntity.this.getVariant()) {
                default -> throw new IncompatibleClassChangeError();
                case Variant.ICE -> (SoundEvent)SoundsRegistry.CRYSTAL_FROST_PREPARE.get();
                case Variant.FIRE -> (SoundEvent)SoundsRegistry.CRYSTAL_FIRE_PREPARE.get();
                case Variant.POISON -> (SoundEvent)SoundsRegistry.CRYSTAL_ACID_PREPARE.get();
            };
        }

        public SoundEvent getAttackSound() {
            return switch (CrystalEntity.this.getVariant()) {
                default -> throw new IncompatibleClassChangeError();
                case Variant.ICE -> (SoundEvent)SoundsRegistry.CRYSTAL_FROST.get();
                case Variant.FIRE -> (SoundEvent)SoundsRegistry.CRYSTAL_FIRE.get();
                case Variant.POISON -> (SoundEvent)SoundsRegistry.CRYSTAL_ACID.get();
            };
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.MAGIC;
        }
    }
}

