/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.minions;

import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.particle.SmokeParticlePacket;
import com.idark.valoria.registries.entity.living.boss.NecromancerEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import pro.komaru.tridot.common.registry.entity.AbstractMinionEntity;
import pro.komaru.tridot.common.registry.entity.goal.CopyOwnerTargetGoal;
import pro.komaru.tridot.common.registry.entity.goal.FollowOwnerGoal;

public class UndeadEntity
extends AbstractMinionEntity {
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)3.9269907f);
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(UndeadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public UndeadEntity(EntityType<? extends UndeadEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new UndeadMoveControl(this);
        this.f_21364_ = 3;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pDimensions) {
        return pDimensions.f_20378_ - 0.28125f;
    }

    public boolean m_142039_() {
        return this.f_19797_ % TICKS_PER_FLAP == 0;
    }

    public void spawnDisappearParticles(ServerLevel serverLevel) {
        double posX = this.m_20097_().m_252807_().f_82479_;
        double posY = this.m_20097_().m_7494_().m_252807_().f_82480_;
        double posZ = this.m_20097_().m_252807_().f_82481_;
        PacketHandler.sendToTracking((Level)serverLevel, this.m_20097_(), new SmokeParticlePacket(3, posX, posY - 0.5, posZ, 0.005f, 0.025f, 0.005f, 255, 255, 255));
    }

    public void spawnParticlesTrail() {
        if (this.isCharging()) {
            Vec3 vector3d = this.m_20184_();
            double a3 = vector3d.f_82479_;
            double a4 = vector3d.f_82480_;
            double a0 = vector3d.f_82481_;
            int a = 0;
            while ((float)a < 0.05f) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175831_, this.m_20185_() + a3 * (double)a / 4.0, this.m_20186_() + a4 * (double)a / 4.0, this.m_20189_() + a0 * (double)a / 4.0, -a3, -a4 + 0.2, -a0);
                ++a;
            }
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(0, (Goal)new FollowOwnerGoal((Mob)this, 1.0, 24.0f, 8.0f, true));
        this.f_21346_.m_25352_(0, (Goal)new CopyOwnerTargetGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(0, (Goal)new UndeadEntityRandomMoveGoal());
        this.f_21345_.m_25352_(1, (Goal)new UndeadChargeAttackGoal());
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{NecromancerEntity.class}).m_26044_(new Class[0]));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    private boolean getUndeadFlag(int pMask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & pMask) != 0;
    }

    public boolean m_6097_() {
        return false;
    }

    private void setUndeadFlag(int pMask, boolean pValue) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = pValue ? (i |= pMask) : (i &= ~pMask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getUndeadFlag(1);
    }

    public void setIsCharging(boolean pCharging) {
        this.setUndeadFlag(1, pCharging);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12381_;
    }

    public float m_213856_() {
        return 1.0f;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        RandomSource randomsource = pLevel.m_213780_();
        this.m_213945_(randomsource, pDifficulty);
        this.m_213946_(randomsource, pDifficulty);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                BlockPos ground = this.m_20099_();
                float f = 0.91f;
                if (this.m_20096_()) {
                    f = this.m_9236_().m_8055_(ground).getFriction((LevelReader)this.m_9236_(), ground, (Entity)this) * 0.91f;
                }
                float f1 = 0.16277137f / (f * f * f);
                f = 0.91f;
                if (this.m_20096_()) {
                    f = this.m_9236_().m_8055_(ground).getFriction((LevelReader)this.m_9236_(), ground, (Entity)this) * 0.91f;
                }
                this.m_19920_(this.m_20096_() ? 0.1f * f1 : 0.02f, pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)f));
            }
        }
        this.m_267651_(false);
    }

    public boolean m_6147_() {
        return false;
    }

    public double m_6049_() {
        return 0.4;
    }

    class UndeadMoveControl
    extends MoveControl {
        public UndeadMoveControl(UndeadEntity pUndeadEntity) {
            super((Mob)pUndeadEntity);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.f_24975_ - UndeadEntity.this.m_20185_(), this.f_24976_ - UndeadEntity.this.m_20186_(), this.f_24977_ - UndeadEntity.this.m_20189_());
                double d0 = vec3.m_82553_();
                if (d0 < UndeadEntity.this.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    UndeadEntity.this.m_20256_(UndeadEntity.this.m_20184_().m_82490_(0.5));
                } else {
                    UndeadEntity.this.m_20256_(UndeadEntity.this.m_20184_().m_82549_(vec3.m_82490_(this.f_24978_ * 0.05 / d0)));
                    if (UndeadEntity.this.m_5448_() == null) {
                        Vec3 vec31 = UndeadEntity.this.m_20184_();
                        UndeadEntity.this.m_146922_(-((float)Mth.m_14136_((double)vec31.f_82479_, (double)vec31.f_82481_)) * 57.295776f);
                    } else {
                        double d2 = UndeadEntity.this.m_5448_().m_20185_() - UndeadEntity.this.m_20185_();
                        double d1 = UndeadEntity.this.m_5448_().m_20189_() - UndeadEntity.this.m_20189_();
                        UndeadEntity.this.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                    }
                    UndeadEntity.this.f_20883_ = UndeadEntity.this.m_146908_();
                }
            }
        }
    }

    class UndeadEntityRandomMoveGoal
    extends Goal {
        public UndeadEntityRandomMoveGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return UndeadEntity.this.m_5448_() == null && !UndeadEntity.this.m_21566_().m_24995_() && UndeadEntity.this.f_19796_.m_188503_(UndeadEntityRandomMoveGoal.m_186073_((int)7)) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = UndeadEntity.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = UndeadEntity.this.m_20183_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(UndeadEntity.this.f_19796_.m_188503_(15) - 7, UndeadEntity.this.f_19796_.m_188503_(11) - 5, UndeadEntity.this.f_19796_.m_188503_(15) - 7);
                if (!UndeadEntity.this.m_9236_().m_46859_(blockpos1)) continue;
                UndeadEntity.this.f_21342_.m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 0.25);
                break;
            }
        }
    }

    class UndeadChargeAttackGoal
    extends MeleeAttackGoal {
        public UndeadChargeAttackGoal() {
            super((PathfinderMob)UndeadEntity.this, 1.0, true);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        protected int m_25566_() {
            return this.m_183277_(60);
        }

        public boolean m_8045_() {
            return UndeadEntity.this.m_21566_().m_24995_() && UndeadEntity.this.m_5448_() != null && UndeadEntity.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            super.m_8056_();
            LivingEntity livingentity = UndeadEntity.this.m_5448_();
            if (livingentity != null) {
                Vec3 vec3 = livingentity.m_146892_();
                UndeadEntity.this.f_21342_.m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
            }
            UndeadEntity.this.setIsCharging(true);
            UndeadEntity.this.m_5496_(SoundEvents.f_144211_, 1.0f, 1.0f);
        }

        public void m_8041_() {
            super.m_8041_();
            UndeadEntity.this.setIsCharging(false);
        }

        public void m_8037_() {
            super.m_8037_();
            LivingEntity livingentity = UndeadEntity.this.m_5448_();
            if (livingentity != null) {
                if (UndeadEntity.this.m_20191_().m_82381_(livingentity.m_20191_())) {
                    UndeadEntity.this.m_7327_((Entity)livingentity);
                    UndeadEntity.this.setIsCharging(false);
                    UndeadEntity.this.m_20334_((UndeadEntity.this.m_20185_() - UndeadEntity.this.m_5448_().m_20185_()) * 3.0, (UndeadEntity.this.m_20186_() - UndeadEntity.this.m_5448_().m_20186_()) * 0.5, (UndeadEntity.this.m_5448_().m_20189_() - UndeadEntity.this.m_20189_()) * 3.0);
                } else {
                    double d0 = UndeadEntity.this.m_20280_((Entity)livingentity);
                    if (d0 < UndeadEntity.this.m_21133_(Attributes.f_22277_)) {
                        Vec3 vec3 = livingentity.m_146892_();
                        UndeadEntity.this.f_21342_.m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
                    }
                }
            }
        }
    }
}

