/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.projectile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.idark.valoria.registries.EntityTypeRegistry;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AcornProjectile
extends ThrowableProjectile {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(AcornProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final Set<MobEffectInstance> effects = Sets.newHashSet();
    private int oldSwell;
    private int swell;
    private int maxSwell = 35;
    public float rotationVelocity = 0.0f;
    public boolean inGround;

    public AcornProjectile(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public AcornProjectile(LivingEntity pShooter, Level pLevel) {
        super((EntityType)EntityTypeRegistry.ACORN.get(), pShooter, pLevel);
        this.m_6034_(pShooter.m_20185_(), pShooter.m_20188_() - (double)0.1f, pShooter.m_20189_());
        this.m_5602_((Entity)pShooter);
    }

    public void addEffect(MobEffectInstance pEffectInstance) {
        this.effects.add(pEffectInstance);
    }

    public void setEffectsFromList(ImmutableList<MobEffectInstance> effects) {
        this.effects.addAll((Collection<MobEffectInstance>)effects);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (!this.effects.isEmpty()) {
            ListTag listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            pCompound.m_128365_("CustomPotionEffects", (Tag)listtag);
        }
        pCompound.m_128376_("Fuse", (short)this.maxSwell);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)1);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        for (MobEffectInstance mobeffectinstance : PotionUtils.m_43573_((CompoundTag)pCompound)) {
            this.addEffect(mobeffectinstance);
        }
        if (pCompound.m_128425_("Fuse", 99)) {
            this.maxSwell = pCompound.m_128448_("Fuse");
        }
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        if (this.m_6084_()) {
            this.oldSwell = this.swell;
            int i = this.getSwellDir();
            if (i > 0 && this.swell == 1) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explode();
            }
        }
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        BlockPos blockpos = this.m_20183_();
        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
        if (!blockstate.m_60795_() && !(voxelshape = blockstate.m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
            Vec3 vec31 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                this.inGround = true;
                break;
            }
        }
        super.m_8119_();
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        this.explode();
    }

    protected void m_8060_(BlockHitResult pResult) {
        BlockPos pos;
        Level level = this.m_9236_();
        BlockState blockState = level.m_8055_(pos = pResult.m_82425_());
        if (blockState.m_280296_()) {
            Direction d = pResult.m_82434_();
            Vec3 mot = this.m_20184_();
            double x = mot.m_7096_();
            double y = mot.m_7098_();
            double z = mot.m_7094_();
            if (d.m_122429_() != 0) {
                x *= -1.0;
            } else if (d.m_122430_() != 0) {
                y *= -1.0;
            } else if (d.m_122431_() != 0) {
                z *= -1.0;
            }
            Vec3 newMot = new Vec3(x, y, z).m_82490_((double)0.325f);
            this.m_146884_(pResult.m_82450_());
            this.m_20256_(newMot);
        }
        this.inGround = true;
        super.m_8060_(pResult);
    }

    public float getSwelling(float pPartialTicks) {
        return Mth.m_14179_((float)pPartialTicks, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int pState) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)pState);
    }

    private void explode() {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.75f, Level.ExplosionInteraction.NONE);
            this.spawnLingeringCloud();
            this.m_146870_();
        }
    }

    private void spawnLingeringCloud() {
        Set<MobEffectInstance> collection = this.effects;
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloud.m_19712_(2.5f);
            areaeffectcloud.m_19732_(-0.5f);
            areaeffectcloud.m_19740_(10);
            areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() / 2);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            for (MobEffectInstance mobeffectinstance : collection) {
                areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
            }
            this.m_9236_().m_7967_((Entity)areaeffectcloud);
        }
    }
}

