/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.projectile;

import com.idark.valoria.registries.EntityTypeRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class CrystalSpikes
extends Entity
implements TraceableEntity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 35;
    private float damage;
    public final AnimationState disapearAnimationState = new AnimationState();
    public final AnimationState appearAnimationState = new AnimationState();
    private boolean clientSideAttackStarted;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public CrystalSpikes(EntityType<CrystalSpikes> entityEntityType, Level level) {
        super(entityEntityType, level);
    }

    public CrystalSpikes(Level pLevel, double pX, double pY, double pZ, float pYRot, int pWarmupDelay, LivingEntity pOwner) {
        this((EntityType<CrystalSpikes>)((EntityType)EntityTypeRegistry.CRYSTAL_SPIKES.get()), pLevel);
        this.warmupDelayTicks = pWarmupDelay;
        this.damage = 10.0f;
        this.setOwner(pOwner);
        this.m_6034_(pX, pY, pZ);
        this.m_146922_(pYRot);
    }

    public CrystalSpikes(Level pLevel, double pX, double pY, double pZ, float pYRot, int pWarmupDelay, float pDamage, LivingEntity pOwner) {
        this((EntityType<CrystalSpikes>)((EntityType)EntityTypeRegistry.CRYSTAL_SPIKES.get()), pLevel);
        this.warmupDelayTicks = pWarmupDelay;
        this.damage = pDamage;
        this.setOwner(pOwner);
        this.m_6034_(pX, pY, pZ);
        this.m_146922_(pYRot);
    }

    public CrystalSpikes setDamage(float damage) {
        this.damage = damage;
        return this;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 14) {
                    for (int i = 0; i < 12; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_() - 1.0 + this.f_19796_.m_188500_() * 2.0, this.m_20186_() + 1.25 + this.f_19796_.m_188500_(), this.m_20189_() - 1.0 + this.f_19796_.m_188500_() * 2.0, 0.0, 0.0, 0.0);
                    }
                }
                if (this.lifeTicks == 10) {
                    this.disapearAnimationState.m_216977_(this.f_19797_);
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.m_146870_();
            }
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        this.owner = pOwner;
        this.ownerUUID = pOwner == null ? null : pOwner.m_20148_();
    }

    public void m_7378_(CompoundTag pCompound) {
        this.warmupDelayTicks = pCompound.m_128451_("Warmup");
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
    }

    protected void m_8097_() {
    }

    public void m_6123_(Player pPlayer) {
        super.m_6123_(pPlayer);
        if (pPlayer.m_5647_() != null ? this.m_7307_((Entity)pPlayer) : pPlayer.m_6095_().m_20674_().equals((Object)MobCategory.MONSTER)) {
            return;
        }
        pPlayer.m_6469_(this.m_269291_().m_269299_((Entity)this, this.owner), this.damage);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7822_(byte pId) {
        super.m_7822_(pId);
        if (pId == 4) {
            this.clientSideAttackStarted = true;
            if (!this.m_20067_()) {
                this.appearAnimationState.m_216977_(this.f_19797_);
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144243_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
            }
        }
    }

    public float getAnimationProgress(float pPartialTicks) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - pPartialTicks) / 20.0f;
    }
}

