/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.projectile;

import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.util.Pal;
import java.util.function.Consumer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.GenericParticle;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.common.registry.entity.projectiles.AbstractSupplierProjectile;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.math.Interp;

public class SpectralBladeEntity
extends AbstractSupplierProjectile {
    public SpectralBladeEntity(EntityType<? extends SpectralBladeEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public SpectralBladeEntity(Level worldIn, LivingEntity thrower, ItemStack thrownStackIn) {
        super((EntityType)EntityTypeRegistry.SPECTRAL_BLADE.get(), worldIn, thrower, thrownStackIn);
        this.setItem(thrownStackIn);
        this.m_5602_((Entity)thrower);
    }

    public void m_8119_() {
        this.m_6901_();
        Vec3 vector3d = this.m_20184_();
        double a3 = vector3d.f_82479_;
        double a4 = vector3d.f_82480_;
        double a0 = vector3d.f_82481_;
        this.m_20334_(a3, 0.0, a0);
        if (this.m_20069_()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_6089_();
            } else {
                this.m_9236_().m_245803_((Entity)this, this.m_20097_(), (SoundEvent)SoundsRegistry.DISAPPEAR.get(), SoundSource.AMBIENT, 0.4f, 1.0f);
                for (int a = 0; a < 6; ++a) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_() + 1.5, this.m_20262_(1.0), d0, d1, d2);
                }
            }
        }
        if (this.m_9236_().m_5776_()) {
            this.spawnParticleTrail(this.m_9236_(), (Projectile)this, new Vec3(this.m_20185_() + a3 / 4.0, this.m_20186_() + a4 / 4.0, this.m_20189_() + a0 / 2.0));
        }
        super.m_8119_();
    }

    protected Item getDefaultItem() {
        return (Item)ItemsRegistry.spectralBladeThrown.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticleTrail(Level level, Projectile projectile, Vec3 spawnPos) {
        if (level.m_5776_()) {
            Consumer<GenericParticle> blockTarget = p -> {
                Vec3 pPos = p.getPosition();
                double dX = projectile.m_20185_() - pPos.m_7096_();
                double dY = projectile.m_20186_() - pPos.m_7098_();
                double dZ = projectile.m_20189_() - pPos.m_7094_();
                double yaw = Math.atan2(dZ, dX);
                double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
                float speed = 0.01f;
                float x = (float)(Math.sin(pitch) * Math.cos(yaw) * (double)speed);
                float y = (float)(Math.cos(pitch) * (double)speed);
                float z = (float)(Math.sin(pitch) * Math.sin(yaw) * (double)speed);
                p.setSpeed(p.getSpeed().m_82492_((double)x, (double)y, (double)z));
            };
            ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.SPARKLE).setColorData(ColorParticleData.create((Col)Pal.cyan, (Col)Col.white).build()).setTransparencyData(GenericParticleData.create((float)0.3f).setEasing(Interp.sineIn).build()).setScaleData(GenericParticleData.create((float)0.06f, (float)0.15f, (float)0.0f).setEasing(Interp.sineOut).build()).addTickActor(blockTarget).setLifetime(16).randomVelocity(0.25)).disablePhysics().repeat(level, spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_(), 4);
        }
    }

    public void m_6901_() {
        ++this.f_36697_;
        if (this.f_36697_ >= 60) {
            this.m_146870_();
        }
    }

    public void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        this.m_146870_();
    }

    public ItemStack m_7941_() {
        return null;
    }

    public SoundEvent m_7239_() {
        return (SoundEvent)SoundsRegistry.DISAPPEAR.get();
    }

    public SoundEvent m_36784_() {
        return (SoundEvent)SoundsRegistry.DISAPPEAR.get();
    }

    public float m_6882_() {
        return 0.0f;
    }
}

