/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.projectile;

import com.idark.valoria.client.particle.ParticleEffects;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.util.Pal;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import pro.komaru.tridot.client.gfx.particle.GenericParticle;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.postprocess.GlowPostProcess;
import pro.komaru.tridot.client.gfx.postprocess.GlowPostProcessInstance;
import pro.komaru.tridot.client.render.screenshake.PositionedScreenshakeInstance;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeHandler;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeInstance;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.comps.phys.Pos3;

public class ThrowableBomb
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.m_135353_(ThrowableBomb.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_RADIUS_ID = SynchedEntityData.m_135353_(ThrowableBomb.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(ThrowableBomb.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static Level.ExplosionInteraction bombInteraction = Level.ExplosionInteraction.TNT;

    public ThrowableBomb(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setFuse(80);
        this.setRadius(1.25f);
    }

    public ThrowableBomb(EntityType<? extends ThrowableItemProjectile> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        super(pEntityType, pX, pY, pZ, pLevel);
        this.setFuse(80);
        this.setRadius(1.25f);
    }

    public ThrowableBomb(EntityType<? extends ThrowableItemProjectile> pEntityType, LivingEntity pShooter, Level pLevel) {
        super(pEntityType, pShooter, pLevel);
        this.setFuse(80);
        this.setRadius(1.25f);
    }

    public ThrowableBomb(Level pLevel, LivingEntity pShooter) {
        super((EntityType)EntityTypeRegistry.THROWABLE_BOMB.get(), pShooter, pLevel);
        this.setFuse(80);
        this.setRadius(1.25f);
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ItemsRegistry.throwableBomb.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticlesTrail() {
        if (this.m_6000_(this.m_20185_(), this.m_20186_(), this.m_20189_())) {
            Vec3 delta = this.m_20184_().m_82541_();
            Vec3 pos = new Vec3(this.m_20185_() + delta.m_7096_() * 1.5E-4, this.m_20186_() + delta.m_7098_() * 1.5E-4, this.m_20189_() + delta.m_7094_() * 1.5E-4);
            Vec3[] cachePos = new Vec3[]{new Vec3(pos.f_82479_, pos.f_82480_, pos.f_82481_)};
            Consumer<GenericParticle> target = p -> {
                Vec3 arrowPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
                float lenBetweenArrowAndParticle = (float)arrowPos.m_82546_(cachePos[0]).m_82553_();
                Vec3 vector = arrowPos.m_82546_(cachePos[0]);
                if (lenBetweenArrowAndParticle > 0.0f) {
                    cachePos[0] = cachePos[0].m_82549_(vector);
                    p.setPosition(cachePos[0]);
                }
            };
            Style base = Style.f_131099_;
            Style styled = (Style)this.m_7846_().m_41791_().getStyleModifier().apply(base);
            Col color = styled.m_131135_() != null ? Col.fromARGB((int)styled.m_131135_().m_131265_()) : Pal.darkerGray.brighter();
            ParticleEffects.smoothTrail(this.m_9236_(), target, pos, ColorParticleData.create((Col)color).build());
        }
    }

    public void m_8119_() {
        this.m_20101_();
        super.m_8119_();
        if (this.m_9236_().m_5776_() && !this.m_20072_() && !this.m_5830_()) {
            this.spawnParticlesTrail();
        }
        int fuse = this.getFuse() - 1;
        this.setFuse(fuse);
        if (fuse <= 0) {
            if (!this.m_9236_().m_5776_()) {
                this.explode();
            }
            this.m_146870_();
        } else {
            this.m_20073_();
            if (this.m_9236_().m_5776_()) {
                float yaw = this.m_146908_();
                float pitch = this.m_146909_();
                double offsetX = -Math.sin(Math.toRadians(yaw)) * 0.25;
                double offsetZ = Math.cos(Math.toRadians(yaw)) * 0.25;
                double offsetY = -Math.sin(Math.toRadians(pitch)) * 0.3;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + offsetX, this.m_20186_() + 0.3 + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        this.explode();
        this.m_146870_();
    }

    protected void m_8060_(BlockHitResult pResult) {
        BlockPos pos;
        Level level = this.m_9236_();
        BlockState blockState = level.m_8055_(pos = pResult.m_82425_());
        if (blockState.m_280296_()) {
            Direction d = pResult.m_82434_();
            Vec3 mot = this.m_20184_();
            double x = mot.m_7096_();
            double y = mot.m_7098_();
            double z = mot.m_7094_();
            if (d.m_122429_() != 0) {
                x *= -1.0;
            } else if (d.m_122430_() != 0) {
                y *= -1.0;
            } else if (d.m_122431_() != 0) {
                z *= -1.0;
            }
            Vec3 newMot = new Vec3(x, y, z).m_82490_((double)0.325f);
            this.m_146884_(pResult.m_82450_());
            this.m_20256_(newMot);
        }
        super.m_8060_(pResult);
    }

    public void m_37446_(ItemStack pStack) {
        if (!pStack.m_150930_(this.m_7881_()) || pStack.m_41782_()) {
            this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)pStack.m_255036_(1));
        }
    }

    protected ItemStack m_37454_() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    public void m_7380_(CompoundTag pCompound) {
        ItemStack itemstack = this.m_37454_();
        if (!itemstack.m_41619_()) {
            pCompound.m_128365_("Item", (Tag)itemstack.m_41739_(new CompoundTag()));
        }
        pCompound.m_128405_("Fuse", this.getFuse());
        pCompound.m_128350_("Radius", this.getRadius());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Item"));
        this.m_37446_(itemstack);
        this.setFuse(pCompound.m_128451_("Fuse"));
        this.setRadius(pCompound.m_128457_("Radius"));
    }

    protected void explode() {
        if (this.m_9236_().m_5776_()) {
            GlowPostProcess.INSTANCE.addInstance(new GlowPostProcessInstance(this.m_20182_().m_252839_(), new Vector3f(1.0f, 1.0f, 1.0f)).setIntensity(5.0f).setRadius(this.getRadius()).setFadeTime(10.0f));
        }
        this.m_9236_().m_254849_(this.m_19749_(), this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), this.getRadius(), bombInteraction);
        ScreenshakeHandler.add((ScreenshakeInstance)new PositionedScreenshakeInstance(3, (Pos3)pro.komaru.tridot.util.phys.Vec3.from((Vec3)this.m_20182_()), 0.0f, 30.0f).intensity(0.5f));
    }

    public void setInteraction(Level.ExplosionInteraction intr) {
        bombInteraction = intr;
    }

    public void setFuse(int pLife) {
        this.f_19804_.m_135381_(DATA_FUSE_ID, (Object)pLife);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE_ID);
    }

    public void setRadius(float pRadius) {
        this.f_19804_.m_135381_(DATA_RADIUS_ID, (Object)Float.valueOf(pRadius));
    }

    public float getRadius() {
        return ((Float)this.f_19804_.m_135370_(DATA_RADIUS_ID)).floatValue();
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(DATA_FUSE_ID, (Object)80);
        this.m_20088_().m_135372_(DATA_RADIUS_ID, (Object)Float.valueOf(1.25f));
    }
}

