/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.armor;

import com.idark.valoria.registries.AttributeReg;
import com.idark.valoria.registries.EffectsRegistry;
import com.idark.valoria.registries.ItemsRegistry;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.common.registry.item.armor.AbstractArmorRegistry;
import pro.komaru.tridot.common.registry.item.builders.AbstractArmorBuilder;

public class ArmorRegistry
extends AbstractArmorRegistry {
    public Builder builder;
    public static List<AbstractArmorBuilder.ArmorEffectData> natureData = List.of(AbstractArmorBuilder.ArmorEffectData.createData(EffectsRegistry.ALOEREGEN));
    public static List<AbstractArmorBuilder.ArmorEffectData> depthData = List.of(AbstractArmorBuilder.ArmorEffectData.createData(() -> new MobEffectInstance(MobEffects.f_19608_, -1), Entity::m_20069_));
    public static List<AbstractArmorBuilder.ArmorEffectData> infernalData = List.of(AbstractArmorBuilder.ArmorEffectData.createData(() -> MobEffects.f_19600_), AbstractArmorBuilder.ArmorEffectData.createData(() -> new MobEffectInstance(MobEffects.f_19607_, 400), Entity::m_6060_));
    public static List<AbstractArmorBuilder.ArmorEffectData> etherealData = List.of(AbstractArmorBuilder.ArmorEffectData.createData(() -> MobEffects.f_19611_));
    public static List<AbstractArmorBuilder.HitEffectData> crimtaneData = List.of(AbstractArmorBuilder.HitEffectData.createData(EffectsRegistry.EXHAUSTION));
    public static final ArmorRegistry FALLEN_COLLECTOR = (ArmorRegistry)new Builder("fallen_collector").addAttr((Supplier)AttributeReg.NECROMANCY_LIFETIME, new AbstractArmorBuilder.AttributeData(15.0f, AttributeModifier.Operation.ADDITION)).addAttr(AttributeReg.NECROMANCY_COUNT, new AbstractArmorBuilder.AttributeData(3.0f, AttributeModifier.Operation.ADDITION)).protection(25.0f).mul(45).enchantValue(20).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42454_})).build();
    public static final ArmorRegistry MARSH = (ArmorRegistry)new Builder("marsh").protection(20.0f).mul(58).enchantValue(12).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.marshCloth.get()})).build();
    public static final ArmorRegistry BLACK_GOLD = (ArmorRegistry)new Builder("black_gold").protection(20.0f).mul(55).enchantValue(20).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.blackGold.get()})).build();
    public static final ArmorRegistry COBALT = (ArmorRegistry)new Builder("cobalt").protection(45.0f).mul(46).enchantValue(18).knockbackRes(0.05f).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.cobaltIngot.get()})).build();
    public static final ArmorRegistry SAMURAI = (ArmorRegistry)new Builder("samurai").protection(35.0f).mul(55).enchantValue(16).knockbackRes(0.15f).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.ancientIngot.get()})).build();
    public static final ArmorRegistry ETHEREAL = (ArmorRegistry)new Builder("ethereal").effects(etherealData).protection(50.0f).mul(60).enchantValue(18).knockbackRes(0.1f).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.etherealShard.get()})).build();
    public static final ArmorRegistry NATURE = (ArmorRegistry)new Builder("nature").effects(natureData).protection(55.0f).mul(66).enchantValue(16).knockbackRes(0.1f).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.natureIngot.get()})).build();
    public static final ArmorRegistry DEPTH = (ArmorRegistry)new Builder("depth").effects(depthData).protection(60.0f).mul(72).enchantValue(16).knockbackRes(0.1f).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.aquariusIngot.get()})).build();
    public static final ArmorRegistry INFERNAL = (ArmorRegistry)new Builder("infernal").effects(infernalData).protection(65.0f).mul(76).enchantValue(14).knockbackRes(0.12f).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.infernalIngot.get()})).build();
    public static final ArmorRegistry SPIDER = (ArmorRegistry)new Builder("spider").setVoidDefence(25.0f).protection(50.0f).mul(68).enchantValue(14).knockbackRes(0.1f).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.spiderFang.get()})).build();
    public static final ArmorRegistry PYRATITE = (ArmorRegistry)new Builder("pyratite").setVoidDefence(15.0f).protection(62.0f).mul(72).enchantValue(12).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.pyratite.get()})).build();
    public static final ArmorRegistry CRIMTANE = (ArmorRegistry)new Builder("crimtane").setVoidDefence(35.0f).hitEffects(crimtaneData).protection(68.0f).mul(72).enchantValue(12).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.painCrystal.get()})).build();
    public static final ArmorRegistry VOID = (ArmorRegistry)new Builder("awakened_void").setVoidDefence(75.0f).protection(70.0f).mul(80).enchantValue(10).knockbackRes(0.15f).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.voidIngot.get()})).build();
    public static final ArmorRegistry PHANTASM = (ArmorRegistry)new Builder("phantasm").setVoidDefence(100.0f).protection(80.0f).mul(85).enchantValue(12).knockbackRes(0.25f).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.illusionStone.get()})).build();

    public ArmorRegistry(Builder builder, List<AbstractArmorBuilder.ArmorEffectData> data, List<AbstractArmorBuilder.HitEffectData> hitEffectData) {
        super((AbstractArmorBuilder)builder, data, hitEffectData);
        this.builder = builder;
    }

    @NotNull
    public String m_6082_() {
        return "valoria:" + this.builder.name;
    }

    public static class Builder
    extends AbstractArmorBuilder<ArmorRegistry> {
        public Builder(String name) {
            super(name);
        }

        public Builder setVoidDefence(float def) {
            this.addAttr((Supplier)AttributeReg.NIHILITY_RESISTANCE, new AbstractArmorBuilder.AttributeData(def, AttributeModifier.Operation.ADDITION));
            return this;
        }

        public ArmorRegistry build() {
            return new ArmorRegistry(this, this.data, this.hitData);
        }
    }
}

