/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CrusherRecipe
implements Recipe<Container> {
    private final NonNullList<Ingredient> inputs;
    private final ResourceLocation output;
    private final ResourceLocation id;

    public CrusherRecipe(ResourceLocation id, ResourceLocation output, Ingredient ... inputItems) {
        this.id = id;
        this.output = output;
        this.inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])inputItems);
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        if (pLevel.m_5776_()) {
            return false;
        }
        return ((Ingredient)this.inputs.get(0)).test(pContainer.m_8020_(0));
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public ResourceLocation getOutput() {
        return this.output;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<CrusherRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("valoria", "crusher");

        public CrusherRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ResourceLocation output = new ResourceLocation(pSerializedRecipe.get("loot_table").getAsString());
            JsonArray pIngredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : pIngredients) {
                inputs.add(Ingredient.m_43917_((JsonElement)e));
            }
            return new CrusherRecipe(pRecipeId, output, inputs.toArray(new Ingredient[0]));
        }

        @Nullable
        public CrusherRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            Ingredient[] inputs = new Ingredient[pBuffer.readInt()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            }
            ResourceLocation output = pBuffer.m_130281_();
            return new CrusherRecipe(pRecipeId, output, inputs);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, CrusherRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.m_7527_().size());
            for (Ingredient input : pRecipe.m_7527_()) {
                input.m_43923_(pBuffer);
            }
            pBuffer.m_130085_(pRecipe.output);
        }
    }

    public static class Type
    implements RecipeType<CrusherRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "crusher";
    }
}

