/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.skins;

import com.idark.valoria.Valoria;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.item.types.KatanaItem;
import com.idark.valoria.util.Pal;
import com.idark.valoria.util.Styles;
import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.model.TridotModels;
import pro.komaru.tridot.client.model.item.CustomItemOverrides;
import pro.komaru.tridot.client.model.item.ItemSkinItemOverrides;
import pro.komaru.tridot.client.model.item.ItemSkinModels;
import pro.komaru.tridot.client.model.render.item.LargeItemRenderer;
import pro.komaru.tridot.common.registry.item.armor.SkinableArmorItem;
import pro.komaru.tridot.common.registry.item.skins.ISkinProvider;
import pro.komaru.tridot.common.registry.item.skins.ItemSkin;
import pro.komaru.tridot.common.registry.item.skins.SkinBuilder;
import pro.komaru.tridot.common.registry.item.skins.SkinEntry;
import pro.komaru.tridot.common.registry.item.skins.SkinRegistryManager;
import pro.komaru.tridot.common.registry.item.skins.entries.ItemExtendingSkinEntry;
import pro.komaru.tridot.common.registry.item.skins.entries.ItemSupplierSkinEntry;
import pro.komaru.tridot.common.registry.item.types.ConfigurableBowItem;
import pro.komaru.tridot.common.registry.item.types.ConfigurableCrossbow;
import pro.komaru.tridot.util.Col;

public class SkinsRegistry
implements ISkinProvider {
    public static ItemSkin THE_FALLEN_COLLECTOR;
    public static ItemSkin ARCANE_GOLD;
    public static ItemSkin CYBERPUNK;
    public static ItemSkin MIDNIGHT;
    public static ItemSkin MURAMASA;
    public static ItemSkin MURASAME;
    public static ItemSkin FISH;
    public static ItemSkin NERO;
    public static ItemSkin STAR_DIVIDER;
    public static ItemSkin DEATH_OF_CRABS;
    public static ItemSkin ICY;
    public static ItemSkin LOTUS;

    public void initializeSkins() {
        THE_FALLEN_COLLECTOR = new SkinBuilder("valoria", "the_fallen_collector").color(Pal.seaGreen).contributor("Kerdo", (Style)Styles.nature).add((SkinEntry)new ItemSupplierSkinEntry(() -> (Item)ItemsRegistry.murasama.get(), Valoria.loc("brand"))).build();
        ARCANE_GOLD = new SkinBuilder("valoria", "arcane_gold").color(Pal.arcaneGold).add((SkinEntry)new ItemExtendingSkinEntry(ConfigurableBowItem.class, Valoria.loc("arcane_wood_bow"))).add((SkinEntry)new ItemSupplierSkinEntry(() -> (Item)ItemsRegistry.blazeReap.get(), Valoria.loc("arcane_gold_blaze_reap"))).build();
        CYBERPUNK = new SkinBuilder("valoria", "cyberpunk").color(Pal.majestyPurple).contributor("Auriny", (Style)Styles.nihility).add((SkinEntry)new ItemSupplierSkinEntry(() -> (Item)ItemsRegistry.quantumReaper.get(), Valoria.loc("cyberpunk_quantum_reaper"))).build();
        MIDNIGHT = new SkinBuilder("valoria", "midnight").color(Pal.majestyPurple).add((SkinEntry)new ItemSupplierSkinEntry(() -> (Item)ItemsRegistry.quantumReaper.get(), Valoria.loc("midnight_quantum_reaper"))).build();
        MURAMASA = new SkinBuilder("valoria", "muramasa").color(Pal.majestyPurple).contributor("Auriny", (Style)Styles.nihility).add((SkinEntry)new ItemSupplierSkinEntry(() -> (Item)ItemsRegistry.murasama.get(), Valoria.loc("muramasa"))).build();
        MURASAME = new SkinBuilder("valoria", "muramase").color(Pal.flesh).add((SkinEntry)new ItemSupplierSkinEntry(() -> (Item)ItemsRegistry.murasama.get(), Valoria.loc("murasame"))).build();
        FISH = new SkinBuilder("valoria", "swordfish").color(Pal.crystalBlue).contributor("Skoow", (Style)Styles.aquarius).add((SkinEntry)new ItemSupplierSkinEntry(() -> (Item)ItemsRegistry.murasama.get(), Valoria.loc("swordfish"))).build();
        STAR_DIVIDER = new SkinBuilder("valoria", "star_divider").color(Pal.verySoftPink).contributor("Rainach", (Style)Styles.nihility).add((SkinEntry)new ItemSupplierSkinEntry(() -> (Item)ItemsRegistry.quantumReaper.get(), Valoria.loc("star_divider"))).build();
        NERO = new SkinBuilder("valoria", "nero").contributor("NeroWalton", (Style)Styles.phantasm).color(Col.fromHex((String)"9A2350")).add((SkinEntry)new ItemSupplierSkinEntry(() -> (Item)ItemsRegistry.phantom.get(), Valoria.loc("nero"))).build();
        DEATH_OF_CRABS = new SkinBuilder("valoria", "death_of_crabs").contributor("TerraPrime", (Style)Styles.aquarius).color(Col.fromHex((String)"76bdd1")).add((SkinEntry)new ItemSupplierSkinEntry(() -> (Item)ItemsRegistry.cobaltSword.get(), Valoria.loc("death_of_crabs"))).build();
        ICY = new SkinBuilder("valoria", "icy").color(Col.fromHex((String)"29dfeb")).add((SkinEntry)new ItemSupplierSkinEntry(() -> (Item)ItemsRegistry.voidScythe.get(), Valoria.loc("icy_scythe"))).build();
        LOTUS = new SkinBuilder("valoria", "lotus").contributor("KaJiNt", (Style)Styles.aquarius).color(Col.fromHex((String)"29dfeb")).add((SkinEntry)new ItemSupplierSkinEntry(() -> (Item)ItemsRegistry.voidScythe.get(), Valoria.loc("lotus_scythe"))).build();
    }

    public void registerModels() {
        ItemSkinModels.addBowSkin((ResourceLocation)Valoria.loc("arcane_wood_bow"));
        ItemSkinModels.add((ResourceLocation)Valoria.loc("arcane_gold_blaze_reap"));
        ItemSkinModels.add((ResourceLocation)Valoria.loc("brand"));
        ItemSkinModels.add((ResourceLocation)Valoria.loc("cyberpunk_quantum_reaper"));
        ItemSkinModels.add((ResourceLocation)Valoria.loc("midnight_quantum_reaper"));
        ItemSkinModels.add((ResourceLocation)Valoria.loc("swordfish"));
        ItemSkinModels.add((ResourceLocation)Valoria.loc("star_divider"));
        ItemSkinModels.add((ResourceLocation)Valoria.loc("muramasa"));
        ItemSkinModels.add((ResourceLocation)Valoria.loc("murasame"));
        ItemSkinModels.add((ResourceLocation)Valoria.loc("death_of_crabs"));
        ItemSkinModels.add((ResourceLocation)Valoria.loc("icy_scythe"));
        ItemSkinModels.add((ResourceLocation)Valoria.loc("lotus_scythe"));
        ItemSkinModels.add((ResourceLocation)Valoria.loc("nero"));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerKatana(ModelEvent.RegisterAdditional event) {
        for (RegistryObject item : ItemsRegistry.ITEMS.getEntries()) {
            if (!(item.get() instanceof KatanaItem) || !((KatanaItem)((Object)item.get())).builder.hasLargeModel) continue;
            event.register((ResourceLocation)LargeItemRenderer.getModelResourceLocation((String)"valoria", (String)item.getId().m_135815_()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void bakeKatana(Map<ResourceLocation, BakedModel> map) {
        for (RegistryObject item : ItemsRegistry.ITEMS.getEntries()) {
            Object object = item.get();
            if (!(object instanceof KatanaItem)) continue;
            KatanaItem katana = (KatanaItem)((Object)object);
            if (katana.builder.hasLargeModel) {
                LargeItemRenderer.bakeModel(map, (String)"valoria", (String)item.getId().m_135815_(), (CustomItemOverrides)new ItemSkinItemOverrides());
                continue;
            }
            SkinRegistryManager.addSkinModel(map, (ResourceLocation)item.getId());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void bakeArmor(Map<ResourceLocation, BakedModel> map) {
        for (RegistryObject item : ItemsRegistry.ITEMS.getEntries()) {
            if (!(item.get() instanceof SkinableArmorItem)) continue;
            SkinRegistryManager.addSkinModel(map, (ResourceLocation)item.getId());
        }
    }

    @Mod.EventBusSubscriber(modid="valoria", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientRegistryEvents {
        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onModelRegistry(ModelEvent.RegisterAdditional event) {
            SkinsRegistry.registerKatana(event);
            for (RegistryObject item : ItemsRegistry.ITEMS.getEntries()) {
                if (item.get() instanceof ConfigurableBowItem) {
                    TridotModels.addBowItemModel((ModelEvent.RegisterAdditional)event, (String)"valoria", (String)item.getId().m_135815_());
                }
                if (!(item.get() instanceof ConfigurableCrossbow)) continue;
                TridotModels.addCrossbowItemModel((ModelEvent.RegisterAdditional)event, (String)"valoria", (String)item.getId().m_135815_());
            }
            event.register((ResourceLocation)LargeItemRenderer.getModelResourceLocation((String)"valoria", (String)"void_scythe"));
            event.register((ResourceLocation)LargeItemRenderer.getModelResourceLocation((String)"valoria", (String)"cobalt_sword"));
            event.register((ResourceLocation)LargeItemRenderer.getModelResourceLocation((String)"valoria", (String)"phantom"));
            event.register((ResourceLocation)LargeItemRenderer.getModelResourceLocation((String)"valoria", (String)"blaze_reap"));
            event.register((ResourceLocation)LargeItemRenderer.getModelResourceLocation((String)"valoria", (String)"skin/lotus_scythe"));
            event.register((ResourceLocation)LargeItemRenderer.getModelResourceLocation((String)"valoria", (String)"skin/icy_scythe"));
            event.register((ResourceLocation)LargeItemRenderer.getModelResourceLocation((String)"valoria", (String)"skin/death_of_crabs"));
            event.register((ResourceLocation)LargeItemRenderer.getModelResourceLocation((String)"valoria", (String)"skin/arcane_gold_blaze_reap"));
            event.register((ResourceLocation)LargeItemRenderer.getModelResourceLocation((String)"valoria", (String)"skin/muramasa"));
            event.register((ResourceLocation)LargeItemRenderer.getModelResourceLocation((String)"valoria", (String)"skin/murasame"));
            event.register((ResourceLocation)LargeItemRenderer.getModelResourceLocation((String)"valoria", (String)"skin/brand"));
            event.register((ResourceLocation)LargeItemRenderer.getModelResourceLocation((String)"valoria", (String)"skin/nero"));
            event.register((ResourceLocation)LargeItemRenderer.getModelResourceLocation((String)"valoria", (String)"skin/swordfish"));
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onModelBake(ModelEvent.ModifyBakingResult event) {
            Map map = event.getModels();
            SkinsRegistry.bakeArmor(map);
            SkinsRegistry.bakeKatana(map);
            for (RegistryObject item : ItemsRegistry.ITEMS.getEntries()) {
                if (item.get() instanceof ConfigurableBowItem) {
                    TridotModels.addBowItemModel((Map)map, (ResourceLocation)item.getId());
                }
                if (!(item.get() instanceof ConfigurableCrossbow)) continue;
                TridotModels.addCrossbowItemModel((Map)map, (ResourceLocation)item.getId());
            }
            SkinRegistryManager.addSkinModel((Map)map, (ResourceLocation)ItemsRegistry.quantumReaper.getId());
            SkinRegistryManager.addLargeModel((Map)map, (String)"valoria", (String)"muramasa");
            SkinRegistryManager.addLargeModel((Map)map, (String)"valoria", (String)"murasame");
            SkinRegistryManager.addLargeModel((Map)map, (String)"valoria", (String)"icy_scythe");
            SkinRegistryManager.addLargeModel((Map)map, (String)"valoria", (String)"lotus_scythe");
            SkinRegistryManager.addLargeModel((Map)map, (String)"valoria", (String)"death_of_crabs");
            SkinRegistryManager.addLargeModel((Map)map, (String)"valoria", (String)"brand");
            SkinRegistryManager.addLargeModel((Map)map, (String)"valoria", (String)"arcane_gold_blaze_reap");
            SkinRegistryManager.addLargeModel((Map)map, (String)"valoria", (String)"nero");
            SkinRegistryManager.addLargeModel((Map)map, (String)"valoria", (String)"swordfish");
            LargeItemRenderer.bakeModel((Map)map, (String)"valoria", (String)"void_scythe", (CustomItemOverrides)new ItemSkinItemOverrides());
            LargeItemRenderer.bakeModel((Map)map, (String)"valoria", (String)"cobalt_sword", (CustomItemOverrides)new ItemSkinItemOverrides());
            LargeItemRenderer.bakeModel((Map)map, (String)"valoria", (String)"phantom", (CustomItemOverrides)new ItemSkinItemOverrides());
            LargeItemRenderer.bakeModel((Map)map, (String)"valoria", (String)"blaze_reap", (CustomItemOverrides)new ItemSkinItemOverrides());
        }
    }
}

