/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types;

import com.google.common.collect.ImmutableMultimap;
import com.idark.valoria.Valoria;
import com.idark.valoria.registries.AttributeReg;
import com.idark.valoria.registries.item.types.ScytheItem;
import com.idark.valoria.registries.item.types.builders.AbstractScytheBuilder;
import com.idark.valoria.util.ValoriaUtils;
import java.util.ArrayList;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.joml.Vector3d;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.client.render.screenshake.PositionedScreenshakeInstance;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeHandler;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeInstance;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.comps.phys.Pos3;
import pro.komaru.tridot.util.math.ArcRandom;

public class GlaiveItem
extends ScytheItem {
    public ArcRandom arcRandom = Tmp.rnd;

    public GlaiveItem(Builder pBuilder) {
        super(pBuilder);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.builder.attackDamageIn, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.builder.attackSpeedIn, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(Valoria.BASE_ENTITY_REACH_UUID, "Spear modifier", 1.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)AttributeReg.ATTACK_RADIUS.get()), (Object)new AttributeModifier(Valoria.BASE_ATTACK_RADIUS_UUID, "Tool modifier", (double)this.builder.attackRadius, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    @Override
    public void performAttack(Level level, ItemStack stack, Player player) {
        ArrayList<LivingEntity> hitEntities = new ArrayList<LivingEntity>();
        Vector3d pos = new Vector3d(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
        float damage = (float)player.m_21133_(Attributes.f_22281_) + EnchantmentHelper.m_44821_((LivingEntity)player);
        float radius = (float)player.m_21133_((Attribute)AttributeReg.ATTACK_RADIUS.get());
        ValoriaUtils.radiusHit(level, stack, player, this.builder.particleOptions, hitEntities, pos, 0.0f, player.m_20155_().f_82471_, radius);
        int cooldown = hitEntities.isEmpty() ? this.builder.minCooldownTime : this.builder.cooldownTime;
        this.applyCooldown(player, this.getCooldownReduction(cooldown, stack));
        for (LivingEntity entity : hitEntities) {
            if (!player.m_6779_(entity)) continue;
            entity.m_6469_(level.m_269111_().m_269075_(player), (damage + EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)entity.m_6336_())) * 1.35f);
            this.performEffects(entity, player);
            Utils.Entities.applyWithChance((LivingEntity)entity, this.builder.effects, (float)this.builder.chance, (ArcRandom)this.arcRandom);
            if (player.m_7500_()) continue;
            stack.m_41622_(hitEntities.size(), (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21166_(EquipmentSlot.MAINHAND));
        }
        ScreenshakeHandler.add((ScreenshakeInstance)new PositionedScreenshakeInstance(this.builder.screenShakeDuration, (Pos3)pro.komaru.tridot.util.phys.Vec3.from((Vec3)player.m_146892_()), 0.0f, 30.0f).intensity(this.builder.screenShakeIntensity).interp(this.builder.screenShakeEasing));
    }

    public static class Builder
    extends AbstractScytheBuilder<GlaiveItem> {
        public Builder(float attackDamageIn, float attackSpeedIn, Item.Properties itemProperties) {
            super(attackDamageIn, attackSpeedIn, itemProperties);
        }

        @Override
        public GlaiveItem build() {
            return new GlaiveItem(this);
        }
    }
}

