/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.idark.valoria.Valoria;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.particle.MinionSummonParticlePacket;
import com.idark.valoria.registries.AttributeReg;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.TagsRegistry;
import com.idark.valoria.util.Pal;
import com.idark.valoria.util.Styles;
import java.awt.Color;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.common.registry.entity.AbstractMinionEntity;
import pro.komaru.tridot.util.Col;

public class SummonBook
extends Item {
    public final Multimap<Attribute, AttributeModifier> defaultModifiers;
    public boolean hasLimitedLife = true;
    private static final ResourceKey<EntityType<?>> DEFAULT_VARIANT = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.ENTITY_TYPES, (ResourceLocation)new ResourceLocation("valoria", "undead"));

    public SummonBook(int lifetime, int count, Item.Properties pProperties) {
        super(pProperties.m_41487_(1));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)((Attribute)AttributeReg.NECROMANCY_LIFETIME.get()), (Object)new AttributeModifier(Valoria.BASE_NECROMANCY_LIFETIME_UUID, "Tool modifier", (double)lifetime, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)AttributeReg.NECROMANCY_COUNT.get()), (Object)new AttributeModifier(Valoria.BASE_NECROMANCY_COUNT_UUID, "Tool modifier", (double)count, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    protected EntityType<?> getDefaultType(ItemStack stack) {
        String entityId = stack.m_41698_("EntityTag").m_128461_("id");
        ResourceLocation entityLocation = new ResourceLocation(entityId);
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityLocation);
    }

    public static void storeVariant(CompoundTag pTag, Holder<EntityType<?>> pType) {
        pTag.m_128359_("id", pType.m_203543_().orElse(DEFAULT_VARIANT).m_135782_().toString());
    }

    public static void setColor(ItemStack pStack, int pColor) {
        pStack.m_41698_("DisplayColor").m_128405_("color", pColor);
    }

    public static int getColor(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41737_("DisplayColor");
        return compoundtag != null && compoundtag.m_128425_("color", 99) ? compoundtag.m_128451_("color") : Col.toDecimal((Col)Pal.lightViolet);
    }

    public int getLifetime(Player player) {
        return (int)(player.m_21133_((Attribute)AttributeReg.NECROMANCY_LIFETIME.get()) * 20.0);
    }

    public void applyCooldown(Player playerIn) {
        for (Item item : ForgeRegistries.ITEMS) {
            if (!(item instanceof SummonBook)) continue;
            playerIn.m_36335_().m_41524_(item, 175 + this.getLifetime(playerIn));
        }
    }

    private void spawnMinions(ServerLevel serverLevel, Player player, ItemStack stack) {
        BlockPos blockpos = player.m_20097_().m_7494_();
        Entity base = this.getDefaultType(stack).m_20615_(player.m_9236_());
        if (base instanceof AbstractMinionEntity) {
            AbstractMinionEntity summoned = (AbstractMinionEntity)base;
            RandomSource rand = serverLevel.f_46441_;
            double x = (double)blockpos.m_123341_() + (rand.m_188500_() - rand.m_188500_()) * 6.0;
            double y = blockpos.m_123342_() + rand.m_216339_(1, 2);
            double z = (double)blockpos.m_123343_() + (rand.m_188500_() - rand.m_188500_()) * 6.0;
            BlockPos spawnPos = BlockPos.m_274446_((Position)new Vec3(x, y, z));
            if (serverLevel.m_46859_(blockpos)) {
                summoned.m_20035_(spawnPos, 0.0f, 0.0f);
                summoned.m_6518_((ServerLevelAccessor)serverLevel, player.m_9236_().m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                summoned.setOwner((LivingEntity)player);
                summoned.setBoundOrigin(blockpos);
                if (this.hasLimitedLife) {
                    summoned.setLimitedLife(this.getLifetime(player) + serverLevel.f_46441_.m_188503_(60));
                }
                serverLevel.m_7967_((Entity)summoned);
                PacketHandler.sendToTracking((Level)serverLevel, blockpos, new MinionSummonParticlePacket(summoned.m_19879_(), player.m_20097_().m_7494_()));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (this.getDefaultType(itemstack).m_204039_(TagsRegistry.MINIONS) && !playerIn.m_6144_()) {
            playerIn.m_6672_(handIn);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public int m_8105_(ItemStack stack) {
        return 7;
    }

    public SoundEvent getUseSound() {
        return (SoundEvent)SoundsRegistry.NECROMANCER_SUMMON_AIR.get();
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entityLiving) {
        Player player = (Player)entityLiving;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            for (int i = 0; i < (int)player.m_21133_((Attribute)AttributeReg.NECROMANCY_COUNT.get()); ++i) {
                this.spawnMinions(server, player, stack);
            }
            if (!player.m_7500_()) {
                stack.m_41622_(1, (LivingEntity)player, plr -> plr.m_21166_(EquipmentSlot.MAINHAND));
            }
            level.m_247517_(null, player.m_20183_(), this.getUseSound(), SoundSource.PLAYERS);
            this.applyCooldown(player);
        }
        return stack;
    }

    public Component getHighlightTip(ItemStack stack, Component displayName) {
        if (this.getDefaultType(stack).m_204039_(TagsRegistry.MINIONS)) {
            return displayName.m_6881_().m_7220_((Component)Component.m_237113_((String)(" [" + this.getDefaultType(stack).m_20676_().getString() + "]")).m_130948_((Style)Styles.create(Col.fromColor((Color)AbstractMinionEntity.getColor(this.getDefaultType(stack)).brighter().brighter()))));
        }
        return super.getHighlightTip(stack, displayName);
    }

    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.valoria.necromancy").m_130940_(ChatFormatting.GRAY));
        if (this.getDefaultType(stack).m_204039_(TagsRegistry.MINIONS)) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.valoria.summons", (Object[])new Object[]{this.getDefaultType(stack).m_20676_()}).m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"tooltip.valoria.hold_rmb").m_130938_(style -> style.m_131150_(Valoria.FONT)));
    }
}

