/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.curio.charm;

import com.idark.valoria.core.capability.IMagmaLevel;
import com.idark.valoria.registries.item.types.curio.ValoriaCurioItem;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;

public class TimedMagmaImmunityItem
extends ValoriaCurioItem {
    private final int time;

    public TimedMagmaImmunityItem(int sec, Item.Properties properties) {
        super(properties);
        this.time = sec;
    }

    @Override
    public int immunityTime() {
        return this.time;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCapability(IMagmaLevel.INSTANCE).ifPresent(magma -> magma.addMaxAmount((LivingEntity)player, this.time));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCapability(IMagmaLevel.INSTANCE).ifPresent(magma -> magma.decreaseMaxAmount((LivingEntity)player, this.time));
        }
    }
}

