/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.elemental;

import com.idark.valoria.Valoria;
import com.idark.valoria.core.config.ClientConfig;
import com.idark.valoria.registries.EffectsRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.item.types.ValoriaSword;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.api.interfaces.OverlayRenderItem;
import pro.komaru.tridot.api.interfaces.RadiusItem;
import pro.komaru.tridot.common.registry.item.TooltipComponentItem;
import pro.komaru.tridot.common.registry.item.components.AbilityComponent;
import pro.komaru.tridot.common.registry.item.components.SeparatorComponent;
import pro.komaru.tridot.common.registry.item.components.TextComponent;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;
import pro.komaru.tridot.util.struct.data.Seq;

public class EtherealSwordItem
extends ValoriaSword
implements TooltipComponentItem,
RadiusItem,
OverlayRenderItem {
    private static final ResourceLocation BAR = new ResourceLocation("valoria", "textures/gui/overlay/soul_bar.png");
    public ArcRandom arcRandom = Tmp.rnd;
    public int max;
    public int current;

    public EtherealSwordItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        this(tier, attackDamageIn, attackSpeedIn, 0, 25, builderIn);
    }

    public EtherealSwordItem(Tier tier, float attackDamageIn, float attackSpeedIn, int current, int max, Item.Properties builderIn) {
        super(tier, attackDamageIn, attackSpeedIn, builderIn);
        this.max = max;
        this.current = current;
    }

    public ItemStack m_7968_() {
        return this.setSword(super.m_7968_());
    }

    public ItemStack setSword(ItemStack pStack) {
        pStack.m_41784_().m_128405_("Souls", this.current);
        return pStack;
    }

    public static void addCharge(ItemStack stack, int charge) {
        CompoundTag nbt = stack.m_41784_();
        int charges = nbt.m_128451_("charge");
        nbt.m_128405_("charge", charges + charge);
    }

    public int getMaxSouls() {
        return this.max;
    }

    public int getCurrentSouls(ItemStack pStack) {
        return pStack.m_41784_().m_128451_("Souls");
    }

    public void setCount(int count, ItemStack pStack) {
        pStack.m_41749_("Souls");
        pStack.m_41784_().m_128405_("Souls", count);
    }

    public void removeCount(int count, ItemStack pStack) {
        pStack.m_41784_().m_128405_("Souls", this.getCurrentSouls(pStack) - count);
    }

    public void addCount(int count, ItemStack pStack, Player player) {
        if (pStack.m_41784_().m_128451_("Souls") + count <= this.getMaxSouls()) {
            pStack.m_41784_().m_128405_("Souls", this.getCurrentSouls(pStack) + count);
            player.m_9236_().m_5594_(null, player.m_20097_(), this.getCollectSound(), SoundSource.PLAYERS, 1.0f, player.m_9236_().f_46441_.m_188501_());
        }
    }

    public SoundEvent getCollectSound() {
        return (SoundEvent)SoundsRegistry.SOUL_COLLECT.get();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchant) {
        return super.canApplyAtEnchantingTable(stack, enchant) && enchant != Enchantments.f_44981_;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        boolean flag = pPlayer.m_36335_().m_41519_(stack.m_41720_());
        if (!flag && this.getCurrentSouls(stack) >= this.getMaxSouls()) {
            pPlayer.m_7292_(new MobEffectInstance((MobEffect)EffectsRegistry.SOUL_BURST.get(), 220, 0));
            pPlayer.m_36335_().m_41524_(stack.m_41720_(), 600);
            this.setCount(0, stack);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public ResourceLocation getTexture() {
        return BAR;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(CompoundTag tag, GuiGraphics gui, int offsetX, int offsetY) {
        int xCord = (Integer)ClientConfig.SOUL_BAR_X.get() + offsetX;
        int yCord = (Integer)ClientConfig.SOUL_BAR_Y.get() + offsetY;
        int progress = 24;
        progress = (int)((float)progress / ((float)this.getMaxSouls() / (float)tag.m_128451_("Souls")));
        gui.m_280163_(BAR, xCord, yCord, 0.0f, 0.0f, 32, 32, 64, 64);
        gui.m_280163_(BAR, xCord, yCord - 4 + (32 - progress), 0.0f, (float)(28 + (32 - progress)), 32, progress, 64, 64);
    }

    public Seq<TooltipComponent> getTooltips(ItemStack itemStack) {
        return Seq.with((Object[])new TooltipComponent[]{new SeparatorComponent((Component)Component.m_237115_((String)"tooltip.valoria.abilities")), new AbilityComponent(Component.m_237115_((String)"tooltip.valoria.ethereal_sword").m_130940_(ChatFormatting.GRAY), Valoria.loc("textures/mob_effect/soul_burst.png")), new TextComponent(Component.m_237110_((String)"tooltip.valoria.souls", (Object[])new Object[]{this.getCurrentSouls(itemStack)}).m_130946_(" / ").m_130946_(String.valueOf(this.getMaxSouls())).m_130940_(ChatFormatting.GRAY)), new TextComponent(Component.m_237115_((String)"tooltip.valoria.rmb").m_130938_(style -> style.m_131150_(Valoria.FONT)))});
    }
}

