/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.ranged;

import com.idark.valoria.Valoria;
import com.idark.valoria.core.config.ClientConfig;
import com.idark.valoria.registries.EnchantmentsRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.item.types.ValoriaPickaxe;
import com.idark.valoria.registries.item.types.ranged.GunpowderCharge;
import com.idark.valoria.util.ValoriaUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.api.interfaces.OverlayRenderItem;
import pro.komaru.tridot.client.render.screenshake.PositionedScreenshakeInstance;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeHandler;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeInstance;
import pro.komaru.tridot.common.registry.item.TooltipComponentItem;
import pro.komaru.tridot.common.registry.item.components.AbilityComponent;
import pro.komaru.tridot.common.registry.item.components.SeparatorComponent;
import pro.komaru.tridot.common.registry.item.components.TextComponent;
import pro.komaru.tridot.util.comps.phys.Pos3;
import pro.komaru.tridot.util.math.Interp;
import pro.komaru.tridot.util.struct.data.Seq;

public class BlazeReapItem
extends ValoriaPickaxe
implements Vanishable,
OverlayRenderItem,
TooltipComponentItem {
    private static final ResourceLocation BAR = new ResourceLocation("valoria", "textures/gui/overlay/blazecharge_bar.png");

    public BlazeReapItem(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
    }

    public static String getModeString(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("charge") && nbt.m_128451_("charge") == 1) {
            return "tooltip.valoria.rmb";
        }
        return "tooltip.valoria.rmb_shift";
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchant) {
        return enchant.f_44672_ == EnchantmentCategory.WEAPON || enchant.f_44672_ == EnchantmentCategory.DIGGER || enchant.f_44672_ == EnchantmentsRegistry.BLAZE;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack weapon = player.m_21120_(hand);
        ItemStack ammo = ValoriaUtils.getProjectile(player, weapon);
        RandomSource rand = level.m_213780_();
        CompoundTag nbt = weapon.m_41784_();
        boolean hasAmmo = !ammo.m_41619_();
        boolean flag = ammo.m_41720_() instanceof GunpowderCharge;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player.m_6144_()) {
                this.recharge(player, serverLevel, nbt, hasAmmo, ammo, rand);
                return InteractionResultHolder.m_19098_((Object)weapon);
            }
            if (nbt.m_128451_("charge") == 1) {
                float knockback;
                HitResult hitresult;
                nbt.m_128405_("charge", 0);
                player.m_36335_().m_41524_((Item)this, 40);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                Vec3 pos = new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
                double pitch = (double)(player.m_20155_().f_82470_ + 90.0f) * Math.PI / 180.0;
                double yaw = (double)(player.m_20155_().f_82471_ + 90.0f) * Math.PI / 180.0;
                double X = Math.sin(pitch) * Math.cos(yaw) * 15.0;
                double Y = Math.cos(pitch) * 15.0;
                double Z = Math.sin(pitch) * Math.sin(yaw) * 15.0;
                Vec3 playerPos = player.m_146892_();
                Vec3 EndPos = player.m_20252_(0.0f).m_82490_(20.0);
                if (ProjectileUtil.m_37287_((Entity)player, (Vec3)playerPos, (Vec3)EndPos, (AABB)new AABB(pos.f_82479_ + X - 3.0, pos.f_82480_ + Y - 3.0, pos.f_82481_ + Z - 3.0, pos.f_82479_ + X + 3.0, pos.f_82480_ + Y + 3.0, pos.f_82481_ + Z + 3.0), e -> true, (double)20.0) == null && (hitresult = Utils.Hit.hitResult((Vec3)playerPos, (Entity)player, e -> true, (Vec3)EndPos, (Level)level)) != null) {
                    switch (hitresult.m_6662_()) {
                        case BLOCK: {
                            X = hitresult.m_82450_().m_7096_() - pos.f_82479_;
                            Y = hitresult.m_82450_().m_7098_() - pos.f_82480_;
                            Z = hitresult.m_82450_().m_7094_() - pos.f_82481_;
                            break;
                        }
                        case ENTITY: {
                            Entity entity = ((EntityHitResult)hitresult).m_82443_();
                            X = entity.m_20185_() - pos.f_82479_;
                            Y = entity.m_20186_() - pos.f_82480_;
                            Z = entity.m_20189_() - pos.f_82481_;
                            break;
                        }
                    }
                }
                float radius = flag ? ((GunpowderCharge)ammo.m_41720_()).getRadius() : 3.0f;
                float damage = flag ? ((GunpowderCharge)ammo.m_41720_()).getDamage() : 25.0f;
                float f = knockback = flag ? ((GunpowderCharge)ammo.m_41720_()).getKnockback() : 0.5f;
                if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)EnchantmentsRegistry.EXPLOSIVE_FLAME.get()), (ItemStack)weapon) > 0) {
                    level.m_254849_((Entity)player, pos.f_82479_ + X, pos.f_82480_ + Y, pos.f_82481_ + Z, radius, Level.ExplosionInteraction.TNT);
                } else {
                    Utils.Hit.explosion((Player)player, (ItemStack)weapon, (Vec3)pos, (Vec3)new Vec3(X, Y, Z), (float)radius, (float)damage, (float)knockback);
                }
                ScreenshakeHandler.add((ScreenshakeInstance)new PositionedScreenshakeInstance(5, (Pos3)pro.komaru.tridot.util.phys.Vec3.from((Vec3)player.m_146892_()), 15.0f, 30.0f).intensity(radius * 0.85f).interp((Interp)Interp.bounce));
                double offset = (rand.m_188500_() - 0.5) * (double)radius;
                double speed = 0.05 * offset;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, pos.f_82479_ + X, pos.f_82480_ + Y, pos.f_82481_ + Z, 12, offset, offset, offset, speed);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, pos.f_82479_ + X, pos.f_82480_ + Y, pos.f_82481_ + Z, 12, offset, offset, offset, speed);
                return InteractionResultHolder.m_19090_((Object)weapon);
            }
        }
        return InteractionResultHolder.m_19098_((Object)weapon);
    }

    private void recharge(Player player, ServerLevel serverLevel, CompoundTag nbt, boolean hasAmmo, ItemStack ammo, RandomSource rand) {
        if (nbt.m_128451_("charge") == 0) {
            if (hasAmmo) {
                if (!player.m_7500_()) {
                    ammo.m_41774_(1);
                }
                nbt.m_128405_("charge", 1);
                player.m_36335_().m_41524_((Item)this, 20);
                serverLevel.m_5594_(null, player.m_20183_(), (SoundEvent)SoundsRegistry.BLAZECHARGE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"tooltip.valoria.recharge").m_130940_(ChatFormatting.GRAY), true);
            }
            double d0 = rand.m_188583_() * 0.02;
            double d2 = rand.m_188583_() * 0.02;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, player.m_20208_(1.0), player.m_20187_() - 0.5, player.m_20262_(1.0), 6, d0, 0.0, d2, 0.025);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<ItemStack> getAmmunition() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        NonNullList items = player.m_150109_().f_35974_;
        ArrayList<ItemStack> ammoItems = new ArrayList<ItemStack>();
        for (ItemStack stack : items) {
            if (!(stack.m_41720_() instanceof GunpowderCharge)) continue;
            ammoItems.add(stack);
        }
        return ammoItems;
    }

    public ResourceLocation getTexture() {
        return BAR;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(CompoundTag tag, GuiGraphics gui, int offsetX, int offsetY) {
        gui.m_280168_().m_85836_();
        LocalPlayer plr = Minecraft.m_91087_().f_91074_;
        if (plr != null) {
            boolean flag = plr.m_21206_().m_41720_() instanceof OverlayRenderItem;
            int xCord = (Integer)ClientConfig.MAGMA_CHARGE_BAR_X.get();
            int yCord = flag ? (Integer)ClientConfig.MAGMA_CHARGE_BAR_Y.get() + 35 : (Integer)ClientConfig.MAGMA_CHARGE_BAR_Y.get();
            gui.m_280163_(BAR, xCord, yCord, 0.0f, 0.0f, 73, 19, 128, 64);
            float y = yCord + 10;
            List<ItemStack> ammunition = BlazeReapItem.getAmmunition();
            int itemCount = Math.min(ammunition.size(), 3);
            for (int i = 0; i < itemCount; ++i) {
                ItemStack stack = ammunition.get(i);
                Utils.Render.renderItemModelInGui((ItemStack)stack, (float)(xCord + 16 * i), (float)y, (float)16.0f, (float)16.0f, (float)16.0f);
            }
        }
        gui.m_280168_().m_85849_();
    }

    public Seq<TooltipComponent> getTooltips(ItemStack pStack) {
        return Seq.with((Object[])new TooltipComponent[]{new SeparatorComponent((Component)Component.m_237115_((String)"tooltip.valoria.abilities")), new AbilityComponent(Component.m_237115_((String)"tooltip.valoria.blazereap").m_130940_(ChatFormatting.GRAY), Valoria.loc("textures/gui/tooltips/boom.png")), new TextComponent(Component.m_237115_((String)BlazeReapItem.getModeString(pStack)).m_130940_(ChatFormatting.GREEN))});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"tooltip.valoria.familiar").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }
}

