/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.ranged;

import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.entity.projectile.ThrownSpearEntity;
import com.idark.valoria.registries.item.types.ranged.SpearItem;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class ExplosiveSpearItem
extends SpearItem
implements Vanishable {
    private final Level.ExplosionInteraction interaction;
    private final float explosive_radius;

    public ExplosiveSpearItem(Tier tier, int attackDamageIn, float attackSpeedIn, float pRadius, Level.ExplosionInteraction interaction, Item.Properties builderIn, MobEffectInstance ... pEffects) {
        super(tier, (float)attackDamageIn, attackSpeedIn, builderIn, pEffects);
        this.interaction = interaction;
        this.explosive_radius = pRadius;
    }

    public ExplosiveSpearItem(Tier tier, int attackDamageIn, float attackSpeedIn, float pChance, float pRadius, Level.ExplosionInteraction interaction, Item.Properties builderIn, MobEffectInstance ... pEffects) {
        super(tier, (float)attackDamageIn, attackSpeedIn, pChance, builderIn, pEffects);
        this.interaction = interaction;
        this.explosive_radius = pRadius;
    }

    @Override
    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player playerEntity = (Player)entityLiving;
            int i = this.m_8105_(stack) - timeLeft;
            if (i >= 6) {
                if (!worldIn.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)playerEntity, player -> player.m_21190_(entityLiving.m_7655_()));
                    ThrownSpearEntity spear = new ThrownSpearEntity(worldIn, (LivingEntity)playerEntity, stack);
                    spear.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, 2.5f, 1.0f);
                    spear.setExplode(this.interaction, this.explosive_radius);
                    if (playerEntity.m_150110_().f_35937_) {
                        spear.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44981_, (ItemStack)stack) > 0) {
                        spear.m_20254_(100);
                    }
                    spear.setEffectsFromList(this.builder.effects);
                    worldIn.m_7967_((Entity)spear);
                    worldIn.m_6269_(null, (Entity)spear, (SoundEvent)SoundsRegistry.SPEAR_THROW.get(), SoundSource.PLAYERS, 1.0f, 0.9f);
                    if (!playerEntity.m_150110_().f_35937_) {
                        playerEntity.m_150109_().m_36057_(stack);
                    }
                }
                playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }
}

