/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.gfx.text;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class DotTextParser {
    public static List<Component> parse(String input, int wrapWidth, Font font) {
        ArrayList<Component> lines = new ArrayList<Component>();
        List<TextSegment> segments = DotTextParser.parseTags(input);
        MutableComponent currentLine = Component.m_237119_();
        int currentLineWidth = 0;
        for (TextSegment segment : segments) {
            String text = segment.text();
            Style style = segment.style();
            StringBuilder currentWord = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                currentWord.append(c);
                boolean isNewline = c == '\n';
                boolean isSpace = c == ' ';
                boolean isCJK = Character.isIdeographic(c);
                if (!isNewline && !isSpace && !isCJK && i != text.length() - 1) continue;
                if (isNewline) {
                    if (!currentWord.isEmpty()) {
                        currentLine.m_7220_((Component)Component.m_237113_((String)currentWord.substring(0, currentWord.length() - 1)).m_130948_(style));
                    }
                    lines.add((Component)currentLine);
                    currentLine = Component.m_237119_();
                    currentLineWidth = 0;
                    currentWord.setLength(0);
                    continue;
                }
                MutableComponent wordComp = Component.m_237113_((String)currentWord.toString()).m_130948_(style);
                int wordWidth = font.m_92852_((FormattedText)wordComp);
                if (currentLineWidth + wordWidth > wrapWidth && currentLineWidth > 0) {
                    lines.add((Component)currentLine);
                    currentLine = Component.m_237119_();
                    currentLineWidth = 0;
                }
                currentLine.m_7220_((Component)wordComp);
                currentLineWidth += wordWidth;
                currentWord.setLength(0);
            }
        }
        if (currentLineWidth > 0 || !currentLine.m_7360_().isEmpty()) {
            lines.add((Component)currentLine);
        }
        if (lines.isEmpty()) {
            lines.add((Component)Component.m_237119_());
        }
        return lines;
    }

    private static List<TextSegment> parseTags(String input) {
        ArrayList<TextSegment> segments = new ArrayList<TextSegment>();
        StringBuilder buffer = new StringBuilder();
        Style currentStyle = Style.f_131099_;
        for (int i = 0; i < input.length(); ++i) {
            char chr = input.charAt(i);
            if (chr == '&' && i + 1 < input.length()) {
                if (!buffer.isEmpty()) {
                    segments.add(new TextSegment(buffer.toString(), currentStyle));
                    buffer.setLength(0);
                }
                char code = input.charAt(i + 1);
                ++i;
                currentStyle = switch (code) {
                    case 'i' -> currentStyle.m_131155_(Boolean.valueOf(true));
                    case 'b' -> currentStyle.m_131136_(Boolean.valueOf(true));
                    case 's' -> currentStyle.m_178522_(Boolean.valueOf(true));
                    case 'u' -> currentStyle.m_131162_(Boolean.valueOf(true));
                    case 'k' -> currentStyle.m_178524_(Boolean.valueOf(true));
                    case 'r' -> Style.f_131099_;
                    default -> {
                        buffer.append('&').append(code);
                        yield currentStyle;
                    }
                };
                continue;
            }
            if (chr == '/' && i + 1 < input.length() && input.charAt(i + 1) == '&') {
                if (!buffer.isEmpty()) {
                    segments.add(new TextSegment(buffer.toString(), currentStyle));
                    buffer.setLength(0);
                }
                currentStyle = Style.f_131099_;
                ++i;
                continue;
            }
            if (chr == '#' && i + 6 < input.length()) {
                String hex = input.substring(i + 1, i + 7);
                if (hex.matches("[0-9a-fA-F]{6}")) {
                    if (!buffer.isEmpty()) {
                        segments.add(new TextSegment(buffer.toString(), currentStyle));
                        buffer.setLength(0);
                    }
                    try {
                        int colorValue = Integer.parseInt(hex, 16);
                        currentStyle = currentStyle.m_131148_(TextColor.m_131266_((int)colorValue));
                        i += 6;
                    }
                    catch (NumberFormatException ignored) {
                        buffer.append('#');
                    }
                    continue;
                }
                buffer.append('#');
                continue;
            }
            buffer.append(chr);
        }
        if (!buffer.isEmpty()) {
            segments.add(new TextSegment(buffer.toString(), currentStyle));
        }
        return segments;
    }

    private record TextSegment(String text, Style style) {
    }
}

