/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.model.render.entity;

import com.mojang.datafixers.util.Pair;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChestRaftModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.RaftModel;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.NotNull;

public class CustomBoatRenderer
extends BoatRenderer {
    private final ResourceLocation boatTexture;
    private ListModel<Boat> boatModel;

    public CustomBoatRenderer(EntityRendererProvider.Context context, ResourceLocation boatTexture, boolean chest, boolean raft) {
        super(context, chest);
        this.boatTexture = boatTexture;
        this.createModels(chest, raft);
    }

    public CustomBoatRenderer(EntityRendererProvider.Context context, String modId, String texture, boolean chest, boolean raft) {
        super(context, chest);
        String path = chest ? "textures/entity/chest_boat/" + texture + ".png" : "textures/entity/boat/" + texture + ".png";
        this.boatTexture = new ResourceLocation(modId, path);
        this.createModels(chest, raft);
    }

    public void createModels(boolean chest, boolean raft) {
        this.boatModel = raft ? (chest ? new ChestRaftModel(ChestRaftModel.m_246875_().m_171564_()) : new RaftModel(RaftModel.m_247376_().m_171564_())) : (chest ? new ChestBoatModel(ChestBoatModel.m_247175_().m_171564_()) : new BoatModel(BoatModel.m_246613_().m_171564_()));
    }

    @NotNull
    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(@NotNull Boat boat) {
        return Pair.of((Object)this.boatTexture, this.boatModel);
    }
}

