/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import pro.komaru.tridot.common.registry.item.skins.ItemSkin;
import pro.komaru.tridot.common.registry.item.skins.SkinRegistryManager;

public class ItemSkinArgumentType
implements ArgumentType<ItemSkin> {
    private static final DynamicCommandExceptionType UNKNOWN = new DynamicCommandExceptionType(obj -> Component.m_237110_((String)"commands.tridot.skin.unknown", (Object[])new Object[]{obj}));

    public static ItemSkinArgumentType skinArgument() {
        return new ItemSkinArgumentType();
    }

    public static ItemSkin getSkin(CommandContext<?> context, String name) {
        return (ItemSkin)context.getArgument(name, ItemSkin.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        for (ItemSkin itemSkin : SkinRegistryManager.getSkins()) {
            builder.suggest(String.valueOf(itemSkin.id()));
        }
        return builder.buildFuture();
    }

    public ItemSkin parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation resourceLocation = ResourceLocation.m_135818_((StringReader)reader);
        ItemSkin itemSkin = SkinRegistryManager.get(resourceLocation.toString());
        if (itemSkin == null) {
            throw UNKNOWN.create((Object)resourceLocation.toString());
        }
        return itemSkin;
    }
}

