/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.entity;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;
import pro.komaru.tridot.api.interfaces.Allied;
import pro.komaru.tridot.common.registry.entity.AbstractMinionEntity;
import pro.komaru.tridot.common.registry.entity.MultiAttackMob;

public abstract class AbstractMultiAttackMinion
extends MultiAttackMob
implements OwnableEntity,
Allied {
    @Nullable
    public BlockPos boundOrigin;
    public boolean hasLimitedLife;
    public int limitedLifeTicks;
    public static final Map<EntityType<? extends AbstractMinionEntity>, Color> minionColors = new HashMap<EntityType<? extends AbstractMinionEntity>, Color>();
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(AbstractMultiAttackMinion.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    protected AbstractMultiAttackMinion(EntityType<? extends MultiAttackMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void m_8119_() {
        Level level;
        super.m_8119_();
        this.m_20242_(true);
        if (this.hasLimitedLife && --this.limitedLifeTicks <= 0 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serv = (ServerLevel)level;
            this.spawnDisappearParticles(serv);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (this.m_6783_(4.0)) {
            this.spawnParticlesTrail();
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        UUID uuid;
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("BoundX")) {
            this.boundOrigin = new BlockPos(pCompound.m_128451_("BoundX"), pCompound.m_128451_("BoundY"), pCompound.m_128451_("BoundZ"));
        }
        if (pCompound.m_128403_("Owner")) {
            uuid = pCompound.m_128342_("Owner");
        } else {
            String s = pCompound.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (pCompound.m_128441_("LifeTicks")) {
            this.setLimitedLife(pCompound.m_128451_("LifeTicks"));
        }
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.boundOrigin != null) {
            pCompound.m_128405_("BoundX", this.boundOrigin.m_123341_());
            pCompound.m_128405_("BoundY", this.boundOrigin.m_123342_());
            pCompound.m_128405_("BoundZ", this.boundOrigin.m_123343_());
        }
        if (this.m_21805_() != null) {
            pCompound.m_128362_("Owner", this.m_21805_());
        }
        if (this.hasLimitedLife) {
            pCompound.m_128405_("LifeTicks", this.limitedLifeTicks);
        }
    }

    public void spawnDisappearParticles(ServerLevel serverLevel) {
    }

    public void spawnParticlesTrail() {
    }

    public static Color getColor(EntityType<? extends AbstractMinionEntity> entityType) {
        return minionColors.getOrDefault(entityType, Color.WHITE);
    }

    public boolean isOwned() {
        return this.m_269323_() != null;
    }

    public Team m_5647_() {
        LivingEntity livingentity;
        if (this.isOwned() && (livingentity = this.m_269323_()) != null) {
            return livingentity.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean isOwnedBy(LivingEntity pEntity) {
        return pEntity == this.m_269323_();
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(pUuid));
    }

    public void setOwner(LivingEntity pOwner) {
        this.setOwnerUUID(pOwner.m_20148_());
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_7640_() == this.m_269323_() && this.m_269323_() != null && !this.m_269323_().m_6144_()) {
            return false;
        }
        if (pSource.m_7640_() instanceof Allied) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected boolean m_6125_() {
        return super.m_6125_() && this.m_269323_() == null;
    }

    public boolean m_7307_(Entity pEntity) {
        LivingEntity target;
        return super.m_7307_(pEntity) || pEntity instanceof Allied || pEntity instanceof LivingEntity && this.isOwnedBy(target = (LivingEntity)pEntity);
    }

    public boolean m_6779_(LivingEntity pTarget) {
        boolean flag = !this.isOwnedBy(pTarget) || !this.m_7307_((Entity)pTarget);
        return super.m_6779_(pTarget) && (flag || this.m_269323_() != null && this.m_269323_().m_6779_(pTarget));
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos pBoundOrigin) {
        this.boundOrigin = pBoundOrigin;
    }

    public void setLimitedLife(int pLimitedLifeTicks) {
        this.hasLimitedLife = true;
        this.limitedLifeTicks = pLimitedLifeTicks;
    }
}

