/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.entity.system;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import pro.komaru.tridot.common.registry.entity.system.AttackSystemMob;

public abstract class AttackInstance {
    public final int attackDelay;
    public final int attackDuration;
    public final int cooldown;
    public float damage;
    public float range;
    public final PathfinderMob mob;
    public int cooldownTimer;
    public boolean isFinished = false;

    public AttackInstance(PathfinderMob mob, float damage, float range, int attackDelay, int attackDuration, int cooldown) {
        this.mob = mob;
        this.damage = damage;
        this.range = range;
        this.attackDelay = attackDelay;
        this.attackDuration = attackDuration;
        this.cooldown = cooldown;
    }

    public abstract ResourceLocation getId();

    public boolean canUse(LivingEntity target) {
        if (this.isOnCooldown()) {
            return false;
        }
        return this.isWithinAttackRange(target, this.range);
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public abstract int preference(Entity var1);

    public SoundEvent getPrepareSound() {
        return null;
    }

    public SoundEvent getAttackSound() {
        return null;
    }

    public void start(AttackSystemMob systemMob) {
    }

    public void stop() {
    }

    public void tick() {
    }

    public void setAttackOnCooldown() {
        this.cooldownTimer = this.cooldown;
    }

    public int getCooldownTimer() {
        return this.cooldownTimer;
    }

    public double getAttackRangeSqr(LivingEntity pEntity, double range) {
        return (double)this.mob.m_20205_() * range * (double)this.mob.m_20205_() * range + (double)pEntity.m_20205_();
    }

    public double getPerceivedTargetDistanceSquareForAttack(LivingEntity target) {
        return Math.max(this.mob.m_20238_(target.m_262803_()), this.mob.m_20238_(target.m_20182_()));
    }

    public boolean isWithinAttackRange(LivingEntity pEntity, double range) {
        double d0 = this.getPerceivedTargetDistanceSquareForAttack(pEntity);
        return d0 <= this.getAttackRangeSqr(pEntity, range);
    }

    public boolean canPerformAttack(LivingEntity target) {
        return this.isWithinAttackRange(target, this.range);
    }

    public abstract void performAttack();

    public boolean isOnCooldown() {
        return this.cooldownTimer > 0;
    }
}

