/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.entity.system;

import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import pro.komaru.tridot.common.registry.entity.system.AttackInstance;
import pro.komaru.tridot.util.struct.data.Seq;

public class AttackSelector {
    public final Seq<AttackInstance> attacks = Seq.with();

    public void addAttack(AttackInstance attack) {
        this.attacks.add(attack);
    }

    @Nullable
    public AttackInstance selectAttack(PathfinderMob mobEntity, LivingEntity target) {
        Seq<AttackInstance> usableAttacks = Seq.with();
        int totalWeight = 0;
        for (AttackInstance attack : this.attacks) {
            if (attack.isOnCooldown() || !attack.canUse(target)) continue;
            usableAttacks.add(attack);
            totalWeight += attack.preference((Entity)target);
        }
        if (usableAttacks.isEmpty()) {
            return null;
        }
        if (totalWeight <= 0) {
            return (AttackInstance)usableAttacks.get(mobEntity.m_217043_().m_188503_(usableAttacks.size));
        }
        int random = mobEntity.m_217043_().m_188503_(totalWeight);
        for (AttackInstance attack : usableAttacks) {
            int weight = attack.preference((Entity)target);
            if (random < weight) {
                return attack;
            }
            random -= weight;
        }
        return null;
    }
}

