/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.entity.system.generic;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import pro.komaru.tridot.Tridot;
import pro.komaru.tridot.common.registry.entity.system.AttackInstance;
import pro.komaru.tridot.common.registry.entity.system.AttackSystemMob;

public class TridotMeleeAttack
extends AttackInstance {
    public final float speedModifier;
    public int ticksUntilNextPathRecalc;
    public double lastTargetX;
    public double lastTargetY;
    public double lastTargetZ;

    public TridotMeleeAttack(PathfinderMob mob, float speedMod, float range, int attackDelay, int attackDuration, int cooldown) {
        super(mob, 0.0f, range, attackDelay, attackDuration, cooldown);
        this.speedModifier = speedMod;
    }

    @Override
    public ResourceLocation getId() {
        return Tridot.ofTridot("melee");
    }

    @Override
    public void tick() {
        double distSq;
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        if (--this.ticksUntilNextPathRecalc <= 0 && (this.distanceToStoredTargetSqr(target) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
            this.storeTargetPosition();
            this.ticksUntilNextPathRecalc += 5;
            this.mob.m_21573_().m_5624_((Entity)target, (double)this.speedModifier);
        }
        if ((distSq = this.mob.m_262793_(target)) > 1024.0) {
            this.ticksUntilNextPathRecalc += 10;
        } else if (distSq > 256.0) {
            this.ticksUntilNextPathRecalc += 5;
        }
    }

    public double distanceToStoredTargetSqr(LivingEntity target) {
        return target.m_20275_(this.lastTargetX, this.lastTargetY, this.lastTargetZ);
    }

    public void storeTargetPosition() {
        LivingEntity target = this.mob.m_5448_();
        this.lastTargetX = target.m_20185_();
        this.lastTargetY = target.m_20186_();
        this.lastTargetZ = target.m_20189_();
    }

    @Override
    public void start(AttackSystemMob systemMob) {
        super.start(systemMob);
        this.mob.m_21561_(true);
        this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)4);
        this.ticksUntilNextPathRecalc = 0;
        this.mob.m_21573_().m_5624_((Entity)this.mob.m_5448_(), (double)this.speedModifier);
        this.storeTargetPosition();
    }

    @Override
    public int preference(Entity entity) {
        return 0;
    }

    @Override
    public void performAttack() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null && target.m_6084_()) {
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.mob.m_7327_((Entity)target);
        }
    }
}

