/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.client;

import com.everydayxp.partyhud.client.PartyHudClientState;
import com.everydayxp.partyhud.client.PartyHudFavoritesClient;
import com.everydayxp.partyhud.client.PartyHudPlayerRegistry;
import com.everydayxp.partyhud.client.hud.HudCommon;
import com.everydayxp.partyhud.client.hud.HudStyleButton;
import com.everydayxp.partyhud.client.hud.SkinCache;
import com.everydayxp.partyhud.config.ClientConfig;
import com.everydayxp.partyhud.network.DelegateLeaderC2SPacket;
import com.everydayxp.partyhud.network.InviteToPartyC2SPacket;
import com.everydayxp.partyhud.network.KickFromPartyC2SPacket;
import com.everydayxp.partyhud.network.MarkFavoriteC2SPacket;
import com.everydayxp.partyhud.network.PartyHudNetwork;
import com.everydayxp.partyhud.network.PlayerEntry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PartyHudPlayersScreen
extends Screen {
    private final List<Row> onlineRows = new ArrayList<Row>();
    private final List<Row> partyRows = new ArrayList<Row>();
    private int colWidth = 150;
    private int gapCols = 40;
    private int startY = 30;
    private int rowHeight = 22;
    private int leftX;
    private int rightX;
    private EditBox searchBox;
    private static final ResourceLocation ICONS_TEX = new ResourceLocation("minecraft", "textures/gui/icons.png");

    public PartyHudPlayersScreen() {
        super((Component)Component.m_237115_((String)"partyhud.screen.title"));
    }

    public void refresh() {
        this.m_7856_();
    }

    protected void m_7856_() {
        HashMap partyNames;
        this.m_169413_();
        this.onlineRows.clear();
        this.partyRows.clear();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        SkinCache.updateAllSkins();
        int maxTracked = (Integer)ClientConfig.MAX_TRACKED_PLAYERS.get();
        UUID localId = mc.f_91074_.m_20148_();
        int center = this.f_96543_ / 2;
        this.colWidth = 150;
        this.gapCols = 40;
        this.startY = 30;
        this.rowHeight = 22;
        this.leftX = center - this.colWidth - this.gapCols / 2;
        this.rightX = center + this.gapCols / 2;
        int styleBtnSize = 16;
        int styleX = this.f_96543_ - styleBtnSize - 8;
        int styleY = 8;
        this.m_142416_((GuiEventListener)new HudStyleButton(styleX, styleY));
        Map<UUID, PlayerEntry> allById = PartyHudPlayerRegistry.getPlayers().stream().filter(e -> !e.uuid().equals(localId)).collect(Collectors.toMap(PlayerEntry::uuid, e -> e, (a, b) -> a));
        List<PlayerEntry> onlinePlayers = allById.values().stream().sorted(Comparator.comparing(PlayerEntry::name, String.CASE_INSENSITIVE_ORDER)).toList();
        LinkedHashSet<UUID> favoriteUuids = new LinkedHashSet<UUID>(PartyHudFavoritesClient.getFavorites());
        favoriteUuids.remove(localId);
        List<PlayerEntry> favoriteOnline = onlinePlayers.stream().filter(e -> favoriteUuids.contains(e.uuid())).toList();
        List<PlayerEntry> nonFavoriteOnline = onlinePlayers.stream().filter(e -> !favoriteUuids.contains(e.uuid())).toList();
        String currentFilter = "";
        if (this.searchBox != null) {
            currentFilter = this.searchBox.m_94155_().toLowerCase(Locale.ROOT);
        }
        int yLeft = this.startY;
        yLeft = this.buildOnlineColumnForList(favoriteOnline, favoriteUuids, currentFilter, this.leftX, yLeft, maxTracked);
        yLeft = this.buildOnlineColumnForList(nonFavoriteOnline, favoriteUuids, currentFilter, this.leftX, yLeft, maxTracked);
        int yRight = this.startY;
        PartyHudClientState.PartyState state = PartyHudClientState.getPartyState();
        ArrayList<UUID> partyUuids = state != null ? new ArrayList<UUID>(state.members()) : new ArrayList();
        HashMap hashMap = partyNames = state != null ? state.names() : new HashMap();
        if (!partyUuids.contains(localId) && state != null) {
            partyUuids.add(0, localId);
        }
        for (UUID id : partyUuids) {
            String name = id.equals(localId) ? mc.f_91074_.m_36316_().getName() : partyNames.getOrDefault(id, allById.containsKey(id) ? allById.get(id).name() : Component.m_237115_((String)"partyhud.player.unknown").getString());
            Row row = new Row();
            row.uuid = id;
            row.name = name;
            row.x = this.rightX;
            row.y = yRight;
            this.partyRows.add(row);
            int btnSize = 16;
            int baseX = this.rightX + this.colWidth + 4;
            int baseY = yRight + 2;
            boolean isSelf = id.equals(localId);
            Button kickBtn = Button.m_253074_((Component)Component.m_237113_((String)"X"), b -> {
                PartyHudNetwork.CHANNEL.sendToServer((Object)new KickFromPartyC2SPacket(id));
                this.m_7856_();
            }).m_252987_(baseX, baseY, btnSize, btnSize).m_253136_();
            kickBtn.f_93623_ = !isSelf;
            this.m_142416_((GuiEventListener)kickBtn);
            int leaderX = baseX + btnSize + 2;
            Button leaderBtn = Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udc51"), b -> {
                PartyHudNetwork.CHANNEL.sendToServer((Object)new DelegateLeaderC2SPacket(id));
                this.m_7856_();
            }).m_252987_(leaderX, baseY, btnSize, btnSize).m_253136_();
            leaderBtn.f_93623_ = !isSelf && PartyHudClientState.isLocalLeader();
            this.m_142416_((GuiEventListener)leaderBtn);
            yRight += this.rowHeight;
        }
        int searchBoxWidth = this.colWidth;
        int searchBoxHeight = 20;
        int searchX = this.leftX;
        int searchY = this.f_96544_ - 40;
        this.searchBox = new EditBox(this.f_96547_, searchX, searchY, searchBoxWidth, searchBoxHeight, (Component)Component.m_237115_((String)"partyhud.search.placeholder"));
        this.searchBox.m_94199_(32);
        this.searchBox.m_94144_(currentFilter);
        this.searchBox.m_94182_(true);
        this.searchBox.m_94194_(true);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94151_(s -> this.m_7856_());
        this.m_142416_((GuiEventListener)this.searchBox);
        this.m_7522_((GuiEventListener)this.searchBox);
        this.searchBox.m_93692_(true);
        int leaveButtonWidth = this.colWidth;
        int leaveButtonHeight = 20;
        int leaveX = this.rightX;
        int leaveY = this.f_96544_ - 40;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"partyhud.button.leave_party"), b -> {
            Minecraft mc3 = Minecraft.m_91087_();
            if (mc3.f_91074_ != null) {
                mc3.f_91074_.f_108617_.m_246623_("partyhud leave");
            }
        }).m_252987_(leaveX, leaveY, leaveButtonWidth, leaveButtonHeight).m_253136_());
    }

    private int buildOnlineColumnForList(List<PlayerEntry> list, Set<UUID> favoriteUuids, String filter, int baseX, int startY, int maxTracked) {
        int y = startY;
        PartyHudClientState.PartyState state = PartyHudClientState.getPartyState();
        int partySize = state != null ? state.members().size() : 0;
        boolean partyFull = partySize >= 6;
        for (PlayerEntry e : list) {
            String nameLower = e.name().toLowerCase(Locale.ROOT);
            if (!filter.isEmpty() && !nameLower.contains(filter)) continue;
            Row row = new Row();
            row.uuid = e.uuid();
            row.name = e.name();
            row.x = baseX;
            row.y = y;
            this.onlineRows.add(row);
            int starSize = 16;
            int starX = baseX + this.colWidth + 4;
            int starY = y + 2;
            boolean isFav = favoriteUuids.contains(e.uuid());
            String starLabel = isFav ? "\u2605" : "\u2606";
            Button starBtn = Button.m_253074_((Component)Component.m_237113_((String)starLabel), b -> {
                boolean newValue = !isFav;
                PartyHudNetwork.CHANNEL.sendToServer((Object)new MarkFavoriteC2SPacket(e.uuid(), newValue));
            }).m_252987_(starX, starY, starSize, starSize).m_253136_();
            this.m_142416_((GuiEventListener)starBtn);
            int partyBtnSize = 16;
            int partyBtnX = starX + starSize + 2;
            Button partyBtn = Button.m_253074_((Component)Component.m_237113_((String)"P"), b -> {
                if (!partyFull) {
                    PartyHudNetwork.CHANNEL.sendToServer((Object)new InviteToPartyC2SPacket(e.uuid()));
                    Minecraft mc2 = Minecraft.m_91087_();
                    if (mc2.f_91074_ != null) {
                        mc2.f_91074_.m_213846_((Component)Component.m_237110_((String)"partyhud.chat.invite_sent", (Object[])new Object[]{e.name()}));
                    }
                }
            }).m_252987_(partyBtnX, starY, partyBtnSize, partyBtnSize).m_253136_();
            boolean bl = partyBtn.f_93623_ = !partyFull;
            if (partyFull) {
                partyBtn.m_93666_((Component)Component.m_237113_((String)"P").m_130940_(ChatFormatting.RED));
            }
            this.m_142416_((GuiEventListener)partyBtn);
            y += this.rowHeight;
        }
        return y;
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(g);
        super.m_88315_(g, mouseX, mouseY, partialTicks);
        int titleY = 15;
        int color = 0xFFFFFF;
        g.m_280137_(this.f_96547_, Component.m_237115_((String)"partyhud.label.online_players").getString(), this.leftX + this.colWidth / 2, titleY, color);
        g.m_280137_(this.f_96547_, Component.m_237115_((String)"partyhud.label.party").getString(), this.rightX + this.colWidth / 2, titleY, color);
        for (Row row : this.onlineRows) {
            this.drawPlayerRow(g, row);
        }
        for (Row row : this.partyRows) {
            this.drawPlayerRow(g, row);
        }
    }

    private void drawPlayerRow(GuiGraphics g, Row row) {
        Minecraft mc = Minecraft.m_91087_();
        ClientPacketListener connection = mc.m_91403_();
        int x = row.x;
        int y = row.y;
        int width = this.colWidth;
        int height = 20;
        g.m_280509_(x, y, x + width, y + height, Integer.MIN_VALUE);
        PlayerInfo info = connection != null ? connection.m_104949_(row.uuid) : null;
        int headSize = 16;
        int headX = x + 2;
        int headY = y + 2;
        ResourceLocation skin = SkinCache.getSkin(row.uuid);
        if (skin != null) {
            HudCommon.renderHead(g, skin, headX, headY, headSize);
        } else {
            HudCommon.fillRect(g, headX, headY, headSize, headSize, -12303292);
        }
        String nameToDraw = row.name;
        int nameX = headX + headSize + 4;
        int nameY = y + 6;
        g.m_280056_(mc.f_91062_, nameToDraw, nameX, nameY, 0xFFFFFF, false);
        if (info != null) {
            int ping = info.m_105330_();
            int bars = ping < 0 ? 0 : (ping < 150 ? 5 : (ping < 300 ? 4 : (ping < 600 ? 3 : (ping < 1000 ? 2 : 1))));
            int pingX = x + width - 2 - 10;
            int pingY = y + 2;
            int u = 0 + bars * 10;
            int v = 176;
            g.m_280218_(ICONS_TEX, pingX, pingY, u, v, 10, 8);
        } else {
            g.m_280056_(mc.f_91062_, "(offline)", nameX + mc.f_91062_.m_92895_(nameToDraw), nameY, 0x888888, false);
        }
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchBox != null && this.searchBox.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    private static class Row {
        UUID uuid;
        String name;
        int x;
        int y;

        private Row() {
        }
    }
}

