/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.client.hud;

import com.everydayxp.partyhud.client.PartyHudHealthRegistry;
import com.everydayxp.partyhud.client.hud.HudCommon;
import com.everydayxp.partyhud.client.hud.SkinCache;
import com.everydayxp.partyhud.config.ClientConfig;
import com.everydayxp.partyhud.config.HealthTextMode;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class CompactHudOverlay {
    private static final ResourceLocation COMPACT_BAR = new ResourceLocation("partyhud", "textures/gui/compact_bars.png");
    private static final int TEX_W = 48;
    private static final int TEX_H = 128;
    private static final int BAR_W = 48;
    private static final int BAR_H = 16;

    private static int getBarVBase() {
        return 0;
    }

    private static int getLifeBarV() {
        return 16;
    }

    private static int getTrailBarV() {
        return 32;
    }

    private static int getAbsorptionBarV() {
        return 48;
    }

    private static int getPoisonBarV() {
        return 64;
    }

    private static int getWitherBarV() {
        return 80;
    }

    private static int getIceBarV() {
        return 96;
    }

    private static int getEffectBarV(PartyHudHealthRegistry.PlayerHudData data) {
        boolean absorb;
        boolean freezing = data != null && data.freezing;
        boolean wither = data != null && data.wither;
        boolean poison = data != null && data.poison;
        boolean regen = data != null && data.regen;
        boolean bl = absorb = data != null && data.absorption > 0.0f;
        if (freezing) {
            return CompactHudOverlay.getIceBarV();
        }
        if (wither) {
            return CompactHudOverlay.getWitherBarV();
        }
        if (poison) {
            return CompactHudOverlay.getPoisonBarV();
        }
        if (regen || absorb) {
            return CompactHudOverlay.getAbsorptionBarV();
        }
        return CompactHudOverlay.getLifeBarV();
    }

    public static void renderFar(GuiGraphics g, UUID uuid, String name, PartyHudHealthRegistry.PlayerHudData data, int x, int y, int width, int height, float ratio) {
        int filled;
        float trailRatio;
        int trailFilled;
        if (data == null || data.maxHp <= 0.0f) {
            return;
        }
        float barScale = (float)((Integer)ClientConfig.BAR_SCALE.get()).intValue() / 100.0f;
        g.m_280168_().m_85836_();
        g.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        g.m_280168_().m_85841_(barScale, barScale, 1.0f);
        int alpha = (Integer)ClientConfig.HUD_ALPHA.get() & 0xFF;
        int textColor = alpha << 24 | 0xFFFFFF;
        int faceSize = (int)((float)height * 1.25f);
        int faceX = -2;
        int faceY = -2;
        int barWidth = 48;
        int barHeight = 16;
        int barX = faceX + faceSize + 6;
        int faceBottom = faceY + faceSize;
        int barY = faceBottom - barHeight - 1;
        ResourceLocation skin = SkinCache.getSkin(uuid);
        if (skin != null) {
            HudCommon.renderHead(g, skin, faceX, faceY, faceSize);
        } else {
            HudCommon.fillRect(g, faceX, faceY, faceSize, faceSize, -12303292);
        }
        int bgColor = alpha << 24 | 0x202020;
        int bgX1 = barX - 1;
        int bgY1 = barY - 1;
        int bgX2 = barX + barWidth + 1;
        int bgY2 = barY + barHeight + 1;
        g.m_280509_(bgX1, bgY1, bgX2, bgY2, bgColor);
        int barInnerX = barX;
        int barInnerY = barY;
        int baseV = CompactHudOverlay.getBarVBase();
        g.m_280411_(COMPACT_BAR, barInnerX, barInnerY, 48, 16, 0.0f, (float)baseV, 48, 16, 48, 128);
        if (data.trailHp > 0.0f && data.maxHp > 0.0f && (trailFilled = (int)(48.0f * (trailRatio = data.trailHp / data.maxHp))) > 0) {
            int trailV = CompactHudOverlay.getTrailBarV();
            g.m_280411_(COMPACT_BAR, barInnerX, barInnerY, trailFilled, 16, 0.0f, (float)trailV, trailFilled, 16, 48, 128);
        }
        if ((filled = (int)(48.0f * ratio)) > 0) {
            int effectV = CompactHudOverlay.getEffectBarV(data);
            g.m_280411_(COMPACT_BAR, barInnerX, barInnerY, filled, 16, 0.0f, (float)effectV, filled, 16, 48, 128);
        }
        Font font = Minecraft.m_91087_().f_91062_;
        float textScale = 0.75f;
        HealthTextMode mode = (HealthTextMode)((Object)ClientConfig.HEALTH_TEXT_MODE.get());
        String hpTextToDraw = switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case HealthTextMode.VALUE -> {
                int hpInt = data.hp > 0.0f ? (int)Math.ceil(data.hp) : 0;
                int maxInt = (int)Math.ceil(data.maxHp);
                String t = hpInt + "/" + maxInt;
                if (data.absorption > 0.0f) {
                    int extraHealth = Math.round(data.absorption);
                    t = t + " +" + extraHealth;
                }
                yield t;
            }
            case HealthTextMode.PERCENT -> {
                int pct = data.maxHp > 0.0f ? Math.round(data.hp / data.maxHp * 100.0f) : 0;
                yield pct + "%";
            }
            case HealthTextMode.NONE -> "";
        };
        g.m_280168_().m_85836_();
        g.m_280168_().m_85841_(textScale, textScale, 1.0f);
        int scaledBarX = (int)((float)barInnerX / textScale);
        int scaledBarWidth = (int)((float)barWidth / textScale);
        int scaledBarY = (int)((float)barInnerY / textScale);
        int centerY = scaledBarY + (int)((float)(barHeight - 8) / 2.0f / textScale) + 2;
        if (!hpTextToDraw.isEmpty()) {
            int textWidth = font.m_92895_(hpTextToDraw);
            int textX = scaledBarX + (scaledBarWidth - textWidth) / 2;
            g.m_280056_(font, hpTextToDraw, textX, centerY, textColor, false);
        }
        if (((Boolean)ClientConfig.SHOW_NAMES.get()).booleanValue()) {
            int nameX = scaledBarX + 2;
            int nameY = scaledBarY - 10;
            g.m_280056_(font, name, nameX, nameY, textColor, true);
        }
        g.m_280168_().m_85849_();
        g.m_280168_().m_85849_();
    }
}

