/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.client.hud;

import com.everydayxp.partyhud.client.PartyHudHealthRegistry;
import com.everydayxp.partyhud.client.hud.HudCommon;
import com.everydayxp.partyhud.client.hud.SkinCache;
import com.everydayxp.partyhud.config.ClientConfig;
import com.everydayxp.partyhud.config.HealthTextMode;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class ModernHudOverlay {
    private static final ResourceLocation MODERN_BAR = new ResourceLocation("partyhud", "textures/gui/modern_bars.png");
    private static final int TEX_W = 47;
    private static final int TEX_H = 128;
    private static final int BAR_W = 47;
    private static final int BAR_H = 6;

    private static int getBarVBase() {
        return 0;
    }

    private static int getLifeBarV() {
        return 6;
    }

    private static int getTrailBarV() {
        return 12;
    }

    private static int getAbsorptionBarV() {
        return 18;
    }

    private static int getPoisonBarV() {
        return 24;
    }

    private static int getWitherBarV() {
        return 30;
    }

    private static int getIceBarV() {
        return 36;
    }

    private static int getEffectBarV(PartyHudHealthRegistry.PlayerHudData data) {
        boolean absorb;
        boolean freezing = data != null && data.freezing;
        boolean wither = data != null && data.wither;
        boolean poison = data != null && data.poison;
        boolean regen = data != null && data.regen;
        boolean bl = absorb = data != null && data.absorption > 0.0f;
        if (freezing) {
            return ModernHudOverlay.getIceBarV();
        }
        if (wither) {
            return ModernHudOverlay.getWitherBarV();
        }
        if (poison) {
            return ModernHudOverlay.getPoisonBarV();
        }
        if (regen || absorb) {
            return ModernHudOverlay.getAbsorptionBarV();
        }
        return ModernHudOverlay.getLifeBarV();
    }

    public static void renderFar(GuiGraphics g, UUID uuid, String name, PartyHudHealthRegistry.PlayerHudData data, int x, int y, int width, int height, float ratio) {
        int filled;
        float trailRatio;
        int trailFilled;
        if (data == null || data.maxHp <= 0.0f) {
            return;
        }
        float barScale = (float)((Integer)ClientConfig.BAR_SCALE.get()).intValue() / 100.0f;
        g.m_280168_().m_85836_();
        g.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        g.m_280168_().m_85841_(barScale, barScale, 1.0f);
        int alpha = (Integer)ClientConfig.HUD_ALPHA.get() & 0xFF;
        int textColor = alpha << 24 | 0xFFFFFF;
        int faceSize = (int)((float)height * 1.25f);
        int faceX = -2;
        int faceY = -2;
        int barWidth = 47;
        int barHeight = 6;
        int barX = faceX + faceSize + 6;
        int faceCenterY = faceY + faceSize / 2;
        int lineSpacing = 8;
        int barY = faceCenterY - barHeight / 2;
        int hpTextY = faceY - 0;
        int nameY = barY + barHeight + 2;
        ResourceLocation skin = SkinCache.getSkin(uuid);
        if (skin != null) {
            HudCommon.renderHead(g, skin, faceX, faceY, faceSize);
        } else {
            HudCommon.fillRect(g, faceX, faceY, faceSize, faceSize, -12303292);
        }
        int bgColor = alpha << 24 | 0x202020;
        int bgX1 = barX - 1;
        int bgY1 = barY - 1;
        int bgX2 = barX + barWidth + 1;
        int bgY2 = barY + barHeight + 1;
        g.m_280509_(bgX1, bgY1, bgX2, bgY2, bgColor);
        int barInnerX = barX;
        int barInnerY = barY;
        int baseV = ModernHudOverlay.getBarVBase();
        g.m_280411_(MODERN_BAR, barInnerX, barInnerY, 47, 6, 0.0f, (float)baseV, 47, 6, 47, 128);
        if (data.trailHp > 0.0f && data.maxHp > 0.0f && (trailFilled = (int)(47.0f * (trailRatio = data.trailHp / data.maxHp))) > 0) {
            int trailV = ModernHudOverlay.getTrailBarV();
            g.m_280411_(MODERN_BAR, barInnerX, barInnerY, trailFilled, 6, 0.0f, (float)trailV, trailFilled, 6, 47, 128);
        }
        if ((filled = (int)(47.0f * ratio)) > 0) {
            int effectV = ModernHudOverlay.getEffectBarV(data);
            g.m_280411_(MODERN_BAR, barInnerX, barInnerY, filled, 6, 0.0f, (float)effectV, filled, 6, 47, 128);
        }
        Font font = Minecraft.m_91087_().f_91062_;
        float textScale = 0.75f;
        HealthTextMode mode = (HealthTextMode)((Object)ClientConfig.HEALTH_TEXT_MODE.get());
        String hpTextToDraw = switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case HealthTextMode.VALUE -> {
                int hpInt = data.hp > 0.0f ? (int)Math.ceil(data.hp) : 0;
                int maxInt = (int)Math.ceil(data.maxHp);
                String t = hpInt + "/" + maxInt;
                if (data.absorption > 0.0f) {
                    int extraHealth = Math.round(data.absorption);
                    t = t + " +" + extraHealth;
                }
                yield t;
            }
            case HealthTextMode.PERCENT -> {
                int pct = data.maxHp > 0.0f ? Math.round(data.hp / data.maxHp * 100.0f) : 0;
                yield pct + "%";
            }
            case HealthTextMode.NONE -> "";
        };
        g.m_280168_().m_85836_();
        g.m_280168_().m_85841_(textScale, textScale, 1.0f);
        int scaledBarX = (int)((float)barInnerX / textScale);
        int scaledBarWidth = (int)((float)barWidth / textScale);
        int scaledHpY = (int)((float)hpTextY / textScale);
        int scaledNameY = (int)((float)nameY / textScale);
        if (!hpTextToDraw.isEmpty()) {
            int textWidth = font.m_92895_(hpTextToDraw);
            int textX = scaledBarX + (scaledBarWidth - textWidth) / 2;
            g.m_280056_(font, hpTextToDraw, textX, scaledHpY, textColor, false);
        }
        if (((Boolean)ClientConfig.SHOW_NAMES.get()).booleanValue()) {
            int nameX = scaledBarX + 2;
            g.m_280056_(font, name, nameX, scaledNameY, textColor, true);
        }
        g.m_280168_().m_85849_();
        g.m_280168_().m_85849_();
    }
}

