/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.client.hud;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;

public class SkinCache {
    private static final Map<UUID, ResourceLocation> SKINS = new ConcurrentHashMap<UUID, ResourceLocation>();
    private static final ResourceLocation[] DEFAULT_SKINS = new ResourceLocation[]{new ResourceLocation("minecraft", "textures/entity/player/steve.png"), new ResourceLocation("minecraft", "textures/entity/player/alex.png"), new ResourceLocation("minecraft", "textures/entity/player/ari.png"), new ResourceLocation("minecraft", "textures/entity/player/efe.png"), new ResourceLocation("minecraft", "textures/entity/player/guy.png"), new ResourceLocation("minecraft", "textures/entity/player/kai.png"), new ResourceLocation("minecraft", "textures/entity/player/makena.png"), new ResourceLocation("minecraft", "textures/entity/player/noor.png"), new ResourceLocation("minecraft", "textures/entity/player/sunny.png"), new ResourceLocation("minecraft", "textures/entity/player/zuri.png")};

    public static ResourceLocation getSkin(UUID uuid) {
        return SKINS.get(uuid);
    }

    public static void assignDefaultSkin(UUID uuid) {
        int index = (uuid.hashCode() & Integer.MAX_VALUE) % DEFAULT_SKINS.length;
        SKINS.put(uuid, DEFAULT_SKINS[index]);
    }

    public static void updateAllSkins() {
        Minecraft mc = Minecraft.m_91087_();
        ClientPacketListener connection = mc.m_91403_();
        if (connection == null) {
            return;
        }
        for (PlayerInfo info : connection.m_105142_()) {
            UUID uuid = info.m_105312_().getId();
            SKINS.put(uuid, info.m_105337_());
        }
    }

    public static void preloadOfflineSkin(UUID uuid) {
        Minecraft mc = Minecraft.m_91087_();
        SkinManager skinManager = mc.m_91109_();
        CompletableFuture.supplyAsync(() -> {
            try {
                GameProfile profile = new GameProfile(uuid, null);
                Map textures = skinManager.m_118815_(profile);
                MinecraftProfileTexture skinTex = (MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN);
                return skinTex != null ? skinManager.m_118825_(skinTex, MinecraftProfileTexture.Type.SKIN) : null;
            }
            catch (Exception ignored) {
                return null;
            }
        }).thenAccept(skin -> {
            if (skin != null) {
                SKINS.put(uuid, (ResourceLocation)skin);
            }
        });
    }

    public static void clear() {
        SKINS.clear();
    }

    public static void invalidate(UUID uuid) {
        SKINS.remove(uuid);
    }
}

