/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.network;

import com.everydayxp.partyhud.server.PartyHudServerData;
import com.everydayxp.partyhud.server.PartySavedData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class DelegateLeaderC2SPacket {
    public final UUID newLeaderId;

    public DelegateLeaderC2SPacket(UUID newLeaderId) {
        this.newLeaderId = newLeaderId;
    }

    public static void encode(DelegateLeaderC2SPacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.newLeaderId);
    }

    public static DelegateLeaderC2SPacket decode(FriendlyByteBuf buf) {
        return new DelegateLeaderC2SPacket(buf.m_130259_());
    }

    public static void handle(DelegateLeaderC2SPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                return;
            }
            UUID currentLeaderId = PartyHudServerData.getLeader(sender.m_20148_(), sender);
            if (!sender.m_20148_().equals(currentLeaderId)) {
                sender.m_213846_((Component)Component.m_237115_((String)"partyhud.chat.not_leader"));
                return;
            }
            PartySavedData data = PartyHudServerData.getData(sender.m_284548_());
            PartySavedData.PartyInfo party = data.getPartyByMember(sender.m_20148_());
            if (party == null || !party.members.contains(msg.newLeaderId)) {
                sender.m_213846_((Component)Component.m_237115_((String)"partyhud.chat.invalid_delegate"));
                return;
            }
            party.leaderId = msg.newLeaderId;
            data.m_77762_();
            PartyHudServerData.syncPartyToMembers(party, sender.m_20194_());
            ServerPlayer newLeaderPlayer = sender.m_20194_().m_6846_().m_11259_(msg.newLeaderId);
            MutableComponent nameComponent = newLeaderPlayer != null ? Component.m_237113_((String)newLeaderPlayer.m_7755_().getString()) : Component.m_237113_((String)"Unknown");
            sender.m_213846_((Component)Component.m_237110_((String)"partyhud.chat.delegated_leader", (Object[])new Object[]{nameComponent}));
        });
        ctx.setPacketHandled(true);
    }
}

