/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.network;

import com.everydayxp.partyhud.server.PartyHudServerData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class InviteToPartyC2SPacket {
    private final UUID targetId;

    public InviteToPartyC2SPacket(UUID targetId) {
        this.targetId = targetId;
    }

    public static void encode(InviteToPartyC2SPacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.targetId);
    }

    public static InviteToPartyC2SPacket decode(FriendlyByteBuf buf) {
        return new InviteToPartyC2SPacket(buf.m_130259_());
    }

    public static void handle(InviteToPartyC2SPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer inviter = ctx.getSender();
            if (inviter == null) {
                return;
            }
            UUID inviterId = inviter.m_20148_();
            UUID inviterLeaderId = PartyHudServerData.getLeader(inviterId, inviter);
            if (inviterLeaderId != null && !inviterLeaderId.equals(inviterId)) {
                inviter.m_213846_((Component)Component.m_237115_((String)"partyhud.chat.only_leader_can_invite"));
                return;
            }
            ServerPlayer target = inviter.f_8924_.m_6846_().m_11259_(msg.targetId);
            if (target == null) {
                inviter.m_213846_((Component)Component.m_237115_((String)"partyhud.chat.invite_failed_offline"));
                return;
            }
            UUID targetLeaderId = PartyHudServerData.getLeader(target.m_20148_(), inviter);
            if (targetLeaderId != null && !targetLeaderId.equals(inviterId)) {
                inviter.m_213846_((Component)Component.m_237110_((String)"partyhud.chat.target_already_in_party", (Object[])new Object[]{target.m_7755_()}));
                return;
            }
            PartyHudServerData.addInvite(inviterId, target.m_20148_());
            MutableComponent base = Component.m_237110_((String)"partyhud.chat.invite", (Object[])new Object[]{inviter.m_7755_()});
            String inviterUuidStr = inviterId.toString();
            MutableComponent accept = Component.m_237115_((String)"partyhud.chat.accept").m_6270_(Style.f_131099_.m_131162_(Boolean.valueOf(true)).m_178520_(65280).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/partyhud accept " + inviterUuidStr)));
            MutableComponent decline = Component.m_237115_((String)"partyhud.chat.decline").m_6270_(Style.f_131099_.m_131162_(Boolean.valueOf(true)).m_178520_(0xFF0000).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/partyhud decline " + inviterUuidStr)));
            MutableComponent space = Component.m_237113_((String)" ");
            MutableComponent full = Component.m_237113_((String)"").m_7220_((Component)base).m_7220_((Component)space).m_7220_((Component)accept).m_7220_((Component)space).m_7220_((Component)decline);
            target.m_213846_((Component)full);
        });
        ctx.setPacketHandled(true);
    }
}

