/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.network;

import com.everydayxp.partyhud.network.DelegateLeaderC2SPacket;
import com.everydayxp.partyhud.network.InviteToPartyC2SPacket;
import com.everydayxp.partyhud.network.KickFromPartyC2SPacket;
import com.everydayxp.partyhud.network.MarkFavoriteC2SPacket;
import com.everydayxp.partyhud.network.PartyMemberPosSyncS2CPacket;
import com.everydayxp.partyhud.network.PlayerEntry;
import com.everydayxp.partyhud.network.PlayerHealthSyncS2CPacket;
import com.everydayxp.partyhud.network.PlayersListS2CPacket;
import com.everydayxp.partyhud.network.SyncFavoritesS2CPacket;
import com.everydayxp.partyhud.network.SyncPartyStateS2CPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PartyHudNetwork {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("partyhud", "main"), () -> "1", "1"::equals, "1"::equals);

    public static void register() {
        int id = 0;
        CHANNEL.registerMessage(id++, PlayersListS2CPacket.class, PlayersListS2CPacket::encode, PlayersListS2CPacket::decode, PlayersListS2CPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(id++, RequestPlayersListC2SPacket.class, RequestPlayersListC2SPacket::encode, RequestPlayersListC2SPacket::decode, RequestPlayersListC2SPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(id++, SyncPinnedC2SPacket.class, SyncPinnedC2SPacket::encode, SyncPinnedC2SPacket::decode, SyncPinnedC2SPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(id++, PlayerHealthSyncS2CPacket.class, PlayerHealthSyncS2CPacket::encode, PlayerHealthSyncS2CPacket::decode, PlayerHealthSyncS2CPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(id++, SyncFavoritesS2CPacket.class, SyncFavoritesS2CPacket::encode, SyncFavoritesS2CPacket::decode, SyncFavoritesS2CPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(id++, InviteToPartyC2SPacket.class, InviteToPartyC2SPacket::encode, InviteToPartyC2SPacket::decode, InviteToPartyC2SPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(id++, KickFromPartyC2SPacket.class, KickFromPartyC2SPacket::encode, KickFromPartyC2SPacket::decode, KickFromPartyC2SPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(id++, PartyMemberPosSyncS2CPacket.class, PartyMemberPosSyncS2CPacket::encode, PartyMemberPosSyncS2CPacket::decode, PartyMemberPosSyncS2CPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(id++, SyncPartyStateS2CPacket.class, SyncPartyStateS2CPacket::encode, SyncPartyStateS2CPacket::decode, SyncPartyStateS2CPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(id++, MarkFavoriteC2SPacket.class, MarkFavoriteC2SPacket::encode, MarkFavoriteC2SPacket::decode, MarkFavoriteC2SPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(id++, DelegateLeaderC2SPacket.class, DelegateLeaderC2SPacket::encode, DelegateLeaderC2SPacket::decode, DelegateLeaderC2SPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public static void sendPlayersList(ServerPlayer target, List<ServerPlayer> players) {
        ArrayList<PlayerEntry> list = new ArrayList<PlayerEntry>();
        for (ServerPlayer p : players) {
            list.add(new PlayerEntry(p.m_20148_(), p.m_36316_().getName()));
        }
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> target), (Object)new PlayersListS2CPacket(list));
    }

    public static class RequestPlayersListC2SPacket {
        public static void encode(RequestPlayersListC2SPacket msg, FriendlyByteBuf buf) {
        }

        public static RequestPlayersListC2SPacket decode(FriendlyByteBuf buf) {
            return new RequestPlayersListC2SPacket();
        }

        public static void handle(RequestPlayersListC2SPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            ctx.enqueueWork(() -> {
                ServerPlayer sender = ctx.getSender();
                if (sender == null) {
                    return;
                }
                List players = sender.f_8924_.m_6846_().m_11314_();
                PartyHudNetwork.sendPlayersList(sender, players);
            });
            ctx.setPacketHandled(true);
        }
    }

    public static class SyncPinnedC2SPacket {
        public final List<UUID> pinned;

        public SyncPinnedC2SPacket(List<UUID> pinned) {
            this.pinned = pinned;
        }

        public static void encode(SyncPinnedC2SPacket msg, FriendlyByteBuf buf) {
            buf.m_130130_(msg.pinned.size());
            for (UUID id : msg.pinned) {
                buf.m_130077_(id);
            }
        }

        public static SyncPinnedC2SPacket decode(FriendlyByteBuf buf) {
            int size = buf.m_130242_();
            ArrayList<UUID> list = new ArrayList<UUID>();
            for (int i = 0; i < size; ++i) {
                list.add(buf.m_130259_());
            }
            return new SyncPinnedC2SPacket(list);
        }

        public static void handle(SyncPinnedC2SPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            ctx.enqueueWork(() -> {});
            ctx.setPacketHandled(true);
        }
    }
}

