/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.network;

import com.everydayxp.partyhud.client.PartyHudPositionRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class PartyMemberPosSyncS2CPacket {
    public final List<Entry> entries;

    public PartyMemberPosSyncS2CPacket(List<Entry> entries) {
        this.entries = entries;
    }

    public static void encode(PartyMemberPosSyncS2CPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.entries.size());
        for (Entry e : msg.entries) {
            buf.m_130077_(e.uuid);
            buf.m_130085_(e.dimension);
            buf.writeDouble(e.x);
            buf.writeDouble(e.y);
            buf.writeDouble(e.z);
        }
    }

    public static PartyMemberPosSyncS2CPacket decode(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ArrayList<Entry> list = new ArrayList<Entry>(size);
        for (int i = 0; i < size; ++i) {
            UUID id = buf.m_130259_();
            ResourceLocation dim = buf.m_130281_();
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            list.add(new Entry(id, dim, x, y, z));
        }
        return new PartyMemberPosSyncS2CPacket(list);
    }

    public static void handle(PartyMemberPosSyncS2CPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            if (!FMLEnvironment.dist.isClient()) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                return;
            }
            long now = mc.f_91073_.m_46467_();
            for (Entry e : msg.entries) {
                PartyHudPositionRegistry.set(e.uuid, new PartyHudPositionRegistry.PosData(e.dimension, e.x, e.y, e.z, now));
            }
        });
        ctx.setPacketHandled(true);
    }

    public static class Entry {
        public final UUID uuid;
        public final ResourceLocation dimension;
        public final double x;
        public final double y;
        public final double z;

        public Entry(UUID uuid, ResourceLocation dimension, double x, double y, double z) {
            this.uuid = uuid;
            this.dimension = dimension;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

