/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.server;

import com.everydayxp.partyhud.network.PartyHudNetwork;
import com.everydayxp.partyhud.network.SyncPartyStateS2CPacket;
import com.everydayxp.partyhud.server.PartySavedData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;

public class PartyHudServerData {
    private static final Map<UUID, UUID> PENDING_INVITES = new HashMap<UUID, UUID>();

    public static PartySavedData getData(ServerLevel level) {
        return PartySavedData.get(level.m_7654_().m_129783_());
    }

    public static void addInvite(UUID inviterId, UUID invitedId) {
        PENDING_INVITES.put(invitedId, inviterId);
    }

    public static UUID consumeInvite(UUID invitedId, UUID expectedInviterId) {
        UUID stored = PENDING_INVITES.get(invitedId);
        if (stored != null && stored.equals(expectedInviterId)) {
            PENDING_INVITES.remove(invitedId);
            return stored;
        }
        return null;
    }

    public static void cancelInvitesFrom(UUID inviterId) {
        PENDING_INVITES.entrySet().removeIf(e -> ((UUID)e.getValue()).equals(inviterId));
    }

    public static void cancelInvitesTo(UUID invitedId) {
        PENDING_INVITES.remove(invitedId);
    }

    public static UUID getLeader(UUID playerId, ServerPlayer anyPlayerOnServer) {
        ServerLevel level = anyPlayerOnServer.m_284548_();
        PartySavedData data = PartyHudServerData.getData(level);
        PartySavedData.PartyInfo party = data.getPartyByMember(playerId);
        return party != null ? party.leaderId : null;
    }

    public static Set<UUID> getPartyOf(ServerPlayer player) {
        PartySavedData data = PartyHudServerData.getData(player.m_284548_());
        PartySavedData.PartyInfo party = data.getPartyByMember(player.m_20148_());
        if (party == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(party.members);
    }

    public static void createOrAddToParty(ServerPlayer leader, ServerPlayer newMember) {
        PartySavedData data = PartyHudServerData.getData(leader.m_284548_());
        PartySavedData.PartyInfo leaderParty = data.getPartyByMember(leader.m_20148_());
        if (leaderParty == null) {
            leaderParty = data.createParty(leader);
        } else if (!leader.m_20148_().equals(leaderParty.leaderId)) {
            leader.m_213846_((Component)Component.m_237115_((String)"partyhud.chat.not_leader"));
            return;
        }
        UUID oldPartyId = data.getPartyIdForMember(newMember.m_20148_());
        if (oldPartyId != null && !oldPartyId.equals(leaderParty.partyId)) {
            leader.m_213846_((Component)Component.m_237115_((String)"partyhud.chat.target_in_party"));
            return;
        }
        if (leaderParty.members.size() >= 6) {
            leader.m_213846_((Component)Component.m_237115_((String)"partyhud.chat.party_full").m_130940_(ChatFormatting.RED));
        }
        data.addMember(leaderParty, newMember);
        PartyHudServerData.syncPartyToMembers(leaderParty, leader.m_20194_());
    }

    public static void removeFromParty(ServerPlayer member) {
        PartySavedData data = PartyHudServerData.getData(member.m_284548_());
        PartySavedData.PartyInfo party = data.getPartyByMember(member.m_20148_());
        if (party != null) {
            data.removeMember(member.m_20148_());
            PartyHudServerData.syncPartyToMembers(party, member.m_20194_());
        }
    }

    public static void syncPartyToMembers(PartySavedData.PartyInfo info, MinecraftServer server) {
        if (info == null || info.members.isEmpty()) {
            return;
        }
        ArrayList<UUID> list = new ArrayList<UUID>(info.members);
        HashMap<UUID, String> names = new HashMap<UUID, String>(info.names);
        for (UUID memberId : info.members) {
            ServerPlayer sp = server.m_6846_().m_11259_(memberId);
            if (sp == null) continue;
            PartyHudNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new SyncPartyStateS2CPacket(info.partyId, info.leaderId, list, names));
        }
    }
}

