/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.partyhud.server;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;

public class PartySavedData
extends SavedData {
    private static final String NAME = "partyhud_parties";
    private final Map<UUID, PartyInfo> parties = new HashMap<UUID, PartyInfo>();
    private final Map<UUID, UUID> partyByMember = new HashMap<UUID, UUID>();

    public static PartySavedData get(ServerLevel level) {
        return (PartySavedData)level.m_8895_().m_164861_(PartySavedData::load, PartySavedData::new, NAME);
    }

    public static PartySavedData load(CompoundTag tag) {
        PartySavedData data = new PartySavedData();
        ListTag partiesTag = tag.m_128437_("Parties", 10);
        for (int i = 0; i < partiesTag.size(); ++i) {
            CompoundTag pTag = partiesTag.m_128728_(i);
            try {
                UUID partyId = UUID.fromString(pTag.m_128461_("PartyId"));
                UUID leaderId = UUID.fromString(pTag.m_128461_("Leader"));
                PartyInfo info = new PartyInfo();
                info.partyId = partyId;
                info.leaderId = leaderId;
                ListTag membersTag = pTag.m_128437_("Members", 8);
                for (int j = 0; j < membersTag.size(); ++j) {
                    String s = membersTag.m_128778_(j);
                    try {
                        UUID memberId = UUID.fromString(s);
                        info.members.add(memberId);
                        data.partyByMember.put(memberId, partyId);
                        continue;
                    }
                    catch (IllegalArgumentException memberId) {
                        // empty catch block
                    }
                }
                if (pTag.m_128425_("Names", 9)) {
                    ListTag namesTag = pTag.m_128437_("Names", 10);
                    for (int j = 0; j < namesTag.size(); ++j) {
                        CompoundTag nTag = namesTag.m_128728_(j);
                        try {
                            UUID memberId = UUID.fromString(nTag.m_128461_("Id"));
                            String name = nTag.m_128461_("Name");
                            info.names.put(memberId, name);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                data.parties.put(partyId, info);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag partiesTag = new ListTag();
        for (PartyInfo info : this.parties.values()) {
            CompoundTag pTag = new CompoundTag();
            pTag.m_128359_("PartyId", info.partyId.toString());
            pTag.m_128359_("Leader", info.leaderId.toString());
            ListTag membersTag = new ListTag();
            for (UUID member : info.members) {
                membersTag.add((Object)StringTag.m_129297_((String)member.toString()));
            }
            pTag.m_128365_("Members", (Tag)membersTag);
            ListTag namesTag = new ListTag();
            for (Map.Entry<UUID, String> e : info.names.entrySet()) {
                CompoundTag nTag = new CompoundTag();
                nTag.m_128359_("Id", e.getKey().toString());
                nTag.m_128359_("Name", e.getValue());
                namesTag.add((Object)nTag);
            }
            pTag.m_128365_("Names", (Tag)namesTag);
            partiesTag.add((Object)pTag);
        }
        tag.m_128365_("Parties", (Tag)partiesTag);
        return tag;
    }

    public UUID getPartyIdForMember(UUID memberId) {
        return this.partyByMember.get(memberId);
    }

    public PartyInfo getParty(UUID partyId) {
        return this.parties.get(partyId);
    }

    public PartyInfo getPartyByMember(UUID memberId) {
        UUID partyId = this.partyByMember.get(memberId);
        if (partyId == null) {
            return null;
        }
        return this.parties.get(partyId);
    }

    public PartyInfo createParty(ServerPlayer leader) {
        PartyInfo info = new PartyInfo();
        info.partyId = UUID.randomUUID();
        info.leaderId = leader.m_20148_();
        info.members.add(leader.m_20148_());
        info.names.put(leader.m_20148_(), leader.m_36316_().getName());
        this.parties.put(info.partyId, info);
        this.partyByMember.put(leader.m_20148_(), info.partyId);
        this.m_77762_();
        return info;
    }

    public PartyInfo createParty(UUID leaderId) {
        PartyInfo info = new PartyInfo();
        info.partyId = UUID.randomUUID();
        info.leaderId = leaderId;
        info.members.add(leaderId);
        this.parties.put(info.partyId, info);
        this.partyByMember.put(leaderId, info.partyId);
        this.m_77762_();
        return info;
    }

    public void addMember(PartyInfo party, ServerPlayer player) {
        PartyInfo old;
        UUID memberId = player.m_20148_();
        UUID oldPartyId = this.partyByMember.get(memberId);
        if (oldPartyId != null && !oldPartyId.equals(party.partyId) && (old = this.parties.get(oldPartyId)) != null) {
            old.members.remove(memberId);
            old.names.remove(memberId);
            if (old.members.isEmpty()) {
                this.parties.remove(oldPartyId);
            }
        }
        party.members.add(memberId);
        party.names.put(memberId, player.m_36316_().getName());
        this.partyByMember.put(memberId, party.partyId);
        this.m_77762_();
    }

    public void addMember(PartyInfo party, UUID memberId, String name) {
        PartyInfo old;
        UUID oldPartyId = this.partyByMember.get(memberId);
        if (oldPartyId != null && !oldPartyId.equals(party.partyId) && (old = this.parties.get(oldPartyId)) != null) {
            old.members.remove(memberId);
            old.names.remove(memberId);
            if (old.members.isEmpty()) {
                this.parties.remove(oldPartyId);
            }
        }
        party.members.add(memberId);
        if (name != null) {
            party.names.put(memberId, name);
        }
        this.partyByMember.put(memberId, party.partyId);
        this.m_77762_();
    }

    public void removeMember(UUID memberId) {
        UUID partyId = this.partyByMember.remove(memberId);
        if (partyId == null) {
            return;
        }
        PartyInfo party = this.parties.get(partyId);
        if (party == null) {
            return;
        }
        party.members.remove(memberId);
        party.names.remove(memberId);
        if (party.members.isEmpty()) {
            this.parties.remove(partyId);
        }
        this.m_77762_();
    }

    public static class PartyInfo {
        public UUID partyId;
        public UUID leaderId;
        public final Set<UUID> members = new LinkedHashSet<UUID>();
        public final Map<UUID, String> names = new HashMap<UUID, String>();
    }
}

