/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.stalkercubed.network;

import java.util.function.Supplier;
import net.mcreator.stalkercubed.StalkercubedrMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class StalkercubedrModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        StalkercubedrMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        StalkercubedrMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.rad_test = message.data.rad_test;
                    variables.psy = message.data.psy;
                    variables.him = message.data.him;
                    variables.intoxication = message.data.intoxication;
                    variables.art_speed = message.data.art_speed;
                    variables.art_weakness = message.data.art_weakness;
                    variables.art_health = message.data.art_health;
                    variables.art_electroshock = message.data.art_electroshock;
                    variables.art_wither = message.data.art_wither;
                    variables.art_jump = message.data.art_jump;
                    variables.art_slowness = message.data.art_slowness;
                    variables.art_poison = message.data.art_poison;
                    variables.art_resist = message.data.art_resist;
                    variables.art_rad = message.data.art_rad;
                    variables.art_rad_unres = message.data.art_rad_unres;
                    variables.art_rad_vvod = message.data.art_rad_vvod;
                    variables.art_hunger = message.data.art_hunger;
                    variables.art_power = message.data.art_power;
                    variables.art_blindness = message.data.art_blindness;
                    variables.art_ojog = message.data.art_ojog;
                    variables.art_acid = message.data.art_acid;
                    variables.rad_porog = message.data.rad_porog;
                    variables.anti_slowness_exo = message.data.anti_slowness_exo;
                    variables.art_regeneration = message.data.art_regeneration;
                    variables.art_anomprotect = message.data.art_anomprotect;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double rad_test = 0.0;
        public double psy = 0.0;
        public double him = 0.0;
        public double intoxication = 0.0;
        public double art_speed = 0.0;
        public double art_weakness = 0.0;
        public double art_health = 0.0;
        public double art_electroshock = 0.0;
        public double art_wither = 0.0;
        public double art_jump = 0.0;
        public double art_slowness = 0.0;
        public double art_poison = 0.0;
        public double art_resist = 0.0;
        public double art_rad = 0.0;
        public double art_rad_unres = 0.0;
        public double art_rad_vvod = 0.0;
        public double art_hunger = 0.0;
        public double art_power = 0.0;
        public double art_blindness = 0.0;
        public double art_ojog = 0.0;
        public double art_acid = 0.0;
        public double rad_porog = 0.0;
        public double anti_slowness_exo = 0.0;
        public double art_regeneration = 0.0;
        public double art_anomprotect = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                StalkercubedrMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("rad_test", this.rad_test);
            nbt.m_128347_("psy", this.psy);
            nbt.m_128347_("him", this.him);
            nbt.m_128347_("intoxication", this.intoxication);
            nbt.m_128347_("art_speed", this.art_speed);
            nbt.m_128347_("art_weakness", this.art_weakness);
            nbt.m_128347_("art_health", this.art_health);
            nbt.m_128347_("art_electroshock", this.art_electroshock);
            nbt.m_128347_("art_wither", this.art_wither);
            nbt.m_128347_("art_jump", this.art_jump);
            nbt.m_128347_("art_slowness", this.art_slowness);
            nbt.m_128347_("art_poison", this.art_poison);
            nbt.m_128347_("art_resist", this.art_resist);
            nbt.m_128347_("art_rad", this.art_rad);
            nbt.m_128347_("art_rad_unres", this.art_rad_unres);
            nbt.m_128347_("art_rad_vvod", this.art_rad_vvod);
            nbt.m_128347_("art_hunger", this.art_hunger);
            nbt.m_128347_("art_power", this.art_power);
            nbt.m_128347_("art_blindness", this.art_blindness);
            nbt.m_128347_("art_ojog", this.art_ojog);
            nbt.m_128347_("art_acid", this.art_acid);
            nbt.m_128347_("rad_porog", this.rad_porog);
            nbt.m_128347_("anti_slowness_exo", this.anti_slowness_exo);
            nbt.m_128347_("art_regeneration", this.art_regeneration);
            nbt.m_128347_("art_anomprotect", this.art_anomprotect);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.rad_test = nbt.m_128459_("rad_test");
            this.psy = nbt.m_128459_("psy");
            this.him = nbt.m_128459_("him");
            this.intoxication = nbt.m_128459_("intoxication");
            this.art_speed = nbt.m_128459_("art_speed");
            this.art_weakness = nbt.m_128459_("art_weakness");
            this.art_health = nbt.m_128459_("art_health");
            this.art_electroshock = nbt.m_128459_("art_electroshock");
            this.art_wither = nbt.m_128459_("art_wither");
            this.art_jump = nbt.m_128459_("art_jump");
            this.art_slowness = nbt.m_128459_("art_slowness");
            this.art_poison = nbt.m_128459_("art_poison");
            this.art_resist = nbt.m_128459_("art_resist");
            this.art_rad = nbt.m_128459_("art_rad");
            this.art_rad_unres = nbt.m_128459_("art_rad_unres");
            this.art_rad_vvod = nbt.m_128459_("art_rad_vvod");
            this.art_hunger = nbt.m_128459_("art_hunger");
            this.art_power = nbt.m_128459_("art_power");
            this.art_blindness = nbt.m_128459_("art_blindness");
            this.art_ojog = nbt.m_128459_("art_ojog");
            this.art_acid = nbt.m_128459_("art_acid");
            this.rad_porog = nbt.m_128459_("rad_porog");
            this.anti_slowness_exo = nbt.m_128459_("anti_slowness_exo");
            this.art_regeneration = nbt.m_128459_("art_regeneration");
            this.art_anomprotect = nbt.m_128459_("art_anomprotect");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("stalkercubedr", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "stalkercubedr_mapvars";
        public String nicknamepdafunction = "\"pda_username\"";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.nicknamepdafunction = nbt.m_128461_("nicknamepdafunction");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128359_("nicknamepdafunction", this.nicknamepdafunction);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                StalkercubedrMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "stalkercubedr_worldvars";
        public double art_zones = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.art_zones = nbt.m_128459_("art_zones");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("art_zones", this.art_zones);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                StalkercubedrMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            if (!event.isWasDeath()) {
                clone.rad_test = original.rad_test;
                clone.psy = original.psy;
                clone.him = original.him;
                clone.intoxication = original.intoxication;
                clone.art_speed = original.art_speed;
                clone.art_weakness = original.art_weakness;
                clone.art_health = original.art_health;
                clone.art_electroshock = original.art_electroshock;
                clone.art_wither = original.art_wither;
                clone.art_jump = original.art_jump;
                clone.art_slowness = original.art_slowness;
                clone.art_poison = original.art_poison;
                clone.art_resist = original.art_resist;
                clone.art_rad = original.art_rad;
                clone.art_rad_unres = original.art_rad_unres;
                clone.art_rad_vvod = original.art_rad_vvod;
                clone.art_hunger = original.art_hunger;
                clone.art_power = original.art_power;
                clone.art_blindness = original.art_blindness;
                clone.art_ojog = original.art_ojog;
                clone.art_acid = original.art_acid;
                clone.rad_porog = original.rad_porog;
                clone.anti_slowness_exo = original.anti_slowness_exo;
                clone.art_regeneration = original.art_regeneration;
                clone.art_anomprotect = original.art_anomprotect;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    StalkercubedrMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    StalkercubedrMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                StalkercubedrMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

