/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_9779;
import net.weather_classic.config.CustomTornadoConfig;
import net.weather_classic.config.ModConfig;
import net.weather_classic.config.TornadoParticleConfig;
import net.weather_classic.gui.DebugMenuScreen;
import net.weather_classic.gui.TemplateConstructorScreen;
import net.weather_classic.gui.TornadoCreationScreen;
import net.weather_classic.gui.handled.TurbineScreen;
import net.weather_classic.networking.client.WCNetworkClient;
import net.weather_classic.registry.WCClientBlocks;
import net.weather_classic.registry.WCClientEntities;
import net.weather_classic.registry.WCClientParticles;

@Environment(value=EnvType.CLIENT)
public class WeatherClassicClient
implements ClientModInitializer {
    public static Map<Byte, TornadoParticleConfig> CLIENT_PARTICLE_OVERRIDE_CONFIGS = new HashMap<Byte, TornadoParticleConfig>();
    public static final class_304.class_11900 WEATHER_DEBUG = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"weather_classic", (String)"weather_debug"));
    public static final class_304 DEBUG_MENU_BINDING = new class_304("key.weather_classic.debug_menu", class_3675.class_307.field_1668, 334, WEATHER_DEBUG);
    public static final class_304 DEBUG_MENU_BINDING_ALT = new class_304("key.weather_classic.debug_menu_alt", class_3675.class_307.field_1668, 61, WEATHER_DEBUG);
    public static final class_437 DEBUG_MENU_SCREEN = new DebugMenuScreen();
    public static final TornadoCreationScreen CUSTOM_TORNADO_SCREEN = new TornadoCreationScreen();
    public static final DecimalFormat SHORT_FORMAT = new DecimalFormat("0.0");
    public static final DecimalFormat LONG_FORMAT = new DecimalFormat("0.000");
    public static final DecimalFormat MED_FORMAT = new DecimalFormat("0.00");
    public static final TemplateConstructorScreen TEST_ITEM_SCREEN = new TemplateConstructorScreen();
    public static byte defaultDebugPage = (byte)-1;
    public static boolean customTornadoInfoClicked = false;
    public static boolean debugMenuAlt = false;
    public static byte debugInfo = 0;
    public static boolean debugInfoStuck = false;

    public void onInitializeClient() {
        WCClientBlocks.init();
        WCClientParticles.init();
        WCClientEntities.init();
        WCNetworkClient.setupClientNetworking();
        KeyBindingHelper.registerKeyBinding((class_304)DEBUG_MENU_BINDING);
        KeyBindingHelper.registerKeyBinding((class_304)DEBUG_MENU_BINDING_ALT);
        TurbineScreen.registerAsHandled();
        HudElementRegistry.attachElementBefore((class_2960)VanillaHudElements.CHAT, (class_2960)class_2960.method_60655((String)"weather_classic", (String)"debug_info"), (HudElement)WeatherClassicClient.renderDebugInfoIndepedently());
    }

    private static HudElement renderDebugInfoIndepedently() {
        return new HudElement(){

            public void render(class_332 context, class_9779 tickCounter) {
                if (!debugInfoStuck) {
                    return;
                }
                context.method_51448().pushMatrix();
                int ySize = 200;
                class_310 client = class_310.method_1551();
                int height = client.method_22683().method_4502();
                int menuYSize = ySize;
                int menuY = (height - menuYSize) / 2;
                int infoX = 40;
                int infoY = menuY - 5;
                DebugMenuScreen.createWeatherInfo(context, infoX, infoY, tickCounter.method_60637(false), client, client.field_1772, (byte)0, (byte)0);
                context.method_51448().popMatrix();
            }
        };
    }

    public static int getTornadoFunnelScale(boolean custom) {
        float scale = custom ? CustomTornadoConfig.getScaling() : ModConfig.getGlobalHeightScaleOverride();
        float minScale = 0.5f;
        float maxScale = 2.0f;
        float minHeight = 50.0f;
        float maxHeight = 200.0f;
        float denom = maxScale - minScale;
        float t = denom == 0.0f ? 0.0f : (scale - minScale) / denom;
        t = Math.max(0.0f, Math.min(1.0f, t));
        float height = minHeight + t * (maxHeight - minHeight);
        return (int)height;
    }
}

