/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5218;
import net.weather_classic.WeatherClassic;
import net.weather_classic.config.ModConfig;
import org.joml.Vector3f;

public class CustomTornadoConfig {
    public static boolean USING_ALT = false;
    private static short speed = 0;
    private static byte ripType = 1;
    private static short time = (short)1200;
    private static byte pullType = 1;
    private static byte destructionLvlOverride = (byte)-1;
    private static boolean chasePlayers = false;
    private static float dispellerResistance = 0.0f;
    private static short extraParticleInterval = (short)2;
    private static byte extraParticleDistance = (byte)8;
    private static boolean createClouds = true;
    private static boolean colorOverride = false;
    private static boolean cloudColorOverride = false;
    private static float red = 0.1f;
    private static float green = 0.1f;
    private static float blue = 0.1f;
    private static boolean takeSurroundingColor = true;
    private static int soundDist = 50;
    private static byte passiveSoundType = 1;
    private static byte particleRadiusLvl = 1;
    private static short funnelWidth = (short)14;
    private static byte funnelPointedness = (byte)2;
    private static float funnelTightening = 0.0f;
    private static float scaling = 1.2f;
    private static byte particleCount = (byte)8;
    private static float baseParticleSizeIncrease = 0.15f;
    private static float bottomParticleSizeIncrease = 0.0f;
    private static float midParticleSizeIncrease = 0.0f;
    private static float topParticleSizeIncrease = 0.0f;
    private static byte biomeLockType = 0;
    private static float spawnPercent = 0.0f;
    private static byte weatherEventType = 0;

    public static float getDispellerResistance() {
        return dispellerResistance;
    }

    public static float getSpawnPercent() {
        if (!ModConfig.getEnableCustomTornadoes()) {
            return 0.0f;
        }
        return spawnPercent;
    }

    public static byte getWeatherEventType() {
        return weatherEventType;
    }

    public static byte getBiomeLockType() {
        return biomeLockType;
    }

    public static byte getPassiveSoundType() {
        return passiveSoundType;
    }

    public static int getSoundDist() {
        return soundDist;
    }

    public static boolean getTakeSurroundingColor() {
        return takeSurroundingColor;
    }

    public static boolean getChasePlayers() {
        return chasePlayers;
    }

    public static short getFunnelWidth() {
        return funnelWidth;
    }

    public static byte getFunnelPointedness() {
        return funnelPointedness;
    }

    public static float getFunnelTightening() {
        return funnelTightening;
    }

    public static short getSpeed() {
        return speed;
    }

    public static byte getParticleRadiusLvl() {
        return particleRadiusLvl;
    }

    public static byte getRipType(boolean includeBonus) {
        return (byte)(includeBonus ? ripType : (ripType > 4 ? (ripType == 7 ? 1 : 4) : ripType));
    }

    public static short getTime() {
        return time;
    }

    public static float getScaling() {
        return scaling;
    }

    public static byte getPullType(boolean includeBonus) {
        return includeBonus ? pullType : (pullType > 4 ? (byte)0 : pullType);
    }

    public static short getExtraParticleInterval() {
        return extraParticleInterval;
    }

    public static byte getExtraParticleDistance() {
        return extraParticleDistance;
    }

    public static boolean getCreateClouds() {
        return createClouds;
    }

    public static boolean getColorOverride() {
        return colorOverride;
    }

    public static boolean getCloudColorOverride() {
        return cloudColorOverride;
    }

    public static byte getDestructionLvlOverride() {
        return destructionLvlOverride;
    }

    public static Vector3f getColors() {
        return new Vector3f(red, green, blue);
    }

    public static byte getParticleCount() {
        return particleCount;
    }

    public static float getBaseParticleSizeIncrease() {
        return baseParticleSizeIncrease;
    }

    public static float getBottomParticleSizeIncrease() {
        return bottomParticleSizeIncrease;
    }

    public static float getMidParticleSizeIncrease() {
        return midParticleSizeIncrease;
    }

    public static float getTopParticleSizeIncrease() {
        return topParticleSizeIncrease;
    }

    public static boolean updateCustomTornadoInfo(class_3218 world, boolean upload, boolean alt) {
        boolean success = false;
        try {
            success = CustomTornadoConfig.manageCustomTornadoData(world, upload, alt);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to create custom tornado data!", e);
        }
        return success;
    }

    private static boolean manageCustomTornadoData(class_3218 world, boolean updateFile, boolean alt) throws IOException {
        File worldDir = world.method_8503().method_27050(class_5218.field_24188).toFile();
        String file = alt ? "wm_stagex_alt.properties" : "wm_stagex.properties";
        File dataFile = new File(worldDir, "wm_data/custom/" + file);
        boolean hadToCreate = false;
        if (!dataFile.exists()) {
            File parent = dataFile.getParentFile();
            parent.mkdirs();
            if (parent == null || !parent.exists()) {
                throw new IOException("CRITICAL ERROR: Could not create world folder: wm_data/custom for Weather Mod!");
            }
            if (!dataFile.createNewFile()) {
                throw new IOException("CRITICAL ERROR: Could not create stagex data for Weather Mod!");
            }
            CustomTornadoConfig.loadData(dataFile);
            CustomTornadoConfig.saveTornadoData(dataFile);
            hadToCreate = true;
        }
        if (updateFile && !hadToCreate) {
            CustomTornadoConfig.saveTornadoData(dataFile);
        } else {
            CustomTornadoConfig.loadData(dataFile);
        }
        return !hadToCreate;
    }

    private static void saveTornadoData(File dataFile) {
        Properties properties = new Properties();
        properties.setProperty("biomeLockType", String.valueOf(biomeLockType));
        properties.setProperty("weatherEventType", String.valueOf(weatherEventType));
        properties.setProperty("spawnPercent", String.valueOf(spawnPercent));
        properties.setProperty("passiveSoundType", String.valueOf(passiveSoundType));
        properties.setProperty("soundDist", String.valueOf(soundDist));
        properties.setProperty("chasePlayers", String.valueOf(chasePlayers));
        properties.setProperty("speed", String.valueOf(speed));
        properties.setProperty("particleRadiusLvl", String.valueOf(particleRadiusLvl));
        properties.setProperty("ripType", String.valueOf(ripType));
        properties.setProperty("time", String.valueOf(time));
        properties.setProperty("scaling", String.valueOf(scaling));
        properties.setProperty("pullType", String.valueOf(pullType));
        properties.setProperty("extraParticleInterval", String.valueOf(extraParticleInterval));
        properties.setProperty("extraParticleDistance", String.valueOf(extraParticleDistance));
        properties.setProperty("createClouds", String.valueOf(createClouds));
        properties.setProperty("colorOverride", String.valueOf(colorOverride));
        properties.setProperty("destructionLvlOverride", String.valueOf(destructionLvlOverride));
        properties.setProperty("cloudColorOverride", String.valueOf(cloudColorOverride));
        properties.setProperty("red", String.valueOf(red));
        properties.setProperty("green", String.valueOf(green));
        properties.setProperty("blue", String.valueOf(blue));
        properties.setProperty("particleCount", String.valueOf(particleCount));
        properties.setProperty("funnelWidth", String.valueOf(funnelWidth));
        properties.setProperty("funnelPointedness", String.valueOf(funnelPointedness));
        properties.setProperty("funnelTightening", String.valueOf(funnelTightening));
        properties.setProperty("takeSurroundingColor", String.valueOf(takeSurroundingColor));
        properties.setProperty("dispellerRes", String.valueOf(dispellerResistance));
        properties.setProperty("baseParticleSizeIncrease", String.valueOf(baseParticleSizeIncrease));
        properties.setProperty("bottomParticleSizeIncrease", String.valueOf(bottomParticleSizeIncrease));
        properties.setProperty("midParticleSizeIncrease", String.valueOf(midParticleSizeIncrease));
        properties.setProperty("topParticleSizeIncrease", String.valueOf(topParticleSizeIncrease));
        try (FileOutputStream output = new FileOutputStream(dataFile);){
            properties.store(output, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadData(File dataFile) {
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(dataFile);){
            properties.load(input);
            biomeLockType = Byte.parseByte(properties.getProperty("biomeLockType", "0"));
            weatherEventType = Byte.parseByte(properties.getProperty("weatherEventType", "0"));
            if (USING_ALT && weatherEventType > 6) {
                weatherEventType = (byte)6;
            }
            spawnPercent = Float.parseFloat(properties.getProperty("spawnPercent", "0"));
            passiveSoundType = Byte.parseByte(properties.getProperty("passiveSoundType", "1"));
            chasePlayers = Boolean.parseBoolean(properties.getProperty("chasePlayers", "false"));
            speed = Short.parseShort(properties.getProperty("speed", "0"));
            particleRadiusLvl = Byte.parseByte(properties.getProperty("particleRadiusLvl", "1"));
            ripType = Byte.parseByte(properties.getProperty("ripType", "1"));
            time = Short.parseShort(properties.getProperty("time", "1200"));
            scaling = Float.parseFloat(properties.getProperty("scaling", "1.2"));
            pullType = Byte.parseByte(properties.getProperty("pullType", "1"));
            extraParticleInterval = Short.parseShort(properties.getProperty("extraParticleInterval", "2"));
            extraParticleDistance = Byte.parseByte(properties.getProperty("extraParticleDistance", "8"));
            createClouds = Boolean.parseBoolean(properties.getProperty("createClouds", "true"));
            colorOverride = Boolean.parseBoolean(properties.getProperty("colorOverride", "false"));
            cloudColorOverride = Boolean.parseBoolean(properties.getProperty("cloudColorOverride", "false"));
            destructionLvlOverride = Byte.parseByte(properties.getProperty("destructionLvlOverride", "-1"));
            red = Float.parseFloat(properties.getProperty("red", "0"));
            green = Float.parseFloat(properties.getProperty("green", "0"));
            blue = Float.parseFloat(properties.getProperty("blue", "0"));
            particleCount = Byte.parseByte(properties.getProperty("particleCount", "8"));
            funnelPointedness = Byte.parseByte(properties.getProperty("funnelPointedness", "2"));
            funnelTightening = Float.parseFloat(properties.getProperty("funnelTightening", "0"));
            funnelWidth = Short.parseShort(properties.getProperty("funnelWidth", "14"));
            takeSurroundingColor = Boolean.parseBoolean(properties.getProperty("takeSurroundingColor", "true"));
            soundDist = Integer.parseInt(properties.getProperty("soundDist", "50"));
            baseParticleSizeIncrease = Float.parseFloat(properties.getProperty("baseParticleSizeIncrease", "0.15"));
            bottomParticleSizeIncrease = Float.parseFloat(properties.getProperty("bottomParticleSizeIncrease", "0"));
            midParticleSizeIncrease = Float.parseFloat(properties.getProperty("midParticleSizeIncrease", "0"));
            topParticleSizeIncrease = Float.parseFloat(properties.getProperty("topParticleSizeIncrease", "0"));
            dispellerResistance = Float.parseFloat(properties.getProperty("dispellerRes", "0"));
            passiveSoundType = (byte)class_3532.method_15340((int)passiveSoundType, (int)0, (int)4);
            speed = (short)class_3532.method_15340((int)speed, (int)0, (int)9);
            particleRadiusLvl = (byte)class_3532.method_15340((int)particleRadiusLvl, (int)0, (int)9);
            ripType = (byte)class_3532.method_15340((int)ripType, (int)0, (int)7);
            time = (short)class_3532.method_15340((int)time, (int)500, (int)5000);
            scaling = class_3532.method_15363((float)scaling, (float)0.5f, (float)3.0f);
            pullType = (byte)class_3532.method_15340((int)pullType, (int)0, (int)5);
            extraParticleInterval = (short)class_3532.method_15340((int)extraParticleInterval, (int)1, (int)10);
            extraParticleDistance = (byte)class_3532.method_15340((int)extraParticleDistance, (int)1, (int)9);
            destructionLvlOverride = (byte)class_3532.method_15340((int)destructionLvlOverride, (int)-1, (int)2);
            red = (float)class_3532.method_15350((double)red, (double)0.1, (double)1.0);
            green = (float)class_3532.method_15350((double)green, (double)0.1, (double)1.0);
            blue = (float)class_3532.method_15350((double)blue, (double)0.1, (double)1.0);
            particleCount = (byte)class_3532.method_15340((int)particleCount, (int)1, (int)20);
            funnelPointedness = (byte)class_3532.method_15340((int)funnelPointedness, (int)1, (int)4);
            funnelTightening = class_3532.method_15363((float)funnelTightening, (float)0.0f, (float)1.0f);
            funnelWidth = (short)class_3532.method_15340((int)funnelWidth, (int)0, (int)50);
            soundDist = class_3532.method_15340((int)soundDist, (int)0, (int)150);
            baseParticleSizeIncrease = class_3532.method_15363((float)baseParticleSizeIncrease, (float)0.0f, (float)0.3f);
            bottomParticleSizeIncrease = class_3532.method_15363((float)bottomParticleSizeIncrease, (float)0.0f, (float)0.3f);
            midParticleSizeIncrease = class_3532.method_15363((float)midParticleSizeIncrease, (float)0.0f, (float)0.3f);
            topParticleSizeIncrease = class_3532.method_15363((float)topParticleSizeIncrease, (float)0.0f, (float)0.3f);
            dispellerResistance = class_3532.method_15363((float)dispellerResistance, (float)0.0f, (float)1.0f);
            biomeLockType = (byte)class_3532.method_15340((int)biomeLockType, (int)0, (int)5);
            weatherEventType = (byte)class_3532.method_15340((int)weatherEventType, (int)0, (int)8);
            spawnPercent = class_3532.method_15363((float)spawnPercent, (float)0.0f, (float)1.0f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setDispellerResistance(float res) {
        dispellerResistance = res;
    }

    public static void setSpawnPercent(float spawn) {
        spawnPercent = spawn;
    }

    public static void setBiomeLockType(byte b) {
        biomeLockType = b;
    }

    public static void setWeatherEventType(byte b) {
        weatherEventType = b;
    }

    public static void setPassiveeSoundType(byte b) {
        passiveSoundType = b;
    }

    public static void setSoundDist(int d) {
        soundDist = d;
    }

    public static void setTakeSurroundingColor(boolean surroundingColor) {
        takeSurroundingColor = surroundingColor;
    }

    public static void setChasePlayers(boolean chase) {
        chasePlayers = chase;
    }

    public static void setDestructionLvlOverride(byte lvl) {
        destructionLvlOverride = lvl;
    }

    public static void setSpeed(short speed) {
        CustomTornadoConfig.speed = speed;
    }

    public static void setRipType(byte ripType) {
        CustomTornadoConfig.ripType = ripType;
    }

    public static void setTime(short time) {
        CustomTornadoConfig.time = time;
    }

    public static void setPullType(byte pullType) {
        CustomTornadoConfig.pullType = pullType;
    }

    public static void setScaling(float scaling) {
        CustomTornadoConfig.scaling = scaling;
    }

    public static void setExtraParticleInterval(short extraParticleInterval) {
        CustomTornadoConfig.extraParticleInterval = extraParticleInterval;
    }

    public static void setExtraParticleDistance(byte extraParticleDistance) {
        CustomTornadoConfig.extraParticleDistance = extraParticleDistance;
    }

    public static void setCreateClouds(boolean createClouds) {
        CustomTornadoConfig.createClouds = createClouds;
    }

    public static void setColorOverride(boolean colorOverride) {
        CustomTornadoConfig.colorOverride = colorOverride;
    }

    public static void setCloudColorOverride(boolean cloudColorOverride) {
        CustomTornadoConfig.cloudColorOverride = cloudColorOverride;
    }

    public static void setRed(float red) {
        CustomTornadoConfig.red = red;
    }

    public static void setGreen(float green) {
        CustomTornadoConfig.green = green;
    }

    public static void setBlue(float blue) {
        CustomTornadoConfig.blue = blue;
    }

    public static void setParticleRadiusLvl(byte particleRadiusLvl) {
        CustomTornadoConfig.particleRadiusLvl = particleRadiusLvl;
    }

    public static void setFunnelWidth(short funnelWidth) {
        CustomTornadoConfig.funnelWidth = funnelWidth;
    }

    public static void setFunnelPointedness(byte funnelPointedness) {
        CustomTornadoConfig.funnelPointedness = funnelPointedness;
    }

    public static void setFunnelTightening(float funnelTightening) {
        CustomTornadoConfig.funnelTightening = funnelTightening;
    }

    public static void setParticleCount(byte particleCount) {
        CustomTornadoConfig.particleCount = particleCount;
    }

    public static void setBaseParticleSizeIncrease(float baseParticleSizeIncrease) {
        CustomTornadoConfig.baseParticleSizeIncrease = baseParticleSizeIncrease;
    }

    public static void setBottomParticleSizeIncrease(float bottomParticleSizeIncrease) {
        CustomTornadoConfig.bottomParticleSizeIncrease = bottomParticleSizeIncrease;
    }

    public static void setMidParticleSizeIncrease(float midParticleSizeIncrease) {
        CustomTornadoConfig.midParticleSizeIncrease = midParticleSizeIncrease;
    }

    public static void setTopParticleSizeIncrease(float topParticleSizeIncrease) {
        CustomTornadoConfig.topParticleSizeIncrease = topParticleSizeIncrease;
    }

    public static float getTornadoParticleRadiusFromLvl() {
        switch (CustomTornadoConfig.getParticleRadiusLvl()) {
            case 0: {
                return 1.5f;
            }
            case 2: {
                return 3.0f;
            }
            case 3: {
                return 5.0f;
            }
            case 4: {
                return 8.0f;
            }
            case 5: {
                return 10.0f;
            }
            case 6: {
                return 16.0f;
            }
            case 7: {
                return 24.0f;
            }
            case 8: {
                return 40.0f;
            }
            case 9: {
                return 60.0f;
            }
        }
        return 2.0f;
    }

    public static short getTornadoParticleFindRangeFromLvl() {
        float range = CustomTornadoConfig.getTornadoParticleRadiusFromLvl();
        switch (CustomTornadoConfig.getParticleRadiusLvl()) {
            case 0: {
                return (short)(range + 16.0f);
            }
            case 2: {
                return (short)(range + 16.0f);
            }
            case 3: {
                return (short)(range + 16.0f);
            }
            case 4: {
                return (short)(range + 16.0f);
            }
            case 5: {
                return (short)(range + 16.0f);
            }
            case 6: {
                return (short)(range + 16.0f);
            }
            case 7: {
                return (short)(range * 2.0f);
            }
            case 8: {
                return (short)(range * 2.0f);
            }
            case 9: {
                return (short)(range * 2.0f);
            }
        }
        return (short)(range + 12.0f);
    }

    public static float getGrabSpeed() {
        return switch (CustomTornadoConfig.getPullType(true)) {
            case 0 -> WeatherClassic.SPOUT_CONFIG.grabSpeed + 0.05f;
            case 2 -> WeatherClassic.STAGE3_CONFIG.grabSpeed;
            case 3 -> WeatherClassic.STAGE4_CONFIG.grabSpeed;
            case 4 -> WeatherClassic.STAGE5_CONFIG.grabSpeed;
            case 5 -> WeatherClassic.SPOUT_CONFIG.grabSpeed + 0.01f;
            default -> WeatherClassic.STAGE2_CONFIG.grabSpeed;
        };
    }

    public static byte getWeatherEventForAlt(class_3218 world) {
        byte by;
        String file;
        File worldDir = world.method_8503().method_27050(class_5218.field_24188).toFile();
        File dataFile = new File(worldDir, "wm_data/custom/" + (file = "wm_stagex_alt.properties"));
        if (!dataFile.exists()) {
            return -1;
        }
        Properties properties = new Properties();
        FileInputStream input = new FileInputStream(dataFile);
        try {
            properties.load(input);
            by = Byte.parseByte(properties.getProperty("weatherEventType", "0"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Could not access alternative tornado data! wm_stagex_alt is missing or corrupted!", e);
            }
        }
        ((InputStream)input).close();
        return by;
    }
}

