/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3532;
import net.weather_classic.WeatherClassic;
import net.weather_classic.config.CustomTornadoConfig;
import net.weather_classic.config.TornadoParticleConfig;
import net.weather_classic.global.tools.TornadoDestructionInfo;

public class ModConfig {
    private static final Path configDir = FabricLoader.getInstance().getConfigDir().resolve("WeatherMod.json");
    public static boolean WARN_DUE_TO_OUTDATED_VERSION = false;
    public static final byte CUR_VER = 14;
    private static int maxTornadoes = 2;
    private static int maxDaysNoRain = 3;
    private static int maxDaysNoStorm = 5;
    private static int maxRainNoDownpour = 5;
    private static int rainChanceBase = 62;
    private static int stormChanceBase = 35;
    private static int rainWorsenChance = 10;
    private static byte tornadoDestructionLvl = (byte)2;
    private static boolean tornadoesBiasTowardsPlayers = true;
    private static boolean tornadoesExtraLongDuration = false;
    private static int tornadoFrequency = 37;
    private static int waterspoutFrequency = 50;
    private static boolean allowMultipleTornadoesSameStorm = false;
    private static int maxDebrisPerTornado = 60;
    private static int maxMobsPerTornado = 40;
    private static boolean terrariaReference = true;
    private static boolean severeStormLightningStrikesMobs = true;
    private static boolean severeStormLightningStrikesPlayers = true;
    private static byte tornadoesBiasIntensityLvl = 1;
    private static boolean forceChunkRemovalOnWorldLoad = true;
    private static int stormBecomeSevereStormChance = 77;
    private static int maxTornadoLoadDistance = 464;
    private static int apexOnlyChance = 30;
    private static int stageForceHighIfLongStormChance = 45;
    private static int stage2Chance = 72;
    private static int stage3ChanceIfNot2 = 80;
    private static int stage4ChanceIfNot3 = 75;
    private static int maxWindNoGale = 6;
    private static int cursedStormChance = 2;
    private static boolean cullTurbineSound = false;
    private static boolean forceDebrisVelocityUpdates = true;
    private static boolean enableCustomTornadoes = true;
    private static int passiveFirenadoChance = 1;
    private static boolean cullDebrisRendering = false;
    private static int tornadoDetectorRange = 256;
    private static boolean enableGale = true;
    private static boolean enableDownpour = true;
    private static int maxDebrisParticles = 500;
    private static boolean doFreezing = true;
    private static boolean doClusters = true;
    private static int clusterChanceBase = 22;
    private static int maxDaysNoCluster = 4;
    private static int maxClusters = 2;
    private static boolean lowerClouds = true;
    private static boolean simpleForcedChunks = false;
    private static boolean cityDestructionMode = false;
    private static int stormStageIntensitySpeed = 5000;
    private static boolean mimicOldParticles = false;
    private static boolean emissiveParticles = true;
    private static boolean generateParticleOverride = false;
    private static boolean disablePuzzleChambers = false;
    private static int constructItemSpeedLvl = 1;
    private static int baseTornadoDuration = 2400;
    private static boolean noRopes = false;
    private static boolean debug = false;
    public static Map<String, TornadoDestructionInfo.BlockDestroyType> CUSTOM_BLOCK_LIST = new HashMap<String, TornadoDestructionInfo.BlockDestroyType>();
    public static Map<Byte, TornadoParticleConfig> PARTICLE_OVERRIDE_CONFIGS = new HashMap<Byte, TornadoParticleConfig>();
    private static final Path overrideDir = FabricLoader.getInstance().getConfigDir().resolve("WeatherMod_ParticleOverrides.json");
    private static float globalheightScale = 1.2f;

    public static boolean getNoRopes() {
        return noRopes;
    }

    public static int getBaseTornadoDuration() {
        return baseTornadoDuration;
    }

    public static int getConstructItemSpeedLvl() {
        return constructItemSpeedLvl;
    }

    public static boolean getDisablePuzzleChambers() {
        return disablePuzzleChambers;
    }

    public static boolean getGenerateOverrides() {
        return generateParticleOverride;
    }

    public static boolean getEmissiveParticles() {
        return emissiveParticles;
    }

    public static boolean getMimicOld() {
        return mimicOldParticles;
    }

    public static int getStormStageIntensitySpeed() {
        return stormStageIntensitySpeed;
    }

    public static boolean getCityDestructionMode() {
        return cityDestructionMode;
    }

    public static boolean getSimpleForcedChunks() {
        return simpleForcedChunks;
    }

    public static boolean getLowerClouds() {
        return lowerClouds;
    }

    public static int getMaxClusters() {
        return maxClusters;
    }

    public static int getMaxDaysNoCluster() {
        return maxDaysNoCluster;
    }

    public static int getBaseClusterChance() {
        return clusterChanceBase;
    }

    public static boolean enableClusters() {
        return doClusters;
    }

    public static int getMaxDebrisParticles() {
        return maxDebrisParticles;
    }

    public static boolean getFreezing() {
        return doFreezing;
    }

    public static boolean getEnableGale() {
        return enableGale;
    }

    public static int getTornadoDetectorRange() {
        return tornadoDetectorRange;
    }

    public static boolean getCullDebrisRendering() {
        return cullDebrisRendering;
    }

    public static boolean getEnableDownpour() {
        return enableDownpour;
    }

    public static int getPassiveFirenadoChance() {
        return passiveFirenadoChance;
    }

    public static boolean getEnableCustomTornadoes() {
        return enableCustomTornadoes;
    }

    public static boolean forceDebrisVelocityUpdates() {
        return forceDebrisVelocityUpdates;
    }

    public static boolean getCullTurbineSound() {
        return cullTurbineSound;
    }

    public static int getCursedStormChance() {
        return cursedStormChance;
    }

    public static int getMaxWindNoGale() {
        return maxWindNoGale;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static int getApexOnlyChance() {
        return apexOnlyChance;
    }

    public static int getForceHighStageChanceIfLong() {
        return stageForceHighIfLongStormChance;
    }

    public static int getStage2Chance() {
        return stage2Chance;
    }

    public static int getStage3ChanceIfNot2() {
        return stage3ChanceIfNot2;
    }

    public static int getStage4ChanceIfNot3() {
        return stage4ChanceIfNot3;
    }

    public static int getMaxTornadoLoadDist() {
        return maxTornadoLoadDistance;
    }

    public static int getMaxTornadoes() {
        return maxTornadoes;
    }

    public static int getMaxDaysNoRain() {
        return maxDaysNoRain;
    }

    public static int getMaxDaysNoStorm() {
        return maxDaysNoStorm;
    }

    public static int getMaxRainDaysNoDownpour() {
        return maxRainNoDownpour;
    }

    public static int getRainChanceBase() {
        return rainChanceBase;
    }

    public static int getStormChanceBase() {
        return stormChanceBase;
    }

    public static int getRainWorsenChance() {
        return rainWorsenChance;
    }

    public static byte getTornadoDestructionLvl() {
        return tornadoDestructionLvl;
    }

    public static boolean getTornadoesBiasTowardsPlayers() {
        return tornadoesBiasTowardsPlayers;
    }

    public static boolean getTornadoesExtraLongDuration() {
        return tornadoesExtraLongDuration;
    }

    public static float getTornadoFrequency() {
        return (float)tornadoFrequency / 100.0f;
    }

    public static float getWaterspoutFrequency() {
        return (float)waterspoutFrequency / 100.0f;
    }

    public static boolean getAllowMultipleTornadoesSameStorm() {
        return allowMultipleTornadoesSameStorm;
    }

    public static int getMaxMobsPerTornado() {
        return maxMobsPerTornado;
    }

    public static int getMaxDebrisPerTornado() {
        return maxDebrisPerTornado;
    }

    public static boolean getTerrariaReference() {
        return terrariaReference;
    }

    public static boolean getSevereStormLightningStrikesMobs() {
        return severeStormLightningStrikesMobs;
    }

    public static boolean getSevereStormLightningStrikesPlayers() {
        return severeStormLightningStrikesPlayers;
    }

    public static byte getTornadoBiasIntensityLvl() {
        return tornadoesBiasIntensityLvl;
    }

    public static boolean getForceChunkRemovalOnWorldLoad() {
        return forceChunkRemovalOnWorldLoad;
    }

    public static int getSevereStormChance() {
        return stormBecomeSevereStormChance;
    }

    public static boolean loadConfig() throws IOException {
        boolean hadToCreate = false;
        File dataFile = configDir.toFile();
        if (!dataFile.exists()) {
            if (!dataFile.createNewFile()) {
                throw new IOException("CRITICAL ERROR: Could not create config for Weather & Tornadoes Remastered!");
            }
            ModConfig.saveDefaultConfig(dataFile);
            hadToCreate = true;
        }
        ModConfig.addNewConfigOptions(dataFile);
        ModConfig.loadConfig(dataFile);
        return !hadToCreate;
    }

    private static void addNewConfigOptions(File dataFile) {
        Properties properties = new Properties();
        if (dataFile.exists()) {
            try (FileInputStream input = new FileInputStream(dataFile);){
                properties.load(input);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!properties.containsKey("Misc_useOldParticles_R")) {
            properties.setProperty("Misc_useOldParticles_R", String.valueOf(false));
        }
        if (!properties.containsKey("Misc_emissiveParticles_R")) {
            properties.setProperty("Misc_emissiveParticles_R", String.valueOf(true));
        }
        if (!properties.containsKey("experimental_generateParticleOverrideFile_R")) {
            properties.setProperty("experimental_generateParticleOverrideFile_R", String.valueOf(false));
        }
        if (!properties.containsKey("Misc_disablePuzzleChambers")) {
            properties.setProperty("Misc_disablePuzzleChambers", String.valueOf(false));
        }
        if (!properties.containsKey("Misc_constructItemSpeedLvl")) {
            properties.setProperty("Misc_constructItemSpeedLvl", String.valueOf(1));
        }
        if (!properties.containsKey("Storm_tornadoBaseDuration")) {
            properties.setProperty("Storm_tornadoBaseDuration", String.valueOf(2400));
        }
        if (!properties.containsKey("Storm_disableVariants")) {
            properties.setProperty("Storm_disableVariants", String.valueOf(false));
        }
        try (FileOutputStream output = new FileOutputStream(dataFile);){
            properties.store(output, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void saveDefaultConfig(File dataFile) {
        Properties properties = new Properties();
        properties.setProperty("!WCV!", String.valueOf(14));
        properties.setProperty("Storm_maxTornadoes", String.valueOf(2));
        properties.setProperty("Weather_maxDaysNoRain", String.valueOf(3));
        properties.setProperty("Weather_maxDaysNoStorm", String.valueOf(5));
        properties.setProperty("Weather_maxRainNoDownpour", String.valueOf(5));
        properties.setProperty("Weather_maxWindNoGale", String.valueOf(6));
        properties.setProperty("Weather_baseRainChanceOutOf100", String.valueOf(62));
        properties.setProperty("Weather_baseStormChanceOutOf100", String.valueOf(35));
        properties.setProperty("Weather_rainWorsenChanceOutOf100", String.valueOf(10));
        properties.setProperty("Storm_tornadoDestructionLvl", String.valueOf(2));
        properties.setProperty("Storm_tornadoesBiasTowardsPlayers", String.valueOf(true));
        properties.setProperty("Storm_tornadoesExtraLongDuration", String.valueOf(false));
        properties.setProperty("Storm_tornadoFrequencyOutOf100", String.valueOf(37));
        properties.setProperty("Storm_waterspoutFrequencyOutOf100", String.valueOf(50));
        properties.setProperty("Storm_allowMultipleTornadoes", String.valueOf(false));
        properties.setProperty("Performance_maxMovingBlocksPerTornado", String.valueOf(60));
        properties.setProperty("Performance_maxMobsPerTornado", String.valueOf(40));
        properties.setProperty("Misc_terrariaReference", String.valueOf(true));
        properties.setProperty("Storm_lightningStrikesMobs", String.valueOf(true));
        properties.setProperty("Storm_lightningStrikesPlayers", String.valueOf(true));
        properties.setProperty("Storm_tornadoBiasIntensityLvl", String.valueOf(1));
        properties.setProperty("ALL_FORCE_CHUNKS_REMOVED_ON_WORLD_LOAD_DEBUG", String.valueOf(true));
        properties.setProperty("Weather_severeStormChanceOutOf100", String.valueOf(77));
        properties.setProperty("Storm_maxTornadoLoadDistance_R", String.valueOf(464));
        properties.setProperty("Performance_maxDebrisParticles_R", String.valueOf(500));
        properties.setProperty("Storm_delayedTornadoChanceOutOf100", String.valueOf(30));
        properties.setProperty("Storm_forceHighStageIfLongChanceOutOf100", String.valueOf(50));
        properties.setProperty("debug_R", String.valueOf(false));
        properties.setProperty("Weather_cursedStormChanceOutOf100", String.valueOf(2));
        properties.setProperty("Misc_cullTurbineSound", String.valueOf(false));
        properties.setProperty("Misc_forceDebrisVelocityUpdates", String.valueOf(true));
        properties.setProperty("debug_enableCustomTornadoes_R", String.valueOf(true));
        properties.setProperty("Storm_passiveFirenadoChanceOutOf100", String.valueOf(1));
        properties.setProperty("Performance_cullDebrisRendering_R", String.valueOf(false));
        properties.setProperty("Misc_tornadoDetectorRange", String.valueOf(256));
        properties.setProperty("Weather_galeEnabled", String.valueOf(true));
        properties.setProperty("Weather_downpourEnabled", String.valueOf(true));
        properties.setProperty("Weather_doFreezing", String.valueOf(true));
        properties.setProperty("Clusters_enable", String.valueOf(true));
        properties.setProperty("Clusters_maxDaysNoStorm", String.valueOf(4));
        properties.setProperty("Clusters_baseStormChanceOutOf100", String.valueOf(22));
        properties.setProperty("Clusters_maxStorms", String.valueOf(2));
        properties.setProperty("Performance_forceMinimumChunks", String.valueOf(false));
        properties.setProperty("Storm_cityDestructionMode_R", String.valueOf(false));
        properties.setProperty("Storm_intensitySpeed", String.valueOf(5000));
        properties.setProperty("BlockListAdd_minecraft:barrier", "PROTECT");
        properties.setProperty("BlockListAdd_namespace:example_block", "RIP");
        properties.setProperty("BlockListAdd_namespace:example_block2", "BREAK");
        properties.setProperty("Misc_useOldCloudHeight", String.valueOf(true));
        try (FileOutputStream output = new FileOutputStream(dataFile);){
            properties.store(output, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadConfig(File dataFile) {
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(dataFile);){
            properties.load(input);
            maxTornadoes = Integer.parseInt(properties.getProperty("Storm_maxTornadoes", "2"));
            maxDaysNoRain = Integer.parseInt(properties.getProperty("Weather_maxDaysNoRain", "3"));
            maxDaysNoStorm = Integer.parseInt(properties.getProperty("Weather_maxDaysNoStorm", "5"));
            maxRainNoDownpour = Integer.parseInt(properties.getProperty("Weather_maxRainNoDownpour", "5"));
            maxWindNoGale = Integer.parseInt(properties.getProperty("Weather_maxWindNoGale", "6"));
            enableGale = Boolean.parseBoolean(properties.getProperty("Weather_galeEnabled", "true"));
            enableDownpour = Boolean.parseBoolean(properties.getProperty("Weather_downpourEnabled", "true"));
            rainChanceBase = Integer.parseInt(properties.getProperty("Weather_baseRainChanceOutOf100", "62"));
            stormChanceBase = Integer.parseInt(properties.getProperty("Weather_baseStormChanceOutOf100", "35"));
            rainWorsenChance = Integer.parseInt(properties.getProperty("Weather_rainWorsenChanceOutOf100", "10"));
            tornadoDestructionLvl = Byte.parseByte(properties.getProperty("Storm_tornadoDestructionLvl", "2"));
            tornadoesBiasTowardsPlayers = Boolean.parseBoolean(properties.getProperty("Storm_tornadoesBiasTowardsPlayers", "true"));
            tornadoesExtraLongDuration = Boolean.parseBoolean(properties.getProperty("Storm_tornadoesExtraLongDuration", "false"));
            tornadoFrequency = Integer.parseInt(properties.getProperty("Storm_tornadoFrequencyOutOf100", "37"));
            waterspoutFrequency = Integer.parseInt(properties.getProperty("Storm_waterspoutFrequencyOutOf100", "50"));
            allowMultipleTornadoesSameStorm = Boolean.parseBoolean(properties.getProperty("Storm_allowMultipleTornadoes", "false"));
            maxDebrisPerTornado = Integer.parseInt(properties.getProperty("Performance_maxMovingBlocksPerTornado", "60"));
            maxMobsPerTornado = Integer.parseInt(properties.getProperty("Performance_maxMobsPerTornado", "40"));
            terrariaReference = Boolean.parseBoolean(properties.getProperty("Misc_terrariaReference", "true"));
            severeStormLightningStrikesMobs = Boolean.parseBoolean(properties.getProperty("Storm_lightningStrikesMobs", "true"));
            severeStormLightningStrikesPlayers = Boolean.parseBoolean(properties.getProperty("Storm_lightningStrikesPlayers", "true"));
            tornadoesBiasIntensityLvl = Byte.parseByte(properties.getProperty("Storm_tornadoBiasIntensityLvl", "1"));
            forceChunkRemovalOnWorldLoad = Boolean.parseBoolean(properties.getProperty("ALL_FORCE_CHUNKS_REMOVED_ON_WORLD_LOAD_DEBUG", "true"));
            stormBecomeSevereStormChance = Integer.parseInt(properties.getProperty("Weather_severeStormChanceOutOf100", "77"));
            maxTornadoLoadDistance = Integer.parseInt(properties.getProperty("Storm_maxTornadoLoadDistance_R", "464"));
            apexOnlyChance = Integer.parseInt(properties.getProperty("Storm_delayedTornadoChanceOutOf100", "30"));
            stageForceHighIfLongStormChance = Integer.parseInt(properties.getProperty("Storm_forceHighStageIfLongChanceOutOf100", "50"));
            cursedStormChance = Integer.parseInt(properties.getProperty("Weather_cursedStormChanceOutOf100", "2"));
            cullTurbineSound = Boolean.parseBoolean(properties.getProperty("Misc_cullTurbineSound", "false"));
            forceDebrisVelocityUpdates = Boolean.parseBoolean(properties.getProperty("Misc_forceDebrisVelocityUpdates", "true"));
            enableCustomTornadoes = Boolean.parseBoolean(properties.getProperty("debug_enableCustomTornadoes_R", "true"));
            passiveFirenadoChance = Integer.parseInt(properties.getProperty("Storm_passiveFirenadoChanceOutOf100", "1"));
            cullDebrisRendering = Boolean.parseBoolean(properties.getProperty("Misc_cullDebrisRendering_R", "false"));
            tornadoDetectorRange = Integer.parseInt(properties.getProperty("Misc_tornadoDetectorRange", "256"));
            maxDebrisParticles = Integer.parseInt(properties.getProperty("Storm_maxDebrisParticles_R", "500"));
            doFreezing = Boolean.parseBoolean(properties.getProperty("Weather_doFreezing", "true"));
            clusterChanceBase = Integer.parseInt(properties.getProperty("Clusters_baseStormChanceOutOf100", "22"));
            maxDaysNoCluster = Integer.parseInt(properties.getProperty("Clusters_maxDaysNoStorm", "4"));
            doClusters = Boolean.parseBoolean(properties.getProperty("Clusters_enable", "true"));
            maxClusters = Integer.parseInt(properties.getProperty("Clusters_maxStorms", "2"));
            lowerClouds = Boolean.parseBoolean(properties.getProperty("Misc_useOldCloudHeight", "true"));
            simpleForcedChunks = Boolean.parseBoolean(properties.getProperty("Storm_forceMinimumChunks", "false"));
            cityDestructionMode = Boolean.parseBoolean(properties.getProperty("Storm_cityDestructionMode_R", "false"));
            stormStageIntensitySpeed = Integer.parseInt(properties.getProperty("Storm_intensitySpeed", "5000"));
            mimicOldParticles = Boolean.parseBoolean(properties.getProperty("Misc_useOldParticles_R", "false"));
            emissiveParticles = Boolean.parseBoolean(properties.getProperty("Misc_emissiveParticles_R", "true"));
            disablePuzzleChambers = Boolean.parseBoolean(properties.getProperty("Misc_disablePuzzleChambers", "false"));
            constructItemSpeedLvl = Integer.parseInt(properties.getProperty("Misc_constructItemSpeedLvl", "1"));
            debug = Boolean.parseBoolean(properties.getProperty("debug_R", "false"));
            generateParticleOverride = Boolean.parseBoolean(properties.getProperty("experimental_generateParticleOverrideFile_R", "false"));
            baseTornadoDuration = Integer.parseInt(properties.getProperty("Storm_tornadoBaseDuration", "2400"));
            noRopes = Boolean.parseBoolean(properties.getProperty("Storm_disableVariants", "false"));
            maxTornadoes = class_3532.method_15340((int)maxTornadoes, (int)0, (int)10);
            maxDaysNoRain = class_3532.method_15340((int)maxDaysNoRain, (int)0, (int)20);
            maxDaysNoStorm = class_3532.method_15340((int)maxDaysNoStorm, (int)0, (int)20);
            maxRainNoDownpour = class_3532.method_15340((int)maxRainNoDownpour, (int)0, (int)20);
            maxWindNoGale = class_3532.method_15340((int)maxWindNoGale, (int)0, (int)20);
            rainChanceBase = class_3532.method_15340((int)rainChanceBase, (int)0, (int)100);
            stormChanceBase = class_3532.method_15340((int)stormChanceBase, (int)0, (int)100);
            rainWorsenChance = class_3532.method_15340((int)rainWorsenChance, (int)0, (int)100);
            tornadoDestructionLvl = (byte)class_3532.method_15340((int)tornadoDestructionLvl, (int)0, (int)2);
            waterspoutFrequency = class_3532.method_15340((int)waterspoutFrequency, (int)0, (int)100);
            tornadoFrequency = class_3532.method_15340((int)tornadoFrequency, (int)0, (int)100);
            maxDebrisPerTornado = class_3532.method_15340((int)maxDebrisPerTornado, (int)0, (int)300);
            maxMobsPerTornado = class_3532.method_15340((int)maxMobsPerTornado, (int)0, (int)100);
            tornadoesBiasIntensityLvl = (byte)class_3532.method_15340((int)tornadoesBiasIntensityLvl, (int)0, (int)2);
            stormBecomeSevereStormChance = class_3532.method_15340((int)stormBecomeSevereStormChance, (int)0, (int)100);
            maxTornadoLoadDistance = class_3532.method_15340((int)maxTornadoLoadDistance, (int)256, (int)1024);
            apexOnlyChance = class_3532.method_15340((int)apexOnlyChance, (int)0, (int)100);
            stageForceHighIfLongStormChance = class_3532.method_15340((int)stageForceHighIfLongStormChance, (int)0, (int)100);
            stage2Chance = class_3532.method_15340((int)stage2Chance, (int)0, (int)100);
            stage3ChanceIfNot2 = class_3532.method_15340((int)stage3ChanceIfNot2, (int)0, (int)100);
            stage4ChanceIfNot3 = class_3532.method_15340((int)stage4ChanceIfNot3, (int)0, (int)100);
            cursedStormChance = class_3532.method_15340((int)cursedStormChance, (int)0, (int)100);
            passiveFirenadoChance = class_3532.method_15340((int)passiveFirenadoChance, (int)0, (int)100);
            tornadoDetectorRange = class_3532.method_15340((int)tornadoDetectorRange, (int)16, (int)512);
            maxDebrisParticles = class_3532.method_15340((int)maxDebrisParticles, (int)0, (int)1000);
            clusterChanceBase = class_3532.method_15340((int)clusterChanceBase, (int)0, (int)100);
            maxDaysNoCluster = class_3532.method_15340((int)maxDaysNoCluster, (int)0, (int)20);
            stormStageIntensitySpeed = class_3532.method_15340((int)stormStageIntensitySpeed, (int)500, (int)10000);
            constructItemSpeedLvl = (byte)class_3532.method_15340((int)constructItemSpeedLvl, (int)0, (int)2);
            baseTornadoDuration = class_3532.method_15340((int)baseTornadoDuration, (int)500, (int)8000);
            String prefix = "BlockListAdd_";
            List matchingKeys = properties.stringPropertyNames().stream().filter(k -> k.startsWith(prefix)).collect(Collectors.toList());
            for (String key : matchingKeys) {
                String value = properties.getProperty(key);
                String blockId = key.substring(prefix.length());
                TornadoDestructionInfo.BlockDestroyType type = null;
                switch (value) {
                    case "RIP": {
                        type = TornadoDestructionInfo.BlockDestroyType.RIP;
                        break;
                    }
                    case "ONLY_RIP": {
                        type = TornadoDestructionInfo.BlockDestroyType.MUST_RIP;
                        break;
                    }
                    case "RARE_RIP": {
                        type = TornadoDestructionInfo.BlockDestroyType.RARE_RIP;
                        break;
                    }
                    case "BREAK": {
                        type = TornadoDestructionInfo.BlockDestroyType.BREAK;
                        break;
                    }
                    case "PROTECT": {
                        type = TornadoDestructionInfo.BlockDestroyType.PROTECT;
                    }
                }
                if (type == null) continue;
                CUSTOM_BLOCK_LIST.put(blockId, type);
                WeatherClassic.LOGGER.info("Added Custom Block Info for: " + blockId);
            }
            WARN_DUE_TO_OUTDATED_VERSION = ModConfig.containsOutdatedInfo(properties);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean containsOutdatedInfo(Properties p) {
        return !p.containsKey("!WCV!") || Byte.parseByte(p.getProperty("!WCV!")) != 14;
    }

    public static float getGlobalHeightScaleOverride() {
        return globalheightScale;
    }

    public static boolean loadParticleOverrideConfig() throws IOException {
        if (!generateParticleOverride) {
            return false;
        }
        boolean hadToCreate = false;
        File dataFile = overrideDir.toFile();
        if (!dataFile.exists()) {
            if (!dataFile.createNewFile()) {
                throw new IOException("CRITICAL ERROR: Could not create overrides for Weather & Tornadoes Remastered!");
            }
            hadToCreate = true;
        }
        ModConfig.addParticleOverrideConfigs(dataFile);
        ModConfig.loadParticleConfig(dataFile);
        return !hadToCreate;
    }

    private static void addParticleOverrideConfigs(File dataFile) {
        Properties properties = new Properties();
        if (dataFile.exists()) {
            try (FileInputStream input = new FileInputStream(dataFile);){
                properties.load(input);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!properties.containsKey("Spout_count")) {
            properties.setProperty("Spout_count", String.valueOf(-1));
        }
        if (!properties.containsKey("Spout_base")) {
            properties.setProperty("Spout_base", String.valueOf(-1));
        }
        if (!properties.containsKey("Spout_bottom")) {
            properties.setProperty("Spout_bottom", String.valueOf(-1));
        }
        if (!properties.containsKey("Spout_mid")) {
            properties.setProperty("Spout_mid", String.valueOf(-1));
        }
        if (!properties.containsKey("Spout_top")) {
            properties.setProperty("Spout_top", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage2_count")) {
            properties.setProperty("Stage2_count", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage2_base")) {
            properties.setProperty("Stage2_base", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage2_bottom")) {
            properties.setProperty("Stage2_bottom", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage2_mid")) {
            properties.setProperty("Stage2_mid", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage2_top")) {
            properties.setProperty("Stage2_top", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage3_count")) {
            properties.setProperty("Stage3_count", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage3_base")) {
            properties.setProperty("Stage3_base", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage3_bottom")) {
            properties.setProperty("Stage3_bottom", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage3_mid")) {
            properties.setProperty("Stage3_mid", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage3_top")) {
            properties.setProperty("Stage3_top", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage4_count")) {
            properties.setProperty("Stage4_count", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage4_base")) {
            properties.setProperty("Stage4_base", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage4_bottom")) {
            properties.setProperty("Stage4_bottom", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage4_mid")) {
            properties.setProperty("Stage4_mid", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage4_top")) {
            properties.setProperty("Stage4_top", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage5_count")) {
            properties.setProperty("Stage5_count", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage5_base")) {
            properties.setProperty("Stage5_base", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage5_bottom")) {
            properties.setProperty("Stage5_bottom", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage5_mid")) {
            properties.setProperty("Stage5_mid", String.valueOf(-1));
        }
        if (!properties.containsKey("Stage5_top")) {
            properties.setProperty("Stage5_top", String.valueOf(-1));
        }
        if (!properties.containsKey("GlobalHeight_scale")) {
            properties.setProperty("GlobalHeight_scale", String.valueOf(1.2));
        }
        try (FileOutputStream output = new FileOutputStream(dataFile);){
            properties.store(output, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadParticleConfig(File dataFile) {
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(dataFile);){
            properties.load(input);
            byte spoutCount = Byte.parseByte(properties.getProperty("Spout_count", "-1"));
            float spoutBase = Float.parseFloat(properties.getProperty("Spout_base", "-1"));
            float spoutBottom = Float.parseFloat(properties.getProperty("Spout_bottom", "-1"));
            float spoutMid = Float.parseFloat(properties.getProperty("Spout_mid", "-1"));
            float spoutTop = Float.parseFloat(properties.getProperty("Spout_top", "-1"));
            spoutBase = class_3532.method_15363((float)spoutBase, (float)-1.0f, (float)1.0f);
            spoutBottom = class_3532.method_15363((float)spoutBottom, (float)-1.0f, (float)1.0f);
            spoutMid = class_3532.method_15363((float)spoutMid, (float)-1.0f, (float)1.0f);
            spoutTop = class_3532.method_15363((float)spoutTop, (float)-1.0f, (float)1.0f);
            PARTICLE_OVERRIDE_CONFIGS.put((byte)0, new TornadoParticleConfig(spoutCount, spoutBase, spoutBottom, spoutMid, spoutTop));
            byte stage2count = Byte.parseByte(properties.getProperty("Stage2_count", "-1"));
            float stage2base = Float.parseFloat(properties.getProperty("Stage2_base", "-1"));
            float stage2bottom = Float.parseFloat(properties.getProperty("Stage2_bottom", "-1"));
            float stage2mid = Float.parseFloat(properties.getProperty("Stage2_mid", "-1"));
            float stage2top = Float.parseFloat(properties.getProperty("Stage2_top", "-1"));
            stage2base = class_3532.method_15363((float)stage2base, (float)-1.0f, (float)1.0f);
            stage2bottom = class_3532.method_15363((float)stage2bottom, (float)-1.0f, (float)1.0f);
            stage2mid = class_3532.method_15363((float)stage2mid, (float)-1.0f, (float)1.0f);
            stage2top = class_3532.method_15363((float)stage2top, (float)-1.0f, (float)1.0f);
            PARTICLE_OVERRIDE_CONFIGS.put((byte)1, new TornadoParticleConfig(stage2count, stage2base, stage2bottom, stage2mid, stage2top));
            byte stage3count = Byte.parseByte(properties.getProperty("Stage3_count", "-1"));
            float stage3base = Float.parseFloat(properties.getProperty("Stage3_base", "-1"));
            float stage3bottom = Float.parseFloat(properties.getProperty("Stage3_bottom", "-1"));
            float stage3mid = Float.parseFloat(properties.getProperty("Stage3_mid", "-1"));
            float stage3top = Float.parseFloat(properties.getProperty("Stage3_top", "-1"));
            stage3base = class_3532.method_15363((float)stage3base, (float)-1.0f, (float)1.0f);
            stage3bottom = class_3532.method_15363((float)stage3bottom, (float)-1.0f, (float)1.0f);
            stage3mid = class_3532.method_15363((float)stage3mid, (float)-1.0f, (float)1.0f);
            stage3top = class_3532.method_15363((float)stage3top, (float)-1.0f, (float)1.0f);
            PARTICLE_OVERRIDE_CONFIGS.put((byte)2, new TornadoParticleConfig(stage3count, stage3base, stage3bottom, stage3mid, stage3top));
            byte stage4count = Byte.parseByte(properties.getProperty("Stage4_count", "-1"));
            float stage4base = Float.parseFloat(properties.getProperty("Stage4_base", "-1"));
            float stage4bottom = Float.parseFloat(properties.getProperty("Stage4_bottom", "-1"));
            float stage4mid = Float.parseFloat(properties.getProperty("Stage4_mid", "-1"));
            float stage4top = Float.parseFloat(properties.getProperty("Stage4_top", "-1"));
            stage4base = class_3532.method_15363((float)stage4base, (float)-1.0f, (float)1.0f);
            stage4bottom = class_3532.method_15363((float)stage4bottom, (float)-1.0f, (float)1.0f);
            stage4mid = class_3532.method_15363((float)stage4mid, (float)-1.0f, (float)1.0f);
            stage4top = class_3532.method_15363((float)stage4top, (float)-1.0f, (float)1.0f);
            PARTICLE_OVERRIDE_CONFIGS.put((byte)3, new TornadoParticleConfig(stage4count, stage4base, stage4bottom, stage4mid, stage4top));
            byte stage5count = Byte.parseByte(properties.getProperty("Stage5_count", "-1"));
            float stage5base = Float.parseFloat(properties.getProperty("Stage5_base", "-1"));
            float stage5bottom = Float.parseFloat(properties.getProperty("Stage5_bottom", "-1"));
            float stage5mid = Float.parseFloat(properties.getProperty("Stage5_mid", "-1"));
            float stage5top = Float.parseFloat(properties.getProperty("Stage5_top", "-1"));
            stage5base = class_3532.method_15363((float)stage5base, (float)-1.0f, (float)1.0f);
            stage5bottom = class_3532.method_15363((float)stage5bottom, (float)-1.0f, (float)1.0f);
            stage5mid = class_3532.method_15363((float)stage5mid, (float)-1.0f, (float)1.0f);
            stage5top = class_3532.method_15363((float)stage5top, (float)-1.0f, (float)1.0f);
            PARTICLE_OVERRIDE_CONFIGS.put((byte)4, new TornadoParticleConfig(stage5count, stage5base, stage5bottom, stage5mid, stage5top));
            globalheightScale = Float.parseFloat(properties.getProperty("GlobalHeight_scale", "1.2"));
            globalheightScale = (float)class_3532.method_15350((double)globalheightScale, (double)0.5, (double)3.0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getTornadoCloudScale(boolean custom) {
        float scale;
        float f = scale = custom ? CustomTornadoConfig.getScaling() : ModConfig.getGlobalHeightScaleOverride();
        if ((double)scale <= 1.2) {
            return 72;
        }
        float minScale = 1.2f;
        float maxScale = 3.0f;
        float minHeight = 72.0f;
        float maxHeight = 200.0f;
        float denom = maxScale - minScale;
        float t = denom == 0.0f ? 0.0f : (scale - minScale) / denom;
        t = Math.max(0.0f, Math.min(1.0f, t));
        float height = minHeight + t * (maxHeight - minHeight);
        return (int)height;
    }

    public static int getTornadoBoxScale(boolean custom) {
        float scale;
        float f = scale = custom ? CustomTornadoConfig.getScaling() : ModConfig.getGlobalHeightScaleOverride();
        if ((double)scale == 1.2) {
            return 64;
        }
        float minScale = 0.5f;
        float maxScale = 3.0f;
        float minHeight = 46.0f;
        float maxHeight = 200.0f;
        float denom = maxScale - minScale;
        float t = denom == 0.0f ? 0.0f : (scale - minScale) / denom;
        t = Math.max(0.0f, Math.min(1.0f, t));
        float height = minHeight + t * (maxHeight - minHeight);
        return (int)height;
    }
}

