/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.entity.random;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1590;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_4140;
import net.minecraft.class_4142;
import net.minecraft.class_4538;
import net.minecraft.class_4760;
import net.minecraft.class_5136;
import net.minecraft.class_5137;
import net.minecraft.class_5418;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.weather_classic.WeatherClassic;
import net.weather_classic.entity.random.goal.EatCrimsonFungusGoal;
import net.weather_classic.entity.random.goal.GreaterHoglinWanderAroundTerritoryGoal;
import net.weather_classic.help.BP;
import net.weather_classic.help.Materials;
import net.weather_classic.help.Utils;

public class GreaterHoglinEntity
extends class_1588
implements class_5137,
class_1569 {
    private int movementCooldownTicks = 0;
    private final class_1937 world;
    private int timeAwayFromTerritory = 0;
    public static final class_2940<Boolean> HAS_TARGET = class_2945.method_12791(GreaterHoglinEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<class_2338> TERRITORY = class_2945.method_12791(GreaterHoglinEntity.class, (class_2941)class_2943.field_13324);

    public GreaterHoglinEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.world = world;
        this.method_5941(class_7.field_14, -1.0f);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_3, -1.0f);
        this.field_6194 = 15;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_TARGET, (Object)false);
        builder.method_56912(TERRITORY, (Object)Utils.effectivelyNull);
    }

    protected void method_5959() {
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 10.0f));
        this.field_6201.method_6277(7, (class_1352)new GreaterHoglinWanderAroundTerritoryGoal(this, 0.75));
        this.field_6201.method_6277(8, (class_1352)new EatCrimsonFungusGoal((class_1308)this, 0.75f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[]{class_4760.class}).method_6318(new Class[]{class_5136.class}));
        class_4051.class_10254 predicate = new class_4051.class_10254(){

            public boolean method_18303(class_1309 target, class_3218 world) {
                return !GreaterHoglinEntity.this.invalidTarget(target);
            }
        };
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, false, predicate));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_5418.class, true, predicate));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, class_1590.class, true, predicate));
    }

    public void method_5773() {
        super.method_5773();
        if (!this.world.method_8608()) {
            if (this.getTerritoryPos() == Utils.effectivelyNull || this.getTerritoryPos() == null) {
                if (this.method_24828()) {
                    this.setTerritoryPos(this.method_24515());
                    for (int i = 0; i < 15; ++i) {
                        ((class_3218)this.world).method_65096((class_2394)class_2398.field_11211, (double)this.method_31477() + 0.5, this.method_23318() + (double)this.field_5974.method_43048(3) + (double)this.field_5974.method_43057(), (double)this.method_31479() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                return;
            }
            if (Utils.distanceXYZ(this.method_24515(), this.getTerritoryPos()) > (double)this.getTerritorySize() || Math.abs(this.method_31478() - this.getTerritoryPos().method_10264()) > 24) {
                if (this.field_5974.method_43048(10) == 0) {
                    ((class_3218)this.world).method_65096((class_2394)class_2398.field_11231, this.method_23322(1.0), this.method_23318() + (double)this.world.method_8409().method_43048(3), this.method_23325(1.0), 0, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.timeAwayFromTerritory++ > this.maxTimeAwayFromTerritory()) {
                    this.timeAwayFromTerritory = 0;
                    this.setTerritoryPos(null);
                    return;
                }
            } else if (this.timeAwayFromTerritory > 0) {
                this.timeAwayFromTerritory = 0;
            }
            int range = 12;
            if (this.method_5968() != null) {
                if (this.invalidTarget(this.method_5968())) {
                    this.method_5980(null);
                    this.field_6185.method_35115().forEach(p -> {
                        if (p.method_19058() instanceof class_1399 && p.method_19056()) {
                            p.method_6270();
                        }
                    });
                    return;
                }
                if (!this.isAngry()) {
                    this.method_5783(class_3417.field_23673, 1.0f, 0.5f + this.field_5974.method_43057() * 0.4f);
                    this.markAngry();
                }
                if (this.field_6012 % 40 == 0) {
                    List others = this.world.method_8333(null, this.method_5829().method_1009((double)range, 8.0, (double)range), p -> (p instanceof class_5418 || p instanceof class_4760) && Utils.canSeeGenerous(p, this.method_24515()));
                    for (class_1297 ent : others) {
                        if (ent instanceof class_5418) {
                            class_5418 piglin = (class_5418)ent;
                            if (piglin.method_18868().method_18896(class_4140.field_22357)) continue;
                            piglin.method_18868().method_18878(class_4140.field_22357, (Object)this);
                            piglin.method_5783(class_3417.field_22270, 0.8f, 0.9f + this.field_5974.method_43057() / 3.0f);
                            continue;
                        }
                        class_4760 hoglin = (class_4760)ent;
                        if (hoglin.method_18868().method_18896(class_4140.field_22355)) continue;
                        hoglin.method_18868().method_18878(class_4140.field_22355, (Object)this.method_5968());
                    }
                }
            } else {
                if (this.isAngry()) {
                    this.markUnangry();
                }
                if (this.field_6012 % 120 == 0) {
                    List hoglins = this.world.method_8333(null, this.method_5829().method_1009((double)(range * 2), 8.0, (double)(range * 2)), p -> p instanceof class_4760 && Utils.canSeeGenerous(p, this.getTerritoryPos()));
                    int num = 0;
                    for (class_1297 ent : hoglins) {
                        class_4760 hoglin = (class_4760)ent;
                        if (hoglin.method_6109()) continue;
                        if (++num <= 5) {
                            boolean farEnough;
                            if ((double)ent.method_59922().method_43057() < 0.5) {
                                for (int i = 0; i < 5; ++i) {
                                    ((class_3218)this.world).method_65096((class_2394)class_2398.field_11211, hoglin.method_23322(1.0), hoglin.method_23318() + (double)this.world.method_8409().method_43048(3), hoglin.method_23325(1.0), 0, 0.0, 0.0, 0.0, 0.0);
                                }
                            }
                            boolean noTarget = !hoglin.method_18868().method_18896(class_4140.field_22355);
                            boolean bl = farEnough = Utils.distanceXYZ(this.getTerritoryPos(), hoglin.method_24515()) > 10.0;
                            if (!((double)this.field_5974.method_43057() < 0.65) || !farEnough || !noTarget) continue;
                            int distance = 2 + this.field_5974.method_43048(5);
                            if (hoglin.method_18868().method_18896(class_4140.field_18445)) {
                                hoglin.method_18868().method_18875(class_4140.field_18445);
                            }
                            hoglin.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(this.getTerritoryPos(), 0.75f, distance));
                            continue;
                        }
                        break;
                    }
                }
            }
            if (this.field_6012 % 40 == 0 && this.isAngry() && ((Boolean)((class_3218)this.world).method_64395().method_76185(class_1928.field_19388)).booleanValue()) {
                for (class_2338 next : class_2338.method_10097((class_2338)BP.of(this.method_5829().field_1323 - 1.0, this.method_23318(), this.method_5829().field_1321 - 1.0), (class_2338)BP.of(this.method_5829().field_1320 + 1.0, this.method_23318() + (double)this.method_17682() + 1.0, this.method_5829().field_1324 + 1.0))) {
                    if (!Materials.isFence(this.world.method_8320(next)) && !this.world.method_8320(next).method_26164(class_3481.field_21954)) continue;
                    this.world.method_22352(next, Materials.isFence(this.world.method_8320(next)) || (double)this.field_5974.method_43057() < 0.3);
                    this.method_73183().method_8421((class_1297)this, (byte)4);
                    if (!((double)this.field_5974.method_43057() < 0.2)) continue;
                    this.method_5783(WeatherClassic.GREATER_HOGLIN_ANGRY, 1.0f, 0.5f + this.field_5974.method_43057() * 0.4f);
                }
            }
        }
    }

    public void method_6007() {
        if (this.movementCooldownTicks > 0) {
            --this.movementCooldownTicks;
        }
        super.method_6007();
    }

    public void method_5711(byte status) {
        if (status == 4) {
            this.movementCooldownTicks = 10;
        } else {
            super.method_5711(status);
        }
    }

    public int getTerritorySize() {
        return 36;
    }

    private int maxTimeAwayFromTerritory() {
        return 800;
    }

    public boolean invalidTarget(class_1309 entity) {
        return Utils.inInvalidMode((class_1297)entity) || this.tooFarFromTerritory(entity.method_24515()) || Math.abs(entity.method_31478() - this.method_31478()) > 4;
    }

    public boolean tooFarFromTerritory(class_2338 pos) {
        if (this.getTerritoryPos() == null || this.getTerritoryPos() == Utils.effectivelyNull) {
            return false;
        }
        return Utils.distanceXYZ(pos, this.getTerritoryPos()) > (double)this.getTerritorySize();
    }

    public boolean method_6121(class_3218 world, class_1297 target) {
        class_1309 living;
        class_1799 blocking;
        if (!(target instanceof class_1309) || this.movementCooldownTicks > 0) {
            return false;
        }
        this.method_73183().method_8421((class_1297)this, (byte)4);
        this.method_5783((double)this.field_5974.method_43057() > 0.7 ? WeatherClassic.GREATER_HOGLIN_ANGRY : class_3417.field_23674, 1.0f, this.method_6017() - 0.3f);
        boolean result = class_5137.method_26950((class_3218)world, (class_1309)this, (class_1309)((class_1309)target));
        boolean blocked = false;
        if (target instanceof class_1309 && (blocking = (living = (class_1309)target).method_62821()) != null) {
            blocked = true;
        }
        this.movementCooldownTicks = blocked ? 40 : 20;
        return result;
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        if (source == world.method_48963().method_48827()) {
            if (amount <= 6.0f) {
                this.method_5783(WeatherClassic.BLOCK_LAUNCHER, 2.0f, 0.1f);
                return false;
            }
            amount /= 2.0f;
        }
        if (source.method_5529() != null && source.method_5529().method_23320() > this.method_23318() + ((double)this.method_17682() + 0.5)) {
            this.method_5783(class_3417.field_24068, 1.0f, 1.5f);
            return false;
        }
        return super.method_64397(world, source, amount);
    }

    protected class_3414 method_5994() {
        return this.isAngry() ? WeatherClassic.GREATER_HOGLIN_ANGRY : WeatherClassic.GREATER_HOGLIN_LIVE;
    }

    protected class_3414 method_6011(class_1282 source) {
        this.method_5783(class_3417.field_22260, 1.0f, 0.5f + this.field_5974.method_43057() * 0.2f);
        return null;
    }

    protected class_3414 method_6002() {
        return class_3417.field_23675;
    }

    protected class_3414 method_5737() {
        return class_3417.field_14630;
    }

    protected class_3414 method_5625() {
        return class_3417.field_14836;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_22262, 0.7f, 0.4f + this.field_5974.method_43057() * 0.2f);
    }

    protected void method_6060(class_1309 target) {
        if (!this.method_6109()) {
            class_5137.method_26951((class_1309)this, (class_1309)target);
        }
    }

    public boolean canConvert() {
        return !this.method_5987();
    }

    public int method_24657() {
        return this.movementCooldownTicks;
    }

    public void markAngry() {
        this.field_6011.method_12778(HAS_TARGET, (Object)true);
    }

    public void markUnangry() {
        this.field_6011.method_12778(HAS_TARGET, (Object)false);
    }

    public boolean isAngry() {
        return (Boolean)this.method_5841().method_12789(HAS_TARGET);
    }

    public int method_5945() {
        return 1;
    }

    public boolean method_5947() {
        return true;
    }

    public void setTerritoryPos(class_2338 pos) {
        if (pos == null) {
            pos = Utils.effectivelyNull;
        }
        this.method_5841().method_12778(TERRITORY, (Object)pos);
    }

    public class_2338 getTerritoryPos() {
        return (class_2338)this.method_5841().method_12789(TERRITORY);
    }

    public void method_5652(class_11372 nbt) {
        super.method_5652(nbt);
        if (!this.world.method_8608()) {
            this.writeTerritory(nbt);
            nbt.method_71465("taft", this.timeAwayFromTerritory);
        }
    }

    public void method_5749(class_11368 nbt) {
        super.method_5749(nbt);
        if (!this.world.method_8608()) {
            this.readTerritoryNBT(nbt);
            nbt.method_71426("taft", (Codec)Codec.INT).ifPresent(p -> {
                this.timeAwayFromTerritory = p;
            });
        }
    }

    private void writeTerritory(class_11372 nbt) {
        nbt.method_71465("terX", this.getTerritoryPos().method_10263());
        nbt.method_71465("terY", this.getTerritoryPos().method_10264());
        nbt.method_71465("terZ", this.getTerritoryPos().method_10260());
    }

    private void readTerritoryNBT(class_11368 nbt) {
        class_2338 bp = Utils.readBlockPos(nbt, "ter");
        this.setTerritoryPos(bp);
    }

    public boolean method_5957(class_4538 world) {
        class_2680 downState = world.method_8320(this.method_24515().method_10074());
        return !downState.method_26164(class_3481.field_21954) && !downState.method_27852(class_2246.field_10266) && super.method_5957(world);
    }

    public boolean method_5979(class_1936 world, class_3730 spawnReason) {
        return spawnReason != class_3730.field_16459 || world.method_18467(GreaterHoglinEntity.class, this.method_5829().method_1009(64.0, 36.0, 64.0)).isEmpty();
    }

    public boolean method_5969(int count) {
        return count > 1;
    }

    public static boolean canSpawn(class_1299<GreaterHoglinEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return !world.method_8320(pos.method_10074()).method_26164(class_3481.field_21954);
    }
}

